/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstructionsList
extends AbstractContainerEventHandler
implements Widget {
    static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/resource_packs.png");
    private final List<InstructionEntry> children = new ArrayList<InstructionEntry>();
    private final List<Instruction> instructions;
    private final Minecraft minecraft;
    @Nullable
    private InstructionEntry selected;
    @Nullable
    private InstructionEntry hovered;
    protected int width = 200;
    protected int y0 = 5;
    protected int y1 = this.y0 + 300;
    protected int x0 = 5;
    protected int x1 = this.x0 + this.width;
    protected int itemHeight = 20;
    protected int rowWidth = this.x1 - this.x0 - 10;
    private final Button removeButton;
    private final Button upButton;
    private final Button downButton;
    private double dragStartX;
    private double dragStartY;
    private double dragMoveX;
    private double dragMoveY;
    private int dragIndex = -1;
    private boolean dragOffset;
    private InstructionEntry dragging;

    public InstructionsList(InstructionTab.Pair pair, Minecraft minecraft) {
        this.minecraft = minecraft;
        this.instructions = pair.instructions();
        this.instructions.forEach(instruction -> this.children.add(new InstructionEntry((Instruction)instruction, minecraft)));
        this.removeButton = new Button(this.x0, this.y1 + 5, 70, 20, (Component)new TextComponent("Remove item"), button -> {
            if (this.selected != null) {
                this.instructions.remove(this.children.indexOf(this.selected));
                this.children.remove(this.selected);
                this.selected = null;
                if (!this.children.isEmpty()) {
                    this.selected = this.children.get(0);
                }
            }
        });
        this.upButton = new Button(this.x0 + 110, this.y1 + 5, 20, 20, (Component)new TextComponent(""), button -> {
            int i = this.children.indexOf(this.selected);
            if (i != 0) {
                Collections.swap(this.children, i, i - 1);
                Collections.swap(this.instructions, i, i - 1);
            }
        }){

            public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super.m_6303_(poseStack, mouseX, mouseY, partialTick);
                RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_OVERLAY_LOCATION);
                int left = this.f_93620_ + this.f_93618_ / 2;
                int top = this.f_93621_ + (this.f_93619_ - 8) / 2;
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(left - 8), (int)(top - 5), (float)111.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
            }
        };
        this.downButton = new Button(this.x0 + 80, this.y1 + 5, 20, 20, (Component)new TextComponent(""), button -> {
            int i = this.children.indexOf(this.selected);
            if (i != this.children.size() - 1) {
                Collections.swap(this.children, i, i + 1);
                Collections.swap(this.instructions, i, i + 1);
            }
        }){

            public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super.m_6303_(poseStack, mouseX, mouseY, partialTick);
                RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_OVERLAY_LOCATION);
                int left = this.f_93620_ + this.f_93618_ / 2;
                int top = this.f_93621_ + (this.f_93619_ - 8) / 2;
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(left - 23), (int)(top - 4), (float)64.0f, (float)16.0f, (int)32, (int)32, (int)256, (int)256);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
            }
        };
    }

    public void addInstruction(Instruction instruction) {
        this.children.add(new InstructionEntry(instruction, this.minecraft));
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        InstructionTab.highlightInstructionEntity = null;
        InstructionTab.highlightInstruction = null;
        if (this.m_5953_(mouseX, mouseY)) {
            InstructionEntry entry = this.getEntryAtPosition(mouseX, mouseY);
            if (entry != null) {
                if (entry.m_6375_(mouseX, mouseY, button)) {
                    this.m_7522_(entry);
                    this.m_7897_(true);
                    return true;
                }
            } else if (button == 0) {
                this.selected = null;
                return true;
            }
        }
        if (this.removeButton.m_5953_(mouseX, mouseY)) {
            return this.removeButton.m_6375_(mouseX, mouseY, button);
        }
        if (this.upButton.m_5953_(mouseX, mouseY)) {
            return this.upButton.m_6375_(mouseX, mouseY, button);
        }
        if (this.downButton.m_5953_(mouseX, mouseY)) {
            return this.downButton.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging != null) {
            if (this.dragging.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                Pair<Vec3, Vec3> pair = this.getPositionOfEntry(this.dragging);
                Vec3 compare = ((Vec3)pair.getFirst()).m_82520_(this.dragMoveX, this.dragMoveY, 0.0);
                if (compare.f_82479_ < (double)this.getRowLeft()) {
                    compare = ((Vec3)pair.getSecond()).m_82520_(this.dragMoveX, this.dragMoveY, 0.0);
                }
                InstructionEntry above = this.getEntryAtPosition(compare.f_82479_, compare.f_82480_ - (double)this.itemHeight / 2.0);
                InstructionEntry below = this.getEntryAtPosition(compare.f_82479_, compare.f_82480_ + (double)this.itemHeight / 2.0);
                this.dragIndex = above == null && below != null ? 0 : (below == null && above != null ? this.children.size() : this.children.indexOf(below));
                this.dragOffset = this.children.indexOf(this.dragging) < this.dragIndex;
                return true;
            }
            this.dragIndex = -1;
            return false;
        }
        InstructionEntry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            return entry.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    private int getRowLeft() {
        return this.x0 + this.width / 2 - this.rowWidth / 2;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        int prevIndex;
        int dragTarget;
        if (this.m_7222_() != null) {
            this.m_7222_().m_6348_(mouseX, mouseY, button);
        }
        if (this.dragging != null && this.dragIndex != -1 && (dragTarget = this.dragOffset ? this.dragIndex - 1 : this.dragIndex) != (prevIndex = this.children.indexOf(this.dragging))) {
            if (prevIndex < dragTarget) {
                Collections.rotate(this.children.subList(prevIndex, dragTarget + 1), -1);
                Collections.rotate(this.instructions.subList(prevIndex, dragTarget + 1), -1);
            } else {
                Collections.rotate(this.children.subList(dragTarget, prevIndex + 1), 1);
                Collections.rotate(this.instructions.subList(dragTarget, prevIndex + 1), 1);
            }
        }
        this.dragging = null;
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseY >= (double)this.y0 && mouseY <= (double)this.y1 && mouseX >= (double)this.x0 && mouseX <= (double)this.x1;
    }

    private Pair<Vec3, Vec3> getPositionOfEntry(InstructionEntry entry) {
        int left = this.getRowLeft();
        int right = left + this.rowWidth;
        int centerY = this.children.indexOf(entry) * this.itemHeight + this.y0 + 2 + this.itemHeight / 2;
        return new Pair((Object)new Vec3((double)left, (double)centerY, 0.0), (Object)new Vec3((double)right, (double)centerY, 0.0));
    }

    @Nullable
    private InstructionEntry getEntryAtPosition(double mouseX, double mouseY) {
        int left = this.getRowLeft();
        int right = left + this.rowWidth;
        int m = Mth.m_14107_((double)(mouseY - (double)this.y0)) - 2;
        int n = m / this.itemHeight;
        return mouseX >= (double)left && mouseX <= (double)right && n >= 0 && m >= 0 && n < this.children.size() ? (InstructionEntry)this.m_6702_().get(n) : null;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.y1 = Math.max(300, 300);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        this.hovered = this.m_5953_(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)this.x0, (double)this.y1, 0.0).m_7421_((float)this.x0 / 32.0f, (float)this.y1 / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.x1, (double)this.y1, 0.0).m_7421_((float)this.x1 / 32.0f, (float)this.y1 / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.x1, (double)this.y0, 0.0).m_7421_((float)this.x1 / 32.0f, (float)this.y0 / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.x0, (double)this.y0, 0.0).m_7421_((float)this.x0 / 32.0f, (float)this.y0 / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        int rowLeft = this.x0 + this.width / 2 - this.rowWidth / 2 + 2;
        this.renderList(poseStack, rowLeft, this.y0 + 4, mouseX, mouseY, partialTick);
        this.removeButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.upButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.downButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    protected void renderList(PoseStack poseStack, int x, int y, int mouseX, int mouseY, float partialTick) {
        int itemCount = this.children.size();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        int rowLeft = this.getRowLeft();
        int rowRight = rowLeft + this.rowWidth;
        int rowHeight = this.itemHeight - 4;
        for (int i = 0; i < itemCount; ++i) {
            int rowTop = y + i * this.itemHeight;
            int rowBottom = rowTop + this.itemHeight;
            if (rowBottom < this.y0 || rowTop > this.y1) continue;
            InstructionEntry entry = this.children.get(i);
            if (Objects.equals(this.selected, entry)) {
                this.renderEntry(tesselator, bufferBuilder, rowLeft, rowRight, rowTop, rowHeight);
            }
            entry.render(poseStack, rowTop, rowLeft, Objects.equals(this.hovered, entry) && this.dragging == null);
            if (!Objects.equals(this.dragging, entry)) continue;
            int dragLeft = (int)(this.dragStartX + this.dragMoveX + (double)this.width / 2.0 - (double)this.rowWidth / 2.0);
            int dragRight = (int)(this.dragStartX + this.dragMoveX + (double)this.width / 2.0 + (double)this.rowWidth / 2.0);
            int dragTop = (int)((double)rowTop + (this.dragStartY + this.dragMoveY - (double)this.y0));
            this.renderEntry(tesselator, bufferBuilder, dragLeft, dragRight, dragTop, rowHeight);
            entry.render(poseStack, dragTop, dragLeft, true);
        }
        if (this.dragging != null && this.dragIndex != -1) {
            int arrowLeft = rowLeft - 2;
            int arrowHeight = rowHeight / 2;
            int arrowTop = y + this.dragIndex * this.itemHeight - arrowHeight;
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172808_);
            if (this.dragIndex == this.children.indexOf(this.dragging) + (this.dragOffset ? 1 : 0)) {
                RenderSystem.m_157429_((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)0.5f, (float)1.0f, (float)0.5f, (float)1.0f);
            }
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85814_);
            bufferBuilder.m_5483_((double)arrowLeft, (double)(arrowTop + arrowHeight + 4), 0.0).m_5752_();
            bufferBuilder.m_5483_((double)(arrowLeft + 6), (double)arrowTop + (double)arrowHeight / 2.0 + 2.0, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)arrowLeft, (double)arrowTop, 0.0).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69493_();
        }
    }

    private void renderEntry(Tesselator tesselator, BufferBuilder bufferBuilder, int rowLeft, int rowRight, int rowTop, int rowHeight) {
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        float f = 0.75f;
        RenderSystem.m_157429_((float)f, (float)f, (float)f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_((double)rowLeft, (double)(rowTop + rowHeight + 2), 0.0).m_5752_();
        bufferBuilder.m_5483_((double)rowRight, (double)(rowTop + rowHeight + 2), 0.0).m_5752_();
        bufferBuilder.m_5483_((double)rowRight, (double)(rowTop - 2), 0.0).m_5752_();
        bufferBuilder.m_5483_((double)rowLeft, (double)(rowTop - 2), 0.0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_((double)(rowLeft + 1), (double)(rowTop + rowHeight + 1), 0.0).m_5752_();
        bufferBuilder.m_5483_((double)(rowRight - 1), (double)(rowTop + rowHeight + 1), 0.0).m_5752_();
        bufferBuilder.m_5483_((double)(rowRight - 1), (double)(rowTop - 1), 0.0).m_5752_();
        bufferBuilder.m_5483_((double)(rowLeft + 1), (double)(rowTop - 1), 0.0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69493_();
    }

    class InstructionEntry
    implements GuiEventListener {
        private final Instruction instruction;
        private final Minecraft minecraft;

        public InstructionEntry(Instruction instruction, Minecraft minecraft) {
            this.instruction = instruction;
            this.minecraft = minecraft;
        }

        public void render(PoseStack poseStack, int top, int left, boolean isMouseOver) {
            if (isMouseOver) {
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)new TextComponent(this.instruction.toString()), (int)(left + 4), (int)(top + 4), (int)Integer.parseUnsignedInt("a8a2a2", 16));
            } else {
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)new TextComponent(this.instruction.toString()), (int)(left + 4), (int)(top + 4), (int)Integer.parseUnsignedInt("ffffff", 16));
            }
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (button == 0) {
                if (InstructionsList.this.dragging == null) {
                    InstructionsList.this.dragStartX = InstructionsList.this.x0;
                    InstructionsList.this.dragStartY = InstructionsList.this.y0;
                    InstructionsList.this.dragMoveX = 0.0;
                    InstructionsList.this.dragMoveY = 0.0;
                }
                InstructionsList.this.dragging = this;
                InstructionsList.this.dragMoveX += dragX;
                InstructionsList.this.dragMoveY += dragY;
                return true;
            }
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                InstructionsList.this.selected = this;
                InstructionTab.highlightInstruction = this.instruction;
                return true;
            }
            return false;
        }
    }
}

