/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Target;
import org.jetbrains.annotations.Nullable;

public class PlayerPathFinder {
    protected static final float FUDGING = 1.5f;
    protected final Node[] neighbors = new Node[32];
    protected int maxVisitedNodes;
    public final PlayerNodeEvaluator nodeEvaluator;
    protected final BinaryHeap openSet = new BinaryHeap();
    protected final List<Node> closedSet = new ArrayList<Node>();

    public PlayerPathFinder(PlayerNodeEvaluator nE, int i) {
        this.nodeEvaluator = nE;
        this.maxVisitedNodes = i;
    }

    @Nullable
    public PlayerPath findPath(PathNavigationRegion region, Player player, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.openSet.m_77081_();
        this.closedSet.clear();
        this.nodeEvaluator.prepare(region, player);
        Node node = this.nodeEvaluator.getStart();
        Map<Target, BlockPos> map = targetPositions.stream().collect(Collectors.toMap(blockPos -> this.nodeEvaluator.getGoal(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), Function.identity()));
        PlayerPath path = this.findPath(node, map, maxRange, accuracy, searchDepthMultiplier);
        this.nodeEvaluator.done();
        if (path != null) {
            path.setDebug(this.openSet.m_164684_(), (Node[])this.closedSet.toArray(Node[]::new), map.keySet());
        }
        return path;
    }

    @Nullable
    protected PlayerPath findPath(Node node, Map<Target, BlockPos> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        Set<Target> set = targetPos.keySet();
        node.f_77275_ = 0.0f;
        node.f_77277_ = node.f_77276_ = this.getBestH(node, set);
        this.openSet.m_77081_();
        this.openSet.m_77084_(node);
        int i = 1;
        HashSet set3 = Sets.newHashSetWithExpectedSize((int)set.size());
        int j = (int)((float)this.maxVisitedNodes * searchDepthMultiplier);
        while (!this.openSet.m_77092_() && i < j) {
            Node node2 = this.openSet.m_77091_();
            this.closedSet.add(node2);
            System.out.println(node2 + " f: " + node2.f_77277_ + " g: " + node2.f_77275_ + " h: " + node2.f_77276_);
            node2.f_77279_ = true;
            for (Target target2 : set) {
                if (node2.m_77304_((Node)target2) > (float)accuracy) continue;
                target2.m_77509_();
                set3.add(target2);
            }
            if (!set3.isEmpty()) break;
            if (node2.m_77293_(node) >= maxRange) continue;
            int k = this.nodeEvaluator.getNeighbors(this.neighbors, node2);
            for (int l = 0; l < k; ++l) {
                Node node3 = this.neighbors[l];
                float f = node2.m_77293_(node3);
                node3.f_77280_ = node2.f_77280_ + f;
                float g = node2.f_77275_ + f + node3.f_77281_;
                if (node3.f_77280_ >= maxRange || node3.m_77303_() && g >= node3.f_77275_) continue;
                node3.f_77278_ = node2;
                node3.f_77275_ = g;
                node3.f_77276_ = this.getBestH(node3, set) * 1.5f;
                if (node3.m_77303_()) {
                    this.openSet.m_77086_(node3, node3.f_77275_ + node3.f_77276_);
                    continue;
                }
                node3.f_77277_ = node3.f_77275_ + node3.f_77276_;
                System.out.println("Adding " + node3 + " f: " + node3.f_77277_ + " g: " + node3.f_77275_ + " h: " + node3.f_77276_);
                this.openSet.m_77084_(node3);
            }
            ++i;
        }
        Optional<PlayerPath> optional = !set3.isEmpty() ? set3.stream().map(target -> this.reconstructPath(target.m_77508_(), (BlockPos)targetPos.get(target), true)).min(Comparator.comparingInt(PlayerPath::getNodeCount)) : set.stream().map(target -> this.reconstructPath(target.m_77508_(), (BlockPos)targetPos.get(target), false)).min(Comparator.comparingDouble(PlayerPath::getDistToTarget).thenComparingInt(PlayerPath::getNodeCount));
        return optional.orElse(null);
    }

    float getBestH(Node node, Set<Target> targets) {
        float f = Float.MAX_VALUE;
        for (Target target : targets) {
            float g = node.m_77293_((Node)target);
            target.m_77503_(g, node);
            f = Math.min(g, f);
        }
        return f;
    }

    PlayerPath reconstructPath(Node point, BlockPos targetPos, boolean reachesTarget) {
        ArrayList list = Lists.newArrayList();
        Node node = point;
        list.add(0, node);
        while (node.f_77278_ != null) {
            node = node.f_77278_;
            list.add(0, node);
        }
        return new PlayerPath(list, targetPos, reachesTarget);
    }
}

