/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.model.PrehistoricAnimatableModel;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Trilobite;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;

public class PrehistoricGeoModel<T extends Prehistoric>
extends PrehistoricAnimatableModel<T> {
    private final ResourceLocation modelLocation;
    private final ResourceLocation animationLocation;

    public PrehistoricGeoModel(String modelName, String animationName) {
        this.modelLocation = FossilMod.location("geo/entity/" + modelName);
        this.animationLocation = FossilMod.location("animations/" + animationName);
    }

    public void setCustomAnimations(T animatable, int instanceId, AnimationEvent animationEvent) {
        PrehistoricFlying flying;
        super.setCustomAnimations(animatable, instanceId, animationEvent);
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (animatable instanceof PrehistoricSwimming && animatable.m_20069_() || animatable instanceof PrehistoricFlying && (flying = (PrehistoricFlying)animatable).m_142592_()) {
            if (!animatable.m_20160_() && !(animatable instanceof Trilobite)) {
                IBone root = this.getAnimationProcessor().getBone("pitch_root");
                if (root != null) {
                    float pitch = Mth.m_14179_((float)animationEvent.getPartialTick(), (float)((Prehistoric)animatable).f_19860_, (float)animatable.m_146909_());
                    root.setRotationX(-pitch * ((float)Math.PI / 180) + root.getRotationX());
                }
            } else if (animatable instanceof PrehistoricFlying) {
                PrehistoricFlying flying2 = (PrehistoricFlying)animatable;
                IBone root = this.getAnimationProcessor().getBone("pitch_root");
                if (root != null && ((Prehistoric)animatable).m_6688_() instanceof Player) {
                    float pitch = Mth.m_14179_((float)animationEvent.getPartialTick(), (float)flying2.prevPitch, (float)flying2.currentPitch);
                    root.setRotationX(-pitch * ((float)Math.PI / 180) + root.getRotationX());
                    float yaw = Mth.m_14179_((float)animationEvent.getPartialTick(), (float)flying2.prevYaw, (float)flying2.currentYaw);
                    root.setRotationZ(yaw * ((float)Math.PI / 180) + root.getRotationZ());
                }
            }
        }
    }

    public ResourceLocation getModelLocation(T object) {
        return this.modelLocation;
    }

    public ResourceLocation getTextureLocation(T object) {
        if (((Prehistoric)object).textureLocation == null) {
            ((Prehistoric)object).refreshTexturePath();
        }
        return ((Prehistoric)object).textureLocation;
    }

    public ResourceLocation getAnimationFileLocation(T animatable) {
        return this.animationLocation;
    }
}

