/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.rei;

import com.github.teamfossilsarcheology.fossil.recipe.MultiOutputAndSlotsRecipe;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class MultiOutputDisplay
implements Display {
    protected final EntryIngredient input;
    protected final NavigableMap<Double, EntryIngredient> weightedOutputs;
    public final List<WeightedItem> outputs;
    @Nullable
    protected final ResourceLocation location;

    protected MultiOutputDisplay(MultiOutputAndSlotsRecipe recipe) {
        this(EntryIngredients.ofIngredient((Ingredient)recipe.getInput()), MultiOutputDisplay.map(recipe.getWeightedOutputs()), recipe.m_6423_());
    }

    private static NavigableMap<Double, EntryIngredient> map(NavigableMap<Double, ItemStack> output) {
        TreeMap<Double, EntryIngredient> newMap = new TreeMap<Double, EntryIngredient>();
        output.forEach((aDouble, itemStack) -> newMap.put((Double)aDouble, EntryIngredients.of((ItemStack)itemStack)));
        return newMap;
    }

    protected MultiOutputDisplay(EntryIngredient input, NavigableMap<Double, EntryIngredient> output, @Nullable ResourceLocation location) {
        this.input = input;
        this.weightedOutputs = output;
        this.location = location;
        Iterator iterator = this.weightedOutputs.entrySet().iterator();
        ArrayList<WeightedItem> newOutputs = new ArrayList<WeightedItem>();
        if (iterator.hasNext()) {
            double total = (Double)this.weightedOutputs.lastKey();
            Map.Entry entry = iterator.next();
            double previous = (Double)entry.getKey();
            newOutputs.add(new WeightedItem(previous / total * 100.0, (EntryIngredient)entry.getValue()));
            while (iterator.hasNext()) {
                entry = iterator.next();
                newOutputs.add(new WeightedItem(((Double)entry.getKey() - previous) / total * 100.0, (EntryIngredient)entry.getValue()));
                previous = (Double)entry.getKey();
            }
        }
        newOutputs.sort((o1, o2) -> DoubleComparators.OPPOSITE_COMPARATOR.compare(o1.probability, o2.probability));
        this.outputs = newOutputs;
    }

    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(this.input);
    }

    public List<EntryIngredient> getOutputEntries() {
        return Lists.newArrayList(this.weightedOutputs.values());
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.ofNullable(this.location);
    }

    public record WeightedItem(double probability, EntryIngredient item) {
    }

    public static class Serializer<T extends MultiOutputDisplay>
    implements DisplaySerializer<T> {
        protected final Constructor<T> constructor;

        protected Serializer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        public CompoundTag save(CompoundTag tag, T display) {
            tag.m_128365_("Input", (Tag)((MultiOutputDisplay)display).input.saveIngredient());
            ListTag weights = new ListTag();
            ListTag items = new ListTag();
            for (Map.Entry entry : ((MultiOutputDisplay)display).weightedOutputs.entrySet()) {
                weights.add((Object)DoubleTag.m_128500_((double)((Double)entry.getKey())));
                weights.add((Object)((EntryIngredient)entry.getValue()).saveIngredient());
            }
            tag.m_128365_("Weights", (Tag)weights);
            tag.m_128365_("Items", (Tag)items);
            tag.m_128359_("Location", ((MultiOutputDisplay)display).location.toString());
            return tag;
        }

        public T read(CompoundTag tag) {
            EntryIngredient input = EntryIngredient.read((ListTag)tag.m_128437_("Input", 10));
            ListTag weights = tag.m_128437_("Weights", 6);
            ListTag items = tag.m_128437_("Items", 9);
            TreeMap<Double, EntryIngredient> weighted = new TreeMap<Double, EntryIngredient>();
            double total = 0.0;
            for (int i = 0; i < items.size(); ++i) {
                EntryIngredient item = EntryIngredient.read((ListTag)items.m_128744_(i));
                if (item.isEmpty()) continue;
                weighted.put(total += weights.m_128772_(i), item);
            }
            ResourceLocation location = new ResourceLocation(tag.m_128461_("Location"));
            return (T)((MultiOutputDisplay)this.constructor.construct(input, weighted, location));
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(EntryIngredient var1, NavigableMap<Double, EntryIngredient> var2, ResourceLocation var3);
        }
    }
}

