/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.control;

import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.S2CMarkMessage;
import com.github.teamfossilsarcheology.fossil.util.Version;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CustomFlightMoveControl
extends SmoothTurningMoveControl {
    private final PrehistoricFlying mob;
    private boolean shouldLandAtTarget;
    private Vec3 flyingWanted = Vec3.f_82478_;
    private int tick;
    private int lastStuckCheck;
    private Vec3 lastStuckCheckPos = Vec3.f_82478_;

    public CustomFlightMoveControl(PrehistoricFlying mob) {
        super(mob);
        this.mob = mob;
    }

    public void setFlyingTarget(double x, double y, double z, boolean shouldLandAtTarget) {
        this.flyingWanted = new Vec3(x, y, z);
        this.shouldLandAtTarget = shouldLandAtTarget;
        this.f_24978_ = 1.0;
        if (Version.debugEnabled()) {
            int[] targets = new int[3];
            BlockState[] blocks = new BlockState[]{shouldLandAtTarget ? Blocks.f_50268_.m_49966_() : Blocks.f_50074_.m_49966_()};
            targets[0] = Mth.m_14107_((double)x);
            targets[1] = Mth.m_14107_((double)y);
            targets[2] = Mth.m_14107_((double)z);
            MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)((ServerLevel)this.mob.f_19853_).m_8795_(serverPlayer -> true), (Object)new S2CMarkMessage(targets, blocks, false));
        }
    }

    public void m_6849_(double x, double y, double z, double speed) {
        super.m_6849_(x, y, z, speed);
        if (this.mob.isUsingStuckNavigation()) {
            this.flyingWanted = new Vec3(x, y, z);
        }
    }

    public void setOperation(MoveControl.Operation operation) {
        this.f_24981_ = operation;
    }

    @Override
    public void m_8126_() {
        if (!this.mob.m_142592_()) {
            this.mob.m_20242_(false);
            super.m_8126_();
        } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.mob.m_20242_(true);
            Vec3 offset = this.flyingWanted.m_82546_(this.mob.m_20182_());
            double dist = offset.m_82553_();
            if (dist > Math.min(1.5, (double)this.mob.m_20205_())) {
                float initialYRot = this.mob.m_146908_();
                float initialXRot = this.mob.m_146909_();
                float initialYaw = Util.yRotToYaw(initialYRot);
                float targetYaw = (float)Mth.m_14136_((double)offset.f_82481_, (double)offset.f_82479_) * 57.295776f;
                float targetPitch = (float)Mth.m_14136_((double)(-offset.f_82480_), (double)offset.m_165924_()) * 57.295776f;
                float newYaw = Mth.m_14148_((float)initialYaw, (float)targetYaw, (float)4.0f);
                float newPitch = Mth.m_14148_((float)initialXRot, (float)targetPitch, (float)4.0f);
                this.mob.m_146922_(Util.yawToYRot(newYaw));
                this.mob.f_20883_ = this.mob.m_146908_();
                this.mob.m_146926_(newPitch);
                if (Mth.m_14145_((float)initialYRot, (float)this.mob.m_146908_()) < 3.0f) {
                    float limit = 1.2f;
                    if (dist > 15.0) {
                        limit = 2.2f;
                    } else if (dist > 5.0) {
                        limit = 1.8f;
                    }
                    limit = this.shouldLandAtTarget ? limit * 0.8f : limit;
                    this.f_24978_ = Mth.m_14121_((float)((float)this.f_24978_), (float)limit, (float)((float)(0.05 * (1.8 / this.f_24978_))));
                } else {
                    this.f_24978_ = Mth.m_14121_((float)((float)this.f_24978_), (float)0.2f, (float)0.025f);
                }
                double targetXMove = this.f_24978_ * (double)Mth.m_14089_((float)(newYaw * ((float)Math.PI / 180))) * Math.abs(offset.f_82479_ / dist);
                double targetYMove = this.f_24978_ * (double)Mth.m_14031_((float)(-targetPitch * ((float)Math.PI / 180))) * Math.abs(offset.f_82480_ / dist);
                double targetZMove = this.f_24978_ * (double)Mth.m_14031_((float)(newYaw * ((float)Math.PI / 180))) * Math.abs(offset.f_82481_ / dist);
                Vec3 move = this.mob.m_20184_();
                double newX = Mth.m_14121_((float)((float)move.f_82479_), (float)((float)targetXMove), (float)0.01f);
                double newY = Mth.m_14121_((float)((float)move.f_82480_), (float)((float)targetYMove), (float)0.01f);
                double newZ = Mth.m_14121_((float)((float)move.f_82481_), (float)((float)targetZMove), (float)0.01f);
                this.mob.m_20334_(newX, newY, newZ);
            } else {
                if (this.mob.isUsingStuckNavigation()) {
                    this.mob.switchNavigator(false);
                }
                if (this.shouldLandAtTarget) {
                    if (!this.mob.f_19853_.m_46859_(this.mob.m_142538_().m_7495_())) {
                        this.mob.onReachAirTarget(new BlockPos(this.flyingWanted));
                        this.mob.setFlying(false);
                        this.f_24981_ = MoveControl.Operation.WAIT;
                    }
                } else {
                    this.mob.onReachAirTarget(new BlockPos(this.flyingWanted));
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
            if (this.mob.f_201939_ && offset.f_82480_ < 0.0) {
                if (!this.mob.isUsingStuckNavigation()) {
                    if (offset.m_165924_() < 6.0 && offset.f_82480_ > -3.0) {
                        this.mob.setFlying(false);
                        this.f_24981_ = MoveControl.Operation.WAIT;
                        this.mob.moveTo(this.flyingWanted, true, false);
                    } else {
                        this.mob.doStuckNavigation(this.flyingWanted);
                    }
                }
            } else if (this.mob.f_19862_ || this.mob.f_19863_) {
                this.doStuckDetection(this.mob.m_20182_());
            }
        } else {
            this.mob.m_20242_(false);
        }
    }

    private void doStuckDetection(Vec3 pos) {
        ++this.tick;
        if (this.tick - this.lastStuckCheck > 100) {
            if (pos.m_82557_(this.lastStuckCheckPos) < 2.25) {
                if (this.mob.isUsingStuckNavigation()) {
                    this.mob.m_21573_().m_26569_();
                } else {
                    this.mob.doStuckNavigation(this.flyingWanted);
                }
            }
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = pos;
        }
    }
}

