/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.ai.FlockBuildGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlockWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class PrehistoricFlocking
extends Prehistoric {
    protected int groupSize = 1;
    protected PrehistoricFlocking groupLeader;
    protected long flockAttackedTick;
    protected LivingEntity flockAttackedTarget;

    protected PrehistoricFlocking(EntityType<? extends Prehistoric> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FlockBuildGoal(this));
        this.f_21345_.m_25352_(21, (Goal)new FlockWanderGoal(this, 1.0));
    }

    public void setFlockAttacked(LivingEntity target) {
        this.flockAttackedTick = this.f_19853_.m_46467_();
        this.flockAttackedTarget = target;
    }

    public LivingEntity getFlockAttackedTarget() {
        return this.flockAttackedTarget;
    }

    public void leaveGroup() {
        if (this.groupLeader != null) {
            this.groupLeader.decreaseGroupSize();
            this.groupLeader = null;
        }
    }

    public boolean hasGroupLeader() {
        return this.groupLeader != null;
    }

    public void increaseGroupSize() {
        ++this.groupSize;
    }

    public void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canGroupGrow() {
        return this.isGroupLeader() && this.groupSize < this.getMaxGroupSize();
    }

    public boolean isGroupLeader() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfGroupLeader() {
        return this.m_20280_((Entity)this.groupLeader) <= 151.0;
    }

    public boolean isPartOfSameFlock(PrehistoricFlocking other) {
        return this.groupLeader != null && (other.groupLeader == this || this.groupLeader == other || other.groupLeader == this.groupLeader);
    }

    public void pathToGroupLeader(double speed) {
        Vec3 vec;
        if (this.hasGroupLeader() && (vec = this.m_20270_((Entity)this.groupLeader) < 7.0f ? LandRandomPos.m_148488_((PathfinderMob)this, (int)5, (int)7) : LandRandomPos.m_148488_((PathfinderMob)this.groupLeader, (int)5, (int)7)) != null) {
            this.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, speed);
        }
    }

    public PrehistoricFlocking startFollowing(PrehistoricFlocking groupLeader) {
        this.groupLeader = groupLeader;
        groupLeader.increaseGroupSize();
        return groupLeader;
    }

    public void addFollowers(Stream<? extends PrehistoricFlocking> followers) {
        followers.filter(dino -> dino != this).limit(this.getMaxGroupSize() - this.groupSize).forEach(dino -> dino.startFollowing(this));
    }

    @Override
    public void m_8107_() {
        if (this.hasGroupLeader() && !this.groupLeader.m_6084_()) {
            this.leaveGroup();
        }
        super.m_8107_();
        if (this.hasGroupLeader() && this.f_19853_.f_46441_.nextInt(200) == 1 && this.f_19853_.m_6443_(this.getClass(), this.m_142469_().m_82400_((double)this.getFlockDistance()), flocking -> flocking == this.groupLeader).isEmpty()) {
            this.leaveGroup();
        }
        if (this.flockAttackedTarget != null && this.flockAttackedTick < this.f_19853_.m_46467_() - 100L) {
            this.flockAttackedTarget = null;
        }
    }

    protected abstract int getMaxGroupSize();

    public int getFlockDistance() {
        return 32;
    }
}

