/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.LaserPointEntity;
import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingEatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingEatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingLandNearFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomFlightBodyRotationControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomFlightLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomFlightMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.FlightPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.FlyingSleepSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.manager.AnimationData;

public abstract class PrehistoricFlying
extends Prehistoric
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(PrehistoricFlying.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TAKING_OFF = SynchedEntityData.m_135353_(PrehistoricFlying.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLYING_UP = SynchedEntityData.m_135353_(PrehistoricFlying.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int flyingTicks = 0;
    private int groundTicks = 0;
    private long takeOffStartTick = 0L;
    private boolean usingStuckNavigation;
    private boolean flyingDown;
    public float prevPitch;
    public float currentPitch;
    public float prevYaw;
    public float autoPitch;
    public float currentYaw;

    protected PrehistoricFlying(EntityType<? extends PrehistoricFlying> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new CustomFlightMoveControl(this);
        this.f_21365_ = new CustomFlightLookControl<PrehistoricFlying>(this);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new CustomFlightBodyRotationControl<PrehistoricFlying>(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Prehistoric.createAttributes().m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22280_, (double)0.4f);
    }

    @Override
    protected void m_8099_() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.f_21345_.m_25352_(1, (Goal)new DinoPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        if (this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.NONE && this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.JUMP) {
            this.f_21345_.m_25352_(6, new DelayedAttackGoal<PrehistoricFlying>(this, this.attributes().sprintMod(), false));
        }
        this.f_21345_.m_25352_(12, (Goal)this.matingGoal);
        this.f_21345_.m_25352_(15, (Goal)new FlyingLandNearFoodGoal(this));
        this.f_21345_.m_25352_(16, (Goal)new FlyingEatFromFeederGoal(this));
        this.f_21345_.m_25352_(17, (Goal)new FlyingEatItemEntityGoal(this));
        this.f_21345_.m_25352_(18, (Goal)new PlayGoal(this, 1.0));
        this.f_21345_.m_25352_(20, (Goal)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 7.0f, 2.0f, false));
        this.f_21345_.m_25352_(21, (Goal)new FlyingWanderGoal(this));
        this.f_21345_.m_25352_(21, (Goal)new DinoWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(25, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(26, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new HuntingTargetGoal(this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LaserPointEntity.class, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(TAKING_OFF, (Object)false);
        this.f_19804_.m_135372_(FLYING_UP, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (FLYING.equals(key)) {
            this.m_146926_(0.0f);
        }
        super.m_7350_(key);
    }

    @Override
    @NotNull
    protected SleepSystem createSleepSystem() {
        return new FlyingSleepSystem(this);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Flying", this.m_142592_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFlying(compound.m_128471_("Flying"));
    }

    @Override
    protected Pose getTargetPose() {
        return this.m_142592_() ? Pose.FALL_FLYING : super.getTargetPose();
    }

    public boolean m_142592_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
        this.updatePose();
    }

    public boolean isFlyingUp() {
        return (Boolean)this.f_19804_.m_135370_(FLYING_UP);
    }

    public void setFlyingUp(boolean flyingUp) {
        this.f_19804_.m_135381_(FLYING_UP, (Object)flyingUp);
    }

    public boolean isFlyingDown() {
        return this.flyingDown;
    }

    public void setFlyingDown(boolean flyingDown) {
        this.flyingDown = flyingDown;
    }

    public void doStuckNavigation(Vec3 target) {
        this.switchNavigator(true);
        this.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, 1.0);
    }

    public void switchNavigator(boolean fly) {
        this.usingStuckNavigation = fly;
        this.f_21344_ = fly ? new FlightPathNavigation((Mob)this, this.f_19853_) : this.m_6037_(this.f_19853_);
    }

    public boolean isUsingStuckNavigation() {
        return this.usingStuckNavigation;
    }

    @Override
    public boolean m_7132_() {
        return false;
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (!this.m_5807_()) {
            super.m_7023_(travelVector);
            return;
        }
        LivingEntity rider = (LivingEntity)this.m_6688_();
        this.m_146922_(rider.m_146908_());
        this.m_146926_(rider.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        float newStrafeMovement = rider.f_20900_ * 0.5f;
        float newForwardMovement = rider.f_20902_;
        if (this.m_6109_()) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            Vec3 newMovement = new Vec3((double)newStrafeMovement, travelVector.f_82480_, (double)newForwardMovement).m_82490_(0.5);
            if (this.m_142592_()) {
                this.steering.airTravel(newMovement);
            } else {
                super.m_7023_(newMovement);
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
            this.m_21043_((LivingEntity)this, true);
        }
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return !this.m_142592_() ? super.m_142319_() : Entity.MovementEmission.NONE;
    }

    @Override
    public void m_8119_() {
        Entity rider;
        super.m_8119_();
        if (this.f_19853_.f_46443_ && (rider = this.m_6688_()) != null) {
            this.autoPitch = this.isFlyingUp() ? Mth.m_14121_((float)this.autoPitch, (float)-70.0f, (float)5.0f) : (this.isFlyingDown() ? Mth.m_14121_((float)this.autoPitch, (float)70.0f, (float)5.0f) : Mth.m_14121_((float)this.autoPitch, (float)0.0f, (float)2.0f));
            this.prevPitch = this.currentPitch;
            this.currentPitch = Mth.m_14036_((float)(rider.f_19860_ + this.autoPitch), (float)-70.0f, (float)70.0f);
            this.prevYaw = this.currentYaw;
            float yawDiff = this.f_19859_ - this.m_146908_();
            this.currentYaw = yawDiff > 1.0f ? Mth.m_14121_((float)this.currentYaw, (float)10.0f, (float)3.0f) : (yawDiff < -1.0f ? Mth.m_14121_((float)this.currentYaw, (float)-10.0f, (float)3.0f) : Mth.m_14121_((float)this.currentYaw, (float)0.0f, (float)3.0f));
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0 && !this.m_142592_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.f_19853_.f_46443_) {
            boolean debug;
            FlyingPathNavigation flyingPathNavigation;
            PathNavigation pathNavigation;
            if (this.isTakingOff() && this.isTakeOffAnimationDone()) {
                this.finishTakeOff();
            }
            if ((pathNavigation = this.m_21573_()) instanceof FlyingPathNavigation && ((flyingPathNavigation = (FlyingPathNavigation)pathNavigation).m_26571_() || this.usingStuckNavigation && !this.m_142592_())) {
                this.switchNavigator(false);
            }
            if (this.m_142592_()) {
                ++this.flyingTicks;
            } else {
                this.groundTicks = 0;
                this.flyingTicks = 0;
            }
            if (this.flyingTicks > 80 && this.m_20096_()) {
                ++this.groundTicks;
                if (this.groundTicks > 80) {
                    this.setFlying(false);
                }
            } else {
                this.groundTicks = 0;
            }
            if ((debug = false) || this.flyingTicks > this.getMaxExhaustion()) {
                this.moveTo(Vec3.m_82512_((Vec3i)this.findLandPosition(true)), true, true);
            }
            if (!(!this.isFlyingUp() || this.m_142592_() && this.m_20160_())) {
                this.setFlyingUp(false);
            }
        }
    }

    @Override
    public boolean eatItem(ItemStack stack) {
        if (this.m_142592_() || this.isTakingOff()) {
            return false;
        }
        return super.eatItem(stack);
    }

    @Nullable
    @Contract(value="true -> !null")
    public BlockPos findLandPosition(boolean force) {
        BlockPos.MutableBlockPos pos;
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this, (int)8, (int)15);
        if (vec3 == null) {
            int x = this.m_142538_().m_123341_() - 8 + this.f_19796_.nextInt(16);
            int z = this.m_142538_().m_123343_() - 8 + this.f_19796_.nextInt(16);
            int y = this.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
            pos = new BlockPos.MutableBlockPos(x, y - 1, z);
        } else {
            pos = new BlockPos(vec3).m_122032_().m_122173_(Direction.DOWN);
        }
        if (force || GoalUtils.m_148461_((PathfinderMob)this, (BlockPos)pos)) {
            BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(this.m_20182_(), Vec3.m_82512_((Vec3i)pos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (result.m_6662_() != HitResult.Type.MISS) {
                pos = result.m_82425_().m_142300_(result.m_82434_()).m_122032_();
                while (this.f_19853_.m_46859_((BlockPos)pos) && pos.m_123342_() > this.f_19853_.m_141937_()) {
                    pos.m_122184_(0, -1, 0);
                }
            }
            return pos.m_7949_();
        }
        return null;
    }

    private int getMaxExhaustion() {
        return 6000;
    }

    public void moveTo(Vec3 pos, boolean shouldLand, boolean shouldFly) {
        MoveControl moveControl = this.m_21566_();
        if (!(moveControl instanceof CustomFlightMoveControl)) {
            return;
        }
        CustomFlightMoveControl control = (CustomFlightMoveControl)moveControl;
        if (this.m_142592_()) {
            control.setFlyingTarget(pos.f_82479_, pos.f_82480_, pos.f_82481_, shouldLand);
            control.setOperation(MoveControl.Operation.MOVE_TO);
        } else if (this.isTakingOff()) {
            control.setFlyingTarget(pos.f_82479_, pos.f_82480_, pos.f_82481_, shouldLand);
            control.setOperation(MoveControl.Operation.WAIT);
        } else if (this.m_20238_(pos) > 40.0 || shouldFly) {
            if (this.hasTakeOffAnimation()) {
                this.startTakeOff();
                control.setFlyingTarget(pos.f_82479_, pos.f_82480_, pos.f_82481_, shouldLand);
                control.setOperation(MoveControl.Operation.WAIT);
            } else {
                this.setFlying(true);
                control.setFlyingTarget(pos.f_82479_, pos.f_82480_, pos.f_82481_, shouldLand);
                control.setOperation(MoveControl.Operation.MOVE_TO);
            }
        } else {
            this.m_21573_().m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0);
        }
    }

    public boolean isTakingOff() {
        return (Boolean)this.f_19804_.m_135370_(TAKING_OFF);
    }

    public void startTakeOff() {
        this.f_19804_.m_135381_(TAKING_OFF, (Object)true);
        this.takeOffStartTick = this.f_19853_.m_46467_();
        this.getAnimationLogic().triggerAnimation("Movement/Idle", this.nextTakeOffAnimation(), AnimationCategory.NONE);
    }

    public void finishTakeOff() {
        this.f_19804_.m_135381_(TAKING_OFF, (Object)false);
        this.takeOffStartTick = -1L;
        this.setFlying(true);
        MoveControl moveControl = this.m_21566_();
        if (moveControl instanceof CustomFlightMoveControl) {
            CustomFlightMoveControl control = (CustomFlightMoveControl)moveControl;
            control.setOperation(MoveControl.Operation.MOVE_TO);
        }
    }

    public void cancelTakeOff() {
        this.f_19804_.m_135381_(TAKING_OFF, (Object)false);
        this.takeOffStartTick = -1L;
    }

    public boolean isTakeOffAnimationDone() {
        double flyDelay = this.getAnimationLogic().getActionDelay("Movement/Idle");
        return (double)this.f_19853_.m_46467_() > flyDelay + (double)this.takeOffStartTick;
    }

    public void onReachAirTarget(BlockPos target) {
    }

    @Nullable
    public BlockPos getBlockInView() {
        float radius = -((float)this.f_19796_.nextInt(20) + 6.3f);
        float neg = this.f_19796_.nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_ + 3.15f + this.f_19796_.nextFloat() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(this.m_20185_() + extraX, 0.0, this.m_20189_() + extraZ);
        BlockPos ground = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, radialPos);
        int distFromGround = (int)this.m_20186_() - ground.m_123342_();
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? (int)Math.min((double)FossilConfig.getInt("flyingTargetMaxHeight"), this.m_20186_() + (double)this.f_19796_.nextInt(16) - 8.0) : (int)this.m_20186_() + this.f_19796_.nextInt(16) + 1);
        if (!this.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos)) && this.m_20238_(Vec3.m_82512_((Vec3i)newPos)) > 6.0) {
            return newPos;
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        if (target != null) {
            BlockHitResult hitResult = this.f_19853_.m_45547_(new ClipContext(this.m_20182_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            return hitResult.m_6662_() == HitResult.Type.BLOCK;
        }
        return false;
    }

    @Nullable
    public Vec3 generateAirTarget() {
        BlockHitResult[] results = new BlockHitResult[10];
        for (int i = 0; i < 10; ++i) {
            BlockHitResult result;
            float heightMod = (float)(this.m_20186_() + 1.0) / (float)(this.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)this.m_20185_(), (int)this.m_20189_()) + 10);
            double targetX = this.m_20185_() + (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double targetY = this.m_20186_() + (double)((this.f_19796_.nextFloat() * 2.0f - heightMod) * 16.0f);
            double targetZ = this.m_20189_() + (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            Vec3 pos = new Vec3(targetX, targetY, targetZ);
            results[i] = result = this.f_19853_.m_45547_(new ClipContext(this.m_20182_(), pos, ClipContext.Block.COLLIDER, this.m_20069_() ? ClipContext.Fluid.NONE : ClipContext.Fluid.ANY, (Entity)this));
            BlockPos.MutableBlockPos mutable = result.m_82425_().m_122032_();
            while (!this.f_19853_.m_6425_((BlockPos)mutable).m_76178_()) {
                mutable.m_122184_(0, 1, 0);
            }
            results[i] = new BlockHitResult(result.m_82450_(), result.m_82434_(), mutable.m_7949_(), result.m_82436_());
            if (result.m_6662_() != HitResult.Type.MISS) continue;
            return pos;
        }
        BlockHitResult furthest = null;
        double distance = 5.0;
        for (int i = 1; i < results.length; ++i) {
            double g = this.m_20182_().m_82554_(results[i].m_82450_());
            if (!(g > distance)) continue;
            furthest = results[i];
            distance = g;
        }
        return furthest != null ? Vec3.m_82512_((Vec3i)furthest.m_82425_().m_142300_(furthest.m_82434_())) : null;
    }

    @Override
    public void registerControllers(AnimationData data) {
        PausableAnimationController<PrehistoricFlying> controller = new PausableAnimationController<PrehistoricFlying>(this, "Movement/Idle", 5.0f, this.getAnimationLogic()::flyingPredicate);
        this.registerEatingListeners(controller);
        data.addAnimationController(controller);
        data.addAnimationController(new PausableAnimationController<PrehistoricFlying>(this, "Attack", 0.0f, this.getAnimationLogic()::attackPredicate));
    }

    public boolean hasTakeOffAnimation() {
        return true;
    }

    @NotNull
    public abstract AnimationInfo nextTakeOffAnimation();
}

