/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.util;

import com.github.teamfossilsarcheology.fossil.entity.data.Attribute;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.tags.ModBlockTags;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final int IMMOBILE = 0;
    public static final int ATTACK = 5;
    public static final int SLEEP = 10;
    public static final int NEEDS = 15;
    public static final int WANDER = 20;
    public static final int LOOK = 25;
    public static final float SWING_ANIM_THRESHOLD = 0.08f;

    public static void spawnParticles(Level level, ParticleOptions particleOptions, int count, AABB aabb) {
        for (int i = 0; i < count; ++i) {
            double motionX = level.m_5822_().nextGaussian() * 0.07;
            double motionY = level.m_5822_().nextGaussian() * 0.07;
            double motionZ = level.m_5822_().nextGaussian() * 0.07;
            float x = (float)((double)level.m_5822_().nextFloat() * (aabb.f_82291_ - aabb.f_82288_) + aabb.f_82288_);
            float y = (float)((double)level.m_5822_().nextFloat() * (aabb.f_82292_ - aabb.f_82289_) + aabb.f_82289_);
            float z = (float)((double)level.m_5822_().nextFloat() * (aabb.f_82293_ - aabb.f_82290_) + aabb.f_82290_);
            level.m_7106_(particleOptions, (double)x, (double)y, (double)z, motionX, motionY, motionZ);
        }
    }

    public static void spawnParticles(Entity entity, ParticleOptions particleOptions, int count) {
        Util.spawnParticles(entity.f_19853_, particleOptions, count, entity.m_6921_());
    }

    public static void spawnItemParticles(Entity entity, Item item, int count) {
        Util.spawnItemParticles(entity.f_19853_, item, count, entity.m_6921_());
    }

    public static void spawnItemParticles(Level level, Item item, int count, AABB aabb) {
        Util.spawnParticles(level, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)item)), count, aabb);
    }

    public static boolean isEntitySmallerThan(Entity entity, float size) {
        return entity.m_20205_() <= size;
    }

    public static boolean canBreak(Level level, BlockPos targetPos, float maxHardness) {
        BlockState state = level.m_8055_(targetPos);
        if (state.m_204336_(ModBlockTags.UNBREAKABLE) || state.m_60800_((BlockGetter)level, targetPos) >= maxHardness || state.m_60800_((BlockGetter)level, targetPos) < 0.0f) {
            return false;
        }
        return !state.m_60812_((BlockGetter)level, targetPos).m_83281_() && state.m_60819_().m_76178_();
    }

    public static boolean canReachPrey(Prehistoric prehistoric, Entity target) {
        return prehistoric.getEntityHitboxData().getAttackBounds().m_82381_(target.m_142469_()) && prehistoric.m_21574_().m_148306_(target);
    }

    public static boolean canSeeFood(Prehistoric dino, BlockPos position) {
        Vec3 target = new Vec3((double)position.m_123341_() + 0.5, (double)position.m_123342_(), (double)position.m_123343_() + 0.5);
        ClipContext.Fluid fluid = ClipContext.Fluid.NONE;
        if (!(dino instanceof SwimmingAnimal)) {
            fluid = ClipContext.Fluid.ANY;
        }
        BlockHitResult rayTrace = dino.m_183503_().m_45547_(new ClipContext(dino.m_146892_(), target, ClipContext.Block.COLLIDER, fluid, (Entity)dino));
        return position.equals((Object)rayTrace.m_82425_());
    }

    public static double attributeToSpeed(double speed) {
        return 44.23174 * Mth.m_144952_((double)speed) - 0.504912 * speed + 0.0592455;
    }

    public static double attributeToSpeed(double speed, double sprintMod, boolean isSprinting) {
        return Util.attributeToSpeed(isSprinting ? speed * sprintMod : speed);
    }

    public static double calculateSpeed(EntityDataLoader.Data data, float scale, boolean swim) {
        boolean maxBelow1;
        Attribute attributes = data.attributes();
        double baseSpeed = swim ? attributes.baseSwimSpeed() : attributes.baseSpeed();
        double minSpeed = swim ? attributes.minSwimSpeed() : attributes.minSpeed();
        double maxSpeed = swim ? attributes.maxSwimSpeed() : attributes.maxSpeed();
        double newSpeed = baseSpeed;
        boolean minAbove1 = data.minScale() >= 1.0f;
        boolean bl = maxBelow1 = data.maxScale() <= 1.0f;
        if (scale < 1.0f) {
            float max;
            float min = data.minScale();
            float f = max = maxBelow1 ? data.maxScale() : 1.0f;
            if (min != max) {
                newSpeed = Mth.m_14139_((double)((scale - min) / (max - min)), (double)minSpeed, (double)(maxBelow1 ? maxSpeed : baseSpeed));
            }
        } else {
            float min = data.minScale() < 1.0f ? 1.0f : data.minScale();
            float max = data.maxScale();
            newSpeed = max != min ? Mth.m_14139_((double)((scale - min) / (max - min)), (double)(minAbove1 ? minSpeed : baseSpeed), (double)maxSpeed) : maxSpeed;
        }
        return newSpeed;
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(Class<? extends T> entityClazz, Mob attacker, AABB searchArea, Predicate<T> predicate) {
        List entities = attacker.f_19853_.m_6443_(entityClazz, searchArea, entity -> true);
        double shortestDist = -1.0;
        Entity target = null;
        for (Entity entity2 : entities) {
            if (!attacker.m_21574_().m_148306_(entity2) || !predicate.test(entity2)) continue;
            double currentDist = entity2.m_20280_((Entity)attacker);
            if (shortestDist != -1.0 && currentDist >= shortestDist) continue;
            shortestDist = currentDist;
            target = entity2;
        }
        return (T)target;
    }

    public static float yRotToYaw(double yRot) {
        return (float)Mth.m_14175_((double)(yRot + 90.0));
    }

    public static float yawToYRot(double yaw) {
        return (float)Mth.m_14175_((double)(yaw - 90.0));
    }

    public static float clampTo360(double x) {
        return (float)(x - Math.floor(x / 360.0) * 360.0);
    }

    public static Vec3 directionVecTo(Entity start, Entity end) {
        return end.m_20182_().m_82546_(start.m_20182_());
    }

    public static boolean movingAwayFrom(Entity target, Entity start) {
        return target.m_20184_().m_82553_() > 0.2 && target.m_20184_().m_82526_(Util.directionVecTo(start, target)) > 0.0;
    }

    public static Pair<Direction, Double> getClosestSide(AABB bounding, BlockPos blockPos) {
        AABB aabb = bounding.m_82383_(Vec3.m_82539_((Vec3i)blockPos).m_82490_(-1.0));
        double maxX = Math.abs(Math.abs(aabb.f_82291_) - 0.5);
        double minZ = Math.abs(Math.abs(aabb.f_82290_) - 0.5);
        double maxZ = Math.abs(Math.abs(aabb.f_82293_) - 0.5);
        double smallest = Math.abs(Math.abs(aabb.f_82288_) - 0.5);
        Direction dir = Direction.WEST;
        if (maxX < smallest) {
            smallest = maxX;
            dir = Direction.EAST;
        }
        if (minZ < smallest) {
            smallest = minZ;
            dir = Direction.NORTH;
        }
        if (maxZ < smallest) {
            smallest = maxZ;
            dir = Direction.SOUTH;
        }
        return Pair.of((Object)dir, (Object)smallest);
    }
}

