/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.providers;

import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ToyBallItem;
import com.github.teamfossilsarcheology.fossil.item.ToyScratchingPostItem;
import com.github.teamfossilsarcheology.fossil.item.ToyTetheredLogItem;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModItemProvider
extends ItemModelProvider {
    public ModItemProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "fossil", existingFileHelper);
    }

    protected void registerModels() {
        boolean dinoItems = true;
        boolean plantItems = true;
        boolean toyItems = true;
        if (toyItems) {
            Item item;
            for (RegistrySupplier registrySupplier : ModItems.TOY_BALLS.values()) {
                item = (ToyBallItem)((Object)registrySupplier.get());
                ResourceLocation resourceLocation = new ResourceLocation(item.getRegistryName().m_135827_(), "item/" + item.getRegistryName().m_135815_());
                this.builder(resourceLocation, item.getRegistryName());
            }
            for (RegistrySupplier registrySupplier : ModItems.TOY_SCRATCHING_POSTS.values()) {
                item = (ToyScratchingPostItem)((Object)registrySupplier.get());
                ResourceLocation resourceLocation = new ResourceLocation(item.getRegistryName().m_135827_(), "item/" + item.getRegistryName().m_135815_());
                this.builder(resourceLocation, item.getRegistryName());
            }
            for (RegistrySupplier registrySupplier : ModItems.TOY_TETHERED_LOGS.values()) {
                item = (ToyTetheredLogItem)((Object)registrySupplier.get());
                ResourceLocation resourceLocation = new ResourceLocation(item.getRegistryName().m_135827_(), "item/" + item.getRegistryName().m_135815_());
                this.builder(resourceLocation, item.getRegistryName());
            }
        }
        if (dinoItems) {
            for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
                if (prehistoricEntityInfo.dnaItem != null) {
                    this.dnaItem(Objects.requireNonNull(prehistoricEntityInfo.dnaItem.getRegistryName()));
                }
                if (prehistoricEntityInfo.foodItem != null) {
                    this.foodItem(Objects.requireNonNull(prehistoricEntityInfo.foodItem.getRegistryName()), prehistoricEntityInfo, "meat");
                }
                if (prehistoricEntityInfo.cookedFoodItem != null) {
                    this.foodItem(Objects.requireNonNull(prehistoricEntityInfo.cookedFoodItem.getRegistryName()), prehistoricEntityInfo, "cooked");
                }
                if (prehistoricEntityInfo.eggItem != null) {
                    this.eggItem(prehistoricEntityInfo.eggItem.getRegistryName());
                }
                if (prehistoricEntityInfo.birdEggItem != null) {
                    this.eggItem(prehistoricEntityInfo.birdEggItem.getRegistryName());
                }
                if (prehistoricEntityInfo.cultivatedBirdEggItem != null) {
                    this.eggItem(prehistoricEntityInfo.cultivatedBirdEggItem.getRegistryName());
                }
                if (prehistoricEntityInfo.embryoItem != null) {
                    this.embyroItem(prehistoricEntityInfo.embryoItem.getRegistryName());
                }
                if (prehistoricEntityInfo.spawnEggItem != null) {
                    this.spawnEggItem(prehistoricEntityInfo.spawnEggItem);
                }
                if (prehistoricEntityInfo.armBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.armBoneItem.getRegistryName()), prehistoricEntityInfo, "arm_bone");
                }
                if (prehistoricEntityInfo.footBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.footBoneItem.getRegistryName()), prehistoricEntityInfo, "foot");
                }
                if (prehistoricEntityInfo.legBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.legBoneItem.getRegistryName()), prehistoricEntityInfo, "leg_bone");
                }
                if (prehistoricEntityInfo.ribcageBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.ribcageBoneItem.getRegistryName()), prehistoricEntityInfo, "ribcage");
                }
                if (prehistoricEntityInfo.skullBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.skullBoneItem.getRegistryName()), prehistoricEntityInfo, "skull");
                }
                if (prehistoricEntityInfo.tailBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.tailBoneItem.getRegistryName()), prehistoricEntityInfo, "tail");
                }
                if (prehistoricEntityInfo.uniqueBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.uniqueBoneItem.getRegistryName()), prehistoricEntityInfo, "unique");
                }
                if (prehistoricEntityInfo.vertebraeBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(prehistoricEntityInfo.vertebraeBoneItem.getRegistryName()), prehistoricEntityInfo, "vertebrae");
                }
                if (prehistoricEntityInfo.bucketItem == null) continue;
                this.basicItem(prehistoricEntityInfo.bucketItem.getRegistryName());
            }
            for (VanillaEntityInfo vanillaEntityInfo : VanillaEntityInfo.values()) {
                if (vanillaEntityInfo.dnaItem != null) {
                    this.dnaItem(Objects.requireNonNull(vanillaEntityInfo.dnaItem.getRegistryName()));
                }
                if (vanillaEntityInfo.eggItem != null) {
                    this.eggItem(vanillaEntityInfo.eggItem.getRegistryName());
                }
                if (vanillaEntityInfo.cultivatedBirdEggItem != null) {
                    this.eggItem(vanillaEntityInfo.cultivatedBirdEggItem.getRegistryName());
                }
                if (vanillaEntityInfo.embryoItem == null) continue;
                this.embyroItem(vanillaEntityInfo.embryoItem.getRegistryName());
            }
            this.spawnEggItem((Item)ModItems.ANU_BOSS_SPAWN_EGG.get());
            this.spawnEggItem((Item)ModItems.FAILURESAURUS_SPAWN_EGG.get());
            this.spawnEggItem((Item)ModItems.SENTRY_PIGLIN_SPAWN_EGG.get());
            this.spawnEggItem((Item)ModItems.TAR_SLIME_SPAWN_EGG.get());
            this.basicItem((Item)ModItems.ELASMOTHERIUM_FUR.get());
            this.basicItem((Item)ModItems.MAMMOTH_FUR.get());
            this.basicItem((Item)ModItems.THERIZINOSAURUS_DOWN.get());
            this.basicItem((Item)ModItems.MAGIC_CONCH.get());
            this.eggItem(((Item)ModItems.ARTIFICIAL_HONEYCOMB.get()).getRegistryName());
        }
        if (plantItems) {
            for (PrehistoricPlantInfo prehistoricPlantInfo : PrehistoricPlantInfo.values()) {
                if (prehistoricPlantInfo.berryItem == null) continue;
                ResourceLocation resourceLocation = new ResourceLocation(((Item)prehistoricPlantInfo.berryItem.get()).getRegistryName().m_135827_(), "item/" + ((Item)prehistoricPlantInfo.berryItem.get()).getRegistryName().m_135815_());
                this.builder(resourceLocation, ((Item)prehistoricPlantInfo.berryItem.get()).getRegistryName());
            }
            for (PrehistoricPlantInfo prehistoricPlantInfo : PrehistoricPlantInfo.plantsWithSeeds()) {
                if (prehistoricPlantInfo == PrehistoricPlantInfo.MUTANT_PLANT) continue;
                this.plantSeedItem(prehistoricPlantInfo.getPlantSeedItem().getRegistryName());
                this.plantSeedItem(prehistoricPlantInfo.getFossilizedPlantSeedItem().getRegistryName());
            }
            this.basicItem((Item)ModItems.CALAMITES_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.CORDAITES_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.PALM_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.SIGILLARIA_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.TEMPSKYA_FOSSIL_SAPLING.get());
        }
        this.basicItem((Item)ModItems.MUSIC_DISC_ANU.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_BONES.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_DISCOVERY.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_SCARAB.get());
    }

    public ItemModelBuilder basicItem(ResourceLocation item) {
        return this.builder(new ResourceLocation(item.m_135827_(), "item/" + item.m_135815_()), item);
    }

    public void plantSeedItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/seeds/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void plantBlockItem(Block block, String suffix) {
        ResourceLocation resourceLocation = new ResourceLocation(block.getRegistryName().m_135827_(), "block/plants/plant_" + block.getRegistryName().m_135815_() + suffix);
        this.builder(resourceLocation, block.getRegistryName());
    }

    public void dnaItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/dna/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void boneItem(ResourceLocation item, PrehistoricEntityInfo info, String bone) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/bone/" + info.resourceName + "/" + bone);
        this.builder(resourceLocation, item);
    }

    public void foodItem(ResourceLocation item, PrehistoricEntityInfo info, String meat) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/meat/" + info.resourceName + "_" + meat);
        this.builder(resourceLocation, item);
    }

    public void eggItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/eggs/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void spawnEggItem(Item item) {
        ((ItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
    }

    public void embyroItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/embryo/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void vaseItem(ResourceLocation blockLocation) {
        ResourceLocation resourceLocation = new ResourceLocation(blockLocation.m_135827_(), "item/vases/" + blockLocation.m_135815_());
        this.builder(resourceLocation, blockLocation);
    }

    public void simpleItem(ResourceLocation location, boolean block) {
        ResourceLocation resourceLocation = new ResourceLocation(location.m_135827_(), (block ? "block/" : "item/") + location.m_135815_());
        this.builder(resourceLocation, location);
    }

    public void blockItem(ResourceLocation blockLocation) {
        this.blockItem(blockLocation, "");
    }

    public void blockItem(ResourceLocation blockLocation, String suffix) {
        ResourceLocation resourceLocation = new ResourceLocation(blockLocation.m_135827_(), "item/" + blockLocation.m_135815_());
        this.existingFileHelper.trackGenerated(resourceLocation, (ExistingFileHelper.IResourceType)TEXTURE);
        ((ItemModelBuilder)this.getBuilder(blockLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(blockLocation.m_135827_() + ":block/" + blockLocation.m_135815_() + suffix));
    }

    private ItemModelBuilder builder(ResourceLocation resourceLocation, ResourceLocation item) {
        this.existingFileHelper.trackGenerated(resourceLocation, (ExistingFileHelper.IResourceType)TEXTURE);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", resourceLocation);
    }
}

