/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.tests;

import com.github.teamfossilsarcheology.fossil.forge.tests.BatchArgument;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.mutable.MutableInt;

public class BatchTestCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"batch_test").then(Commands.m_82129_((String)"batchName", (ArgumentType)BatchArgument.batch()).executes(context -> BatchTestCommand.runBatch((CommandSourceStack)context.getSource(), BatchArgument.getBatch((CommandContext<CommandSourceStack>)context, "batchName"))));
    }

    private static int runBatch(CommandSourceStack source, String batchName) {
        Collection collection = GameTestRegistry.m_127658_();
        Collection<GameTestBatch> batched = BatchTestCommand.groupTestsIntoBatches(collection, batchName);
        BatchTestCommand.say(source, "Running all " + batched.size() + " tests in batch " + batchName + "...");
        GameTestRegistry.m_127678_();
        BlockPos blockPos = new BlockPos(source.m_81371_());
        BlockPos blockPos2 = new BlockPos(blockPos.m_123341_(), source.m_81372_().m_5452_(Heightmap.Types.WORLD_SURFACE, blockPos).m_123342_(), blockPos.m_123343_() + 3);
        Collection collection2 = GameTestRunner.m_127726_(batched, (BlockPos)blockPos2, (Rotation)Rotation.NONE, (ServerLevel)source.m_81372_(), (GameTestTicker)GameTestTicker.f_177648_, (int)8);
        MultipleTestTracker multipleTestTracker = new MultipleTestTracker(collection2);
        multipleTestTracker.m_127811_((GameTestListener)new TestSummaryDisplayer(source.m_81372_(), multipleTestTracker));
        multipleTestTracker.m_127807_(gameTestInfo -> GameTestRegistry.m_127664_((TestFunction)gameTestInfo.m_127648_()));
        return 1;
    }

    private static Collection<GameTestBatch> groupTestsIntoBatches(Collection<TestFunction> testFunctions, String batchName) {
        List<TestFunction> batched = testFunctions.stream().filter(testFunction -> testFunction.m_128081_().equals(batchName)).toList();
        Map<String, List<TestFunction>> a = batched.stream().collect(Collectors.groupingBy(TestFunction::m_128075_));
        return (Collection)a.entrySet().stream().flatMap(entry -> {
            String string = (String)entry.getKey();
            Consumer consumer = GameTestRegistry.m_127676_((String)string);
            Consumer consumer2 = GameTestRegistry.m_177517_((String)string);
            MutableInt mutableInt = new MutableInt();
            Collection collection = (Collection)entry.getValue();
            return Streams.stream((Iterable)Iterables.partition((Iterable)collection, (int)100)).map(list -> new GameTestBatch(string + ":" + mutableInt.incrementAndGet(), (Collection)ImmutableList.copyOf((Collection)list), consumer, consumer2));
        }).collect(ImmutableList.toImmutableList());
    }

    private static int runAllTests(CommandSourceStack source, int rotationSteps, int testsPerRow) {
        GameTestRunner.m_127685_((ServerLevel)source.m_81372_());
        Collection collection = GameTestRegistry.m_127658_();
        BatchTestCommand.say(source, "Running all " + collection.size() + " tests...");
        GameTestRegistry.m_127678_();
        Map<String, List<TestFunction>> batchedRuns = collection.stream().collect(Collectors.groupingBy(TestFunction::m_128081_));
        BatchTestCommand.runTests(source, batchedRuns, rotationSteps, testsPerRow);
        return 1;
    }

    private static void runTests(CommandSourceStack source, Map<String, List<TestFunction>> batchedRuns, int rotationSteps, int testsPerRow) {
    }

    private static void say(CommandSourceStack source, String message) {
        source.m_81354_((Component)new TextComponent(message), false);
    }

    private static void say(ServerLevel serverLevel, String message, ChatFormatting formatting) {
        serverLevel.m_8795_(arg -> true).forEach(arg2 -> arg2.m_6352_((Component)new TextComponent(formatting + message), Util.f_137441_));
    }

    static void showTestSummaryIfAllDone(ServerLevel serverLevel, MultipleTestTracker tracker) {
        if (tracker.m_127821_()) {
            BatchTestCommand.say(serverLevel, "GameTest done! " + tracker.m_127820_() + " tests were run", ChatFormatting.WHITE);
            if (tracker.m_127818_()) {
                BatchTestCommand.say(serverLevel, tracker.m_127803_() + " required tests failed :(", ChatFormatting.RED);
            } else {
                BatchTestCommand.say(serverLevel, "All required tests passed :)", ChatFormatting.GREEN);
            }
            if (tracker.m_127819_()) {
                BatchTestCommand.say(serverLevel, tracker.m_127816_() + " optional tests failed", ChatFormatting.GRAY);
            }
        }
    }

    private static class TestSummaryDisplayer
    implements GameTestListener {
        private final ServerLevel level;
        private final MultipleTestTracker tracker;

        public TestSummaryDisplayer(ServerLevel arg, MultipleTestTracker arg2) {
            this.level = arg;
            this.tracker = arg2;
        }

        public void m_8073_(GameTestInfo testInfo) {
        }

        public void m_142378_(GameTestInfo testInfo) {
            BatchTestCommand.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        public void m_8066_(GameTestInfo testInfo) {
            BatchTestCommand.showTestSummaryIfAllDone(this.level, this.tracker);
        }
    }
}

