/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public class S2CSyncFoodMappingsMessage {
    private final Map<FoodType, Map<Item, Integer>> itemValues;
    private final Map<FoodType, Map<EntityType<?>, Integer>> entityValues;
    private final Set<EntityType<?>> entities;

    public S2CSyncFoodMappingsMessage(FriendlyByteBuf buf) {
        this.itemValues = buf.m_178374_(HashMap::new, FoodType::readBuf, friendlyByteBuf -> friendlyByteBuf.m_178374_(HashMap::new, buf1 -> Item.m_41445_((int)buf1.readInt()), FriendlyByteBuf::readInt));
        this.entityValues = buf.m_178374_(HashMap::new, FoodType::readBuf, friendlyByteBuf -> friendlyByteBuf.m_178374_(HashMap::new, buf1 -> (EntityType)Registry.f_122826_.m_7745_(buf1.m_130281_()), FriendlyByteBuf::readInt));
        this.entities = new HashSet(buf.m_178366_(buf1 -> (EntityType)Registry.f_122826_.m_7745_(buf1.m_130281_())));
    }

    public S2CSyncFoodMappingsMessage(Map<FoodType, Map<Item, Integer>> itemValues, Map<FoodType, Map<EntityType<?>, Integer>> entityValues, Set<EntityType<?>> entities) {
        this.itemValues = itemValues;
        this.entityValues = entityValues;
        this.entities = entities;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_178355_(this.itemValues, FoodType::writeBuf, (innerBuf, map) -> innerBuf.m_178355_(map, (buf1, item) -> buf1.writeInt(Item.m_41393_((Item)item)), FriendlyByteBuf::writeInt));
        buf.m_178355_(this.entityValues, FoodType::writeBuf, (innerBuf, map) -> innerBuf.m_178355_(map, (buf1, entityType) -> buf1.m_130085_(EntityType.m_20613_((EntityType)entityType)), FriendlyByteBuf::writeInt));
        buf.m_178352_(this.entities, (buf1, entityType) -> buf1.m_130085_(EntityType.m_20613_((EntityType)entityType)));
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.SERVER) {
            return;
        }
        contextSupplier.get().queue(() -> FoodMappingsManager.INSTANCE.replaceValues(this.itemValues, this.entityValues, this.entities));
    }
}

