/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.villager;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.google.common.collect.ImmutableSet;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ModVillagers {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((String)"fossil", (ResourceKey)Registry.f_122810_);
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((String)"fossil", (ResourceKey)Registry.f_122809_);
    public static final RegistrySupplier<PoiType> ARCHEOLOGIST_POI = ModVillagers.register("archeologist_poi", ModBlocks.WORKTABLE);
    public static final RegistrySupplier<VillagerProfession> ARCHEOLOGIST = ModVillagers.register("archeologist", ARCHEOLOGIST_POI, SoundEvents.f_12568_);
    public static final RegistrySupplier<PoiType> PALEONTOLOGIST_POI = ModVillagers.register("paleontologist_poi", ModBlocks.ANALYZER);
    public static final RegistrySupplier<VillagerProfession> PALEONTOLOGIST = ModVillagers.register("paleontologist", PALEONTOLOGIST_POI, SoundEvents.f_12574_);

    public static void register() {
        POI_TYPES.register();
        PROFESSIONS.register();
        LifecycleEvent.SETUP.register(() -> {
            PoiType.m_27367_((PoiType)((PoiType)ARCHEOLOGIST_POI.get()));
            PoiType.m_27367_((PoiType)((PoiType)PALEONTOLOGIST_POI.get()));
        });
    }

    private static RegistrySupplier<PoiType> register(String name, RegistrySupplier<Block> block) {
        return ModVillagers.register(name, block, 1, 1);
    }

    private static RegistrySupplier<PoiType> register(String name, RegistrySupplier<Block> block, int maxTickets, int validRange) {
        return POI_TYPES.register(name, () -> new PoiType(name, ModVillagers.getBlockStates(block), maxTickets, validRange));
    }

    private static RegistrySupplier<VillagerProfession> register(String name, RegistrySupplier<PoiType> jobSite, @Nullable SoundEvent workSound) {
        return PROFESSIONS.register(name, () -> new VillagerProfession(name, (PoiType)jobSite.get(), ImmutableSet.of(), ImmutableSet.of(), workSound));
    }

    private static Set<BlockState> getBlockStates(RegistrySupplier<Block> block) {
        return ImmutableSet.copyOf((Collection)((Block)block.get()).m_49965_().m_61056_());
    }
}

