/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.chunk;

import com.github.teamfossilsarcheology.fossil.world.biome.ModBiomes;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;

public class AnuLairChunkGenerator
extends ChunkGenerator {
    public static final Codec<AnuLairChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> AnuLairChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(source -> source.biomes)).apply((Applicative)instance, instance.stable(AnuLairChunkGenerator::new)));
    private final Registry<Biome> biomes;

    public AnuLairChunkGenerator(Registry<StructureSet> registry, Registry<Biome> registry2) {
        super(registry, Optional.empty(), (BiomeSource)new FixedBiomeSource(registry2.m_203538_(ModBiomes.ANU_LAIR_KEY)));
        this.biomes = registry2;
    }

    private void generatePositions() {
        StructureSet structureSet = (StructureSet)this.f_207955_.m_7745_(ModStructures.ANU_CASTLE.location());
        if (structureSet != null) {
            for (StructureSet.StructureSelectionEntry structure : structureSet.f_210003_()) {
                this.f_207957_.computeIfAbsent((ConfiguredStructureFeature)structure.f_210026_().m_203334_(), configuredStructureFeature -> new ArrayList()).add(structureSet.f_210004_());
            }
            StructurePlacement structurePlacement = structureSet.f_210004_();
            if (structurePlacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement placement = (ConcentricRingsStructurePlacement)structurePlacement;
                this.f_204350_.put(placement, CompletableFuture.completedFuture(List.of(new ChunkPos(0, 0))));
            }
        }
    }

    public void m_211700_() {
        if (!this.f_207958_) {
            this.generatePositions();
            this.f_207958_ = true;
        }
    }

    public void m_207076_(List<String> info, BlockPos pos) {
    }

    @NotNull
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @NotNull
    public ChunkGenerator m_6819_(long seed) {
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Climate.Sampler m_183403_() {
        return Climate.m_207841_();
    }

    public void m_183516_(WorldGenRegion level, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void m_183621_(WorldGenRegion level, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        block40: {
            int z;
            int x;
            int y;
            int offset;
            int anuCastleMinY;
            BlockState netherrack;
            int chunkX;
            BlockPos.MutableBlockPos mutable;
            block41: {
                mutable = new BlockPos.MutableBlockPos();
                chunkX = chunk.m_7697_().f_45578_;
                int chunkZ = chunk.m_7697_().f_45579_;
                netherrack = Blocks.f_50134_.m_49966_();
                anuCastleMinY = 62;
                int islandMinY = anuCastleMinY - 16;
                if (chunkX > -1 && chunkX < 9 && chunkZ > -1 && chunkZ < 9) {
                    for (int y2 = islandMinY; y2 < anuCastleMinY; ++y2) {
                        for (int x2 = 0; x2 < 16; ++x2) {
                            for (int z2 = 0; z2 < 16; ++z2) {
                                chunk.m_6978_((BlockPos)mutable.m_122178_(x2, y2, z2), netherrack, false);
                            }
                        }
                    }
                }
                offset = 0;
                if (chunkX == -1) {
                    if (chunkZ >= 0 && chunkZ < 9) {
                        for (y = islandMinY; y < anuCastleMinY; ++y) {
                            for (x = offset; x < 16; ++x) {
                                for (z = 0; z < 16; ++z) {
                                    chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                                }
                            }
                            ++offset;
                        }
                    } else if (chunkZ == -1) {
                        for (y = islandMinY; y < anuCastleMinY; ++y) {
                            for (x = offset; x < 16; ++x) {
                                for (z = offset; z < 16; ++z) {
                                    chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                                }
                            }
                            ++offset;
                        }
                    }
                }
                if (chunkZ == -1) {
                    if (chunkX >= 0 && chunkX < 9) {
                        for (y = islandMinY; y < anuCastleMinY; ++y) {
                            for (x = 0; x < 16; ++x) {
                                for (z = offset; z < 16; ++z) {
                                    chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                                }
                            }
                            ++offset;
                        }
                    } else if (chunkX == 9) {
                        for (y = islandMinY; y < anuCastleMinY; ++y) {
                            for (x = 15 - offset; x >= 0; --x) {
                                for (z = offset; z < 16; ++z) {
                                    chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                                }
                            }
                            ++offset;
                        }
                    }
                }
                if (chunkX == 9) {
                    if (chunkZ >= 0 && chunkZ < 9) {
                        for (y = islandMinY; y < anuCastleMinY; ++y) {
                            for (x = 15 - offset; x >= 0; --x) {
                                for (z = 0; z < 16; ++z) {
                                    chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                                }
                            }
                            ++offset;
                        }
                    } else if (chunkZ == 9) {
                        for (y = islandMinY; y < anuCastleMinY; ++y) {
                            for (x = 15 - offset; x >= 0; --x) {
                                for (z = 15 - offset; z >= 0; --z) {
                                    chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                                }
                            }
                            ++offset;
                        }
                    }
                }
                if (chunkZ != 9) break block40;
                if (chunkX < 0 || chunkX >= 9) break block41;
                for (y = islandMinY; y < anuCastleMinY; ++y) {
                    for (x = 0; x < 16; ++x) {
                        for (z = 15 - offset; z >= 0; --z) {
                            chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                        }
                    }
                    ++offset;
                }
                break block40;
            }
            if (chunkX != -1) break block40;
            for (y = islandMinY; y < anuCastleMinY; ++y) {
                for (x = offset; x < 16; ++x) {
                    for (z = 15 - offset; z >= 0; --z) {
                        chunk.m_6978_((BlockPos)mutable.m_122178_(x, y, z), netherrack, false);
                    }
                }
                ++offset;
            }
        }
    }

    public void m_6929_(WorldGenRegion level) {
    }

    public int m_6331_() {
        return 0;
    }

    @NotNull
    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6337_() {
        return 0;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_142647_(int x, int z, Heightmap.Types type, LevelHeightAccessor level) {
        return 0;
    }

    @NotNull
    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor level) {
        return new NoiseColumn(level.m_141937_(), new BlockState[0]);
    }
}

