/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.placement;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.world.feature.ModOreFeatures;
import com.github.teamfossilsarcheology.fossil.world.feature.configuration.ModConfiguredFeatures;
import com.github.teamfossilsarcheology.fossil.world.feature.placement.LazyCountPlacement;
import com.github.teamfossilsarcheology.fossil.world.feature.placement.LazyRandomSpreadPlacement;
import com.github.teamfossilsarcheology.fossil.world.feature.placement.LazyRarityFilter;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.StructureSets;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class ModPlacedFeatures {
    public static final Holder<PlacedFeature> LAKE_LAVA_VOLCANO = PlacementUtils.m_206513_((String)"volcano_lake_lava", (Holder)MiscOverworldFeatures.f_195016_, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)6), CountPlacement.m_191628_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    public static final Holder<PlacedFeature> FOSSIL_VOLCANO = PlacementUtils.m_206513_((String)"volcano_fossil", (Holder)CaveFeatures.f_194939_, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), RandomOffsetPlacement.m_191877_((IntProvider)ClampedNormalInt.m_185879_((float)-9.0f, (float)4.0f, (int)-16, (int)-5)), BiomeFilter.m_191561_()});
    private static Holder<PlacedFeature> ashDiskVolcano;
    private static Holder<PlacedFeature> magmaDiskVolcano;
    private static Holder<PlacedFeature> coneVolcano;
    private static Holder<PlacedFeature> ventVolcano;

    public static void register() {
        ashDiskVolcano = PlacementUtils.m_206513_((String)"volcano_ash_disk", ModConfiguredFeatures.ASH_DISK, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        magmaDiskVolcano = PlacementUtils.m_206513_((String)"volcano_magma_disk", ModConfiguredFeatures.MAGMA_DISK, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        coneVolcano = PlacementUtils.m_206513_((String)"volcano_cone", ModConfiguredFeatures.VOLCANO_CONE, (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)30), PlacementUtils.f_195353_, BiomeFilter.m_191561_()});
        ventVolcano = PlacementUtils.m_206513_((String)"volcano_vent", ModConfiguredFeatures.VOLCANO_VENT, (PlacementModifier[])new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        Holder moaiStatuePlaced = PlacementUtils.m_206513_((String)"moai_statue", ModConfiguredFeatures.MOAI_STATUE, (PlacementModifier[])new PlacementModifier[]{BiomeFilter.m_191561_(), new LazyRarityFilter("moaiRarity"), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_});
        Holder upperFossilBlockPlaced = PlacementUtils.m_206509_((String)"fossil_block_no_sandstone_placed_upper", ModOreFeatures.FOSSIL_BLOCK_NO_SANDSTONE, ModPlacedFeatures.commonOrePlacement("fossilOreRarity", (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)76), (VerticalAnchor)VerticalAnchor.m_158929_())));
        Holder middleFossilBlockPlaced = PlacementUtils.m_206509_((String)"fossil_block_placed_middle", ModOreFeatures.FOSSIL_BLOCK, ModPlacedFeatures.commonOrePlacement("fossilOreRarity", (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)75))));
        Holder deepFossilBlockPlaced = PlacementUtils.m_206509_((String)"fossil_block_placed_deep", ModOreFeatures.FOSSIL_BLOCK, ModPlacedFeatures.commonOrePlacement("fossilOreRarity", (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))));
        Holder volcanicRockPlaced = PlacementUtils.m_206509_((String)"volcanic_rock_placed", ModOreFeatures.VOLCANIC_ROCK, ModPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))));
        Holder permafrostBlockPlaced = PlacementUtils.m_206509_((String)"permafrost_block_placed", ModOreFeatures.PERMAFROST_BLOCK, ModPlacedFeatures.commonOrePlacement("permafrostRarity", (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)100), (VerticalAnchor)VerticalAnchor.m_158930_((int)256))));
        Holder oreAmber = PlacementUtils.m_206509_((String)"amber_ore_placed", ModOreFeatures.ORE_AMBER, ModPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))));
        Holder oreAmberBuried = PlacementUtils.m_206509_((String)"ore_amber_buried", ModOreFeatures.ORE_AMBER_BURIED, ModPlacedFeatures.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))));
        BiomeModifications.addProperties((context, mutable) -> {
            if (FossilConfig.isEnabled("generateFossils")) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, upperFossilBlockPlaced);
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, middleFossilBlockPlaced);
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, deepFossilBlockPlaced);
            }
            if (FossilConfig.isEnabled("generateVolcanicRock")) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, volcanicRockPlaced);
            }
            if (FossilConfig.isEnabled("generatePermafrost") && (double)mutable.getClimateProperties().getTemperature() < 0.15) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, permafrostBlockPlaced);
            }
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, oreAmber);
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, oreAmberBuried);
            if (FossilConfig.isEnabled("generateMoai") && mutable.getCategory() == Biome.BiomeCategory.BEACH && (double)mutable.getClimateProperties().getTemperature() > 0.2) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, moaiStatuePlaced);
            }
            if (FossilConfig.isEnabled("spawnAlligatorGar") && mutable.getCategory() == Biome.BiomeCategory.SWAMP) {
                mutable.getSpawnProperties().addSpawn(((EntityType)ModEntities.ALLIGATOR_GAR.get()).m_20674_(), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ALLIGATOR_GAR.get(), FossilConfig.getInt("alligatorGarSpawnWeight"), 1, 4));
            }
            if (FossilConfig.isEnabled("spawnCoelacanth") && mutable.getCategory() == Biome.BiomeCategory.OCEAN) {
                mutable.getSpawnProperties().addSpawn(((EntityType)ModEntities.COELACANTH.get()).m_20674_(), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.COELACANTH.get(), FossilConfig.getInt("coelacanthSpawnWeight"), 1, 4));
            }
            if (FossilConfig.isEnabled("spawnNautilus") && mutable.getCategory() == Biome.BiomeCategory.OCEAN) {
                mutable.getSpawnProperties().addSpawn(((EntityType)ModEntities.NAUTILUS.get()).m_20674_(), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.NAUTILUS.get(), FossilConfig.getInt("nautilusSpawnWeight"), 1, 4));
            }
            if (FossilConfig.isEnabled("spawnSturgeon") && mutable.getCategory() == Biome.BiomeCategory.RIVER) {
                mutable.getSpawnProperties().addSpawn(((EntityType)ModEntities.STURGEON.get()).m_20674_(), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STURGEON.get(), FossilConfig.getInt("sturgeonSpawnWeight"), 1, 4));
            }
        });
    }

    public static Holder<PlacedFeature> ashDiskVolcano() {
        return ashDiskVolcano;
    }

    public static Holder<PlacedFeature> magmaDiskVolcano() {
        return magmaDiskVolcano;
    }

    public static Holder<PlacedFeature> coneVolcano() {
        return coneVolcano;
    }

    public static Holder<PlacedFeature> ventVolcano() {
        return ventVolcano;
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier placementModifier, PlacementModifier placementModifier2) {
        return List.of(placementModifier, InSquarePlacement.m_191715_(), placementModifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(String configEntry, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)new LazyCountPlacement(configEntry), placementModifier);
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), placementModifier);
    }

    private static List<PlacementModifier> rareOrePlacement(int rarity, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)rarity), placementModifier);
    }

    static {
        StructureSets.m_211131_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)FossilMod.location("hell_boat")), ModConfiguredFeatures.HELL_BOAT, (StructurePlacement)new LazyRandomSpreadPlacement("hellShipSpacing", "hellShipSeparation", RandomSpreadType.LINEAR, 92182587));
    }
}

