/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.TreeBranchLayouts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CalamitesTreeFeature
extends CustomTreeFeature {
    boolean placeLargeVariant(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState log = ((RotatedPillarBlock)ModBlocks.CALAMITES_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.CALAMITES_LEAVES.get()).m_49966_();
        int treeHeight = 24 + context.m_159776_().nextInt(16) - 8;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        int thickHeight = (int)Math.floor((double)treeHeight * 0.4);
        for (int i = 0; i < treeHeight; ++i) {
            BlockPos northPos;
            Object stateNorth;
            BlockPos southPos;
            BlockState stateSouth;
            BlockPos westPos;
            BlockState stateWest;
            level.m_7731_(pos.m_6630_(i), log, 19);
            if (i >= thickHeight) continue;
            BlockPos eastPos = pos.m_142082_(1, i, 0);
            BlockState stateEast = level.m_8055_(eastPos);
            if (stateEast.m_60767_().m_76336_()) {
                level.m_7731_(eastPos, log, 19);
            }
            if ((stateWest = level.m_8055_(westPos = pos.m_142082_(-1, i, 0))).m_60767_().m_76336_()) {
                level.m_7731_(westPos, log, 19);
            }
            if ((stateSouth = level.m_8055_(southPos = pos.m_142082_(0, i, 1))).m_60767_().m_76336_()) {
                level.m_7731_(southPos, log, 19);
            }
            if (!(stateNorth = level.m_8055_(northPos = pos.m_142082_(0, i, -1))).m_60767_().m_76336_()) continue;
            level.m_7731_(northPos, log, 19);
        }
        int startY = 3 + context.m_159776_().nextInt(2);
        int sectionSpacing = 5;
        int availableHeight = treeHeight - startY;
        int sectionCount = Math.max(1, availableHeight / sectionSpacing);
        List<Object> sectionLayout = new ArrayList();
        for (int i = 0; i < sectionCount; ++i) {
            int sectionBaseY = startY + i * sectionSpacing;
            float heightFraction = 1.0f - (float)sectionBaseY / (float)treeHeight;
            if (i == 0) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_2, TreeBranchLayouts.CALAMITES_LARGE_SECTION_3);
            } else if (heightFraction < 0.35f) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_0, TreeBranchLayouts.CALAMITES_LARGE_SECTION_1);
            } else if (heightFraction < 0.6f) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_2, TreeBranchLayouts.CALAMITES_LARGE_SECTION_3);
                for (Direction dir : List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST)) {
                    for (int d = 1; d <= 2; ++d) {
                        logPos = pos.m_142082_(dir.m_122429_() * d, sectionBaseY, dir.m_122431_() * d);
                        stateAt = level.m_8055_(logPos);
                        if (!stateAt.m_60767_().m_76336_()) continue;
                        level.m_7731_(logPos, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(dir == Direction.NORTH || dir == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X)), 19);
                    }
                }
            } else if (heightFraction < 0.85f) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_4, TreeBranchLayouts.CALAMITES_LARGE_SECTION_5);
                for (Direction dir : List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST)) {
                    for (int d = 1; d <= 4; ++d) {
                        logPos = pos.m_142082_(dir.m_122429_() * d, sectionBaseY, dir.m_122431_() * d);
                        stateAt = level.m_8055_(logPos);
                        if (!stateAt.m_60767_().m_76336_()) continue;
                        level.m_7731_(logPos, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(dir == Direction.NORTH || dir == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X)), 19);
                    }
                }
            } else {
                sectionLayout = TreeBranchLayouts.CALAMITES_LARGE_SECTION_0;
            }
            if (Math.abs(sectionBaseY - treeHeight) <= 2) {
                sectionLayout = List.of();
            }
            for (BlockPos relPos : sectionLayout) {
                BlockPos leafPos = pos.m_142082_(relPos.m_123341_(), sectionBaseY + relPos.m_123342_(), relPos.m_123343_());
                BlockState stateAtPos = level.m_8055_(leafPos);
                if (!stateAtPos.m_60767_().m_76336_()) continue;
                this.placeLeaf(level, leafPos, leaves);
            }
        }
        for (BlockPos relPos : TreeBranchLayouts.CALAMITES_LARGE_SECTION_0) {
            BlockPos leafPos = pos.m_142082_(relPos.m_123341_(), treeHeight + relPos.m_123342_() - 1, relPos.m_123343_());
            BlockState stateAtPos = level.m_8055_(leafPos);
            if (!stateAtPos.m_60767_().m_76336_()) continue;
            this.placeLeaf(level, leafPos, leaves);
        }
        if (context.m_159776_().nextBoolean()) {
            BlockPos leafPos = pos.m_6630_(treeHeight);
            BlockState stateAtPos = level.m_8055_(leafPos);
            if (stateAtPos.m_60767_().m_76336_()) {
                this.placeLeaf(level, leafPos, leaves);
            }
            if (context.m_159776_().nextBoolean() && (stateAtPos = level.m_8055_(leafPos = pos.m_6630_(treeHeight + 1))).m_60767_().m_76336_()) {
                this.placeLeaf(level, leafPos, leaves);
            }
        }
        return true;
    }

    boolean placeMediumVariant(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState log = ((RotatedPillarBlock)ModBlocks.CALAMITES_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.CALAMITES_LEAVES.get()).m_49966_();
        int treeHeight = 12 + context.m_159776_().nextInt(9) - 4;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
        }
        int startY = 2 + context.m_159776_().nextInt(2);
        int sectionSpacing = 3;
        int availableHeight = treeHeight - startY;
        int sectionCount = Math.max(1, availableHeight / sectionSpacing);
        int lastSectionType = -1;
        int lastSectionBaseY = -1;
        for (int i = 0; i < sectionCount; ++i) {
            List<Object> sectionLayout;
            int sectionBaseY = startY + i * sectionSpacing;
            if (i == 0) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_MED_SECTION_1, TreeBranchLayouts.CALAMITES_MED_SECTION_2);
            } else {
                float heightFraction;
                if (lastSectionType == 2 || lastSectionType == 3) {
                    sectionBaseY = lastSectionBaseY + sectionSpacing + 1;
                }
                if ((heightFraction = (float)sectionBaseY / (float)treeHeight) <= 0.5f) {
                    choice = context.m_159776_().nextInt(8);
                    switch (choice) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_3;
                            lastSectionType = 3;
                            break;
                        }
                        default: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_2;
                            lastSectionType = 2;
                            break;
                        }
                    }
                } else if (heightFraction <= 0.7f) {
                    choice = context.m_159776_().nextInt(8);
                    switch (choice) {
                        case 0: 
                        case 1: 
                        case 2: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_2;
                            lastSectionType = 2;
                            break;
                        }
                        default: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_1;
                            lastSectionType = 1;
                            break;
                        }
                    }
                } else {
                    choice = context.m_159776_().nextInt(8);
                    switch (choice) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_1;
                            lastSectionType = 1;
                            break;
                        }
                        default: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_2;
                            lastSectionType = 2;
                        }
                    }
                }
            }
            if (Math.abs(sectionBaseY - treeHeight) <= 1) {
                sectionLayout = List.of();
            }
            for (BlockPos relPos : sectionLayout) {
                BlockPos leafPos = pos.m_142082_(relPos.m_123341_(), sectionBaseY + relPos.m_123342_(), relPos.m_123343_());
                BlockState stateAtPos = level.m_8055_(leafPos);
                if (!stateAtPos.m_60767_().m_76336_()) continue;
                this.placeLeaf(level, leafPos, leaves);
            }
            lastSectionBaseY = sectionBaseY;
        }
        for (BlockPos relPos : TreeBranchLayouts.CALAMITES_MED_SECTION_0) {
            BlockPos leafPos = pos.m_142082_(relPos.m_123341_(), treeHeight + relPos.m_123342_(), relPos.m_123343_());
            BlockState stateAtPos = level.m_8055_(leafPos);
            if (!stateAtPos.m_60767_().m_76336_()) continue;
            this.placeLeaf(level, leafPos, leaves);
        }
        if (context.m_159776_().nextBoolean()) {
            BlockPos leafPos = pos.m_6630_(treeHeight + 1);
            BlockState stateAtPos = level.m_8055_(leafPos);
            if (stateAtPos.m_60767_().m_76336_()) {
                this.placeLeaf(level, leafPos, leaves);
            }
            if (context.m_159776_().nextBoolean() && (stateAtPos = level.m_8055_(leafPos = pos.m_6630_(treeHeight + 2))).m_60767_().m_76336_()) {
                this.placeLeaf(level, leafPos, leaves);
            }
        }
        return true;
    }

    boolean placeSmallVariant(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState log = ((RotatedPillarBlock)ModBlocks.CALAMITES_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.CALAMITES_LEAVES.get()).m_49966_();
        int treeHeight = 8 + context.m_159776_().nextInt(3) - 1;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
        }
        ArrayList<BlockPos> leafPositions = new ArrayList<BlockPos>();
        int variant = context.m_159776_().nextInt(3);
        switch (variant) {
            case 0: {
                leafPositions.addAll(TreeBranchLayouts.CALAMITES_SMALL_VARIANT_A);
                break;
            }
            case 1: {
                leafPositions.addAll(TreeBranchLayouts.CALAMITES_SMALL_VARIANT_B);
                break;
            }
            case 2: {
                leafPositions.addAll(TreeBranchLayouts.CALAMITES_SMALL_VARIANT_C);
            }
        }
        if (context.m_159776_().nextBoolean()) {
            leafPositions.add(new BlockPos(0, 0, 0));
            if (context.m_159776_().nextBoolean()) {
                leafPositions.add(new BlockPos(0, 1, 0));
            }
        }
        for (int i = 0; i < leafPositions.size(); ++i) {
            BlockPos leafPos = (BlockPos)leafPositions.get(i);
            BlockPos worldPos = pos.m_6630_(treeHeight).m_141952_((Vec3i)leafPos);
            BlockState stateAtPos = level.m_8055_(worldPos);
            if (!stateAtPos.m_60767_().m_76336_()) continue;
            this.placeLeaf(level, pos.m_6630_(treeHeight).m_141952_((Vec3i)leafPos), leaves);
        }
        return true;
    }

    @Override
    protected boolean placeTree(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        switch (context.m_159776_().nextInt(8)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.placeSmallVariant(context);
            }
            case 5: 
            case 6: {
                return this.placeMediumVariant(context);
            }
            case 7: {
                return this.placeLargeVariant(context);
            }
        }
        return true;
    }

    private List<BlockPos> randomChoice(FeaturePlaceContext<NoneFeatureConfiguration> context, List<BlockPos> a, List<BlockPos> b) {
        return context.m_159776_().nextBoolean() ? a : b;
    }
}

