/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.FossilLeavesBlock;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public abstract class CustomTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private final Map<BlockPos, BlockState> placedLeaves = new LinkedHashMap<BlockPos, BlockState>();

    protected CustomTreeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        this.placedLeaves.clear();
        if (this.placeTree(context)) {
            for (Map.Entry<BlockPos, BlockState> leaf : this.placedLeaves.entrySet()) {
                if (!context.m_159774_().m_8055_(leaf.getKey()).m_60713_(leaf.getValue().m_60734_())) continue;
                FossilLeavesBlock.updateInitialDistance(context.m_159774_(), leaf.getKey(), leaf.getValue());
            }
            return true;
        }
        return false;
    }

    protected abstract boolean placeTree(FeaturePlaceContext<NoneFeatureConfiguration> var1);

    protected void placeLeaf(WorldGenLevel level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, state, 19);
        this.placedLeaves.put(pos.m_7949_(), state);
    }

    protected void removeLeaf(WorldGenLevel level, BlockPos pos) {
        level.m_7471_(pos, false);
        this.placedLeaves.remove(pos.m_7949_());
    }

    protected int getMaxFreeTreeHeight(LevelSimulatedReader level, int trunkHeight, BlockPos topPosition) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= trunkHeight + 1; ++i) {
            int j = 0;
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutableBlockPos.m_122154_((Vec3i)topPosition, k, i, l);
                    if (TreeFeature.m_67262_((LevelSimulatedReader)level, (BlockPos)mutableBlockPos) && !CustomTreeFeature.isVine(level, (BlockPos)mutableBlockPos)) continue;
                    return i - 2;
                }
            }
        }
        return trunkHeight;
    }

    private static boolean isVine(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, blockState -> blockState.m_60713_(Blocks.f_50191_));
    }
}

