/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.AbstractAnimationList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.EntityList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.InstructionsList;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.InstructionMessage;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import net.minecraft.class_4064;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class InstructionTab
extends DebugTab<Prehistoric> {
    public static final Map<UUID, Pair> INSTRUCTIONS = new Object2ObjectOpenHashMap();
    private InstructionsList instructions;
    private AbstractAnimationList animations;
    private EntityList attackEntities;
    private EntityList leapEntities;
    public static class_1297 entityListHighlight;
    public static class_1297 highlightInstructionEntity;
    public static Instruction highlightInstruction;
    public static Instruction.Type positionMode;
    public static int teleportRotation;
    public static Prehistoric activeEntity;

    protected InstructionTab(DebugScreen debugScreen, Prehistoric entity) {
        super(debugScreen, entity);
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        this.instructions = this.addWidget(new InstructionsList(INSTRUCTIONS.computeIfAbsent(((Prehistoric)this.entity).method_5667(), id -> new Pair(((Prehistoric)this.entity).method_5628(), new ArrayList<Instruction>())), this.minecraft));
        this.addWidget(new class_4185(5, 340, 50, 20, (class_2561)new class_2585("Start"), button -> {
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).method_5628(), true, InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions));
            this.debugScreen.method_25419();
            this.onClose();
        }));
        this.addWidget(new class_4185(5, 365, 50, 20, (class_2561)new class_2585("Stop"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).method_5628(), true, List.of()))));
        this.addWidget(new class_4185(60, 365, 70, 20, (class_2561)new class_2585("Stop All"), button -> {
            for (Map.Entry<UUID, Pair> entry : INSTRUCTIONS.entrySet()) {
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(entry.getValue().id, true, List.of()));
            }
            this.debugScreen.method_25419();
            this.onClose();
        }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Stops Instruction for all mobs"), i, j)));
        this.addWidget(new class_4185(60, 340, 70, 20, (class_2561)new class_2585("Start All"), button -> {
            for (Map.Entry<UUID, Pair> entry : INSTRUCTIONS.entrySet()) {
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(entry.getValue().id, true, entry.getValue().instructions));
            }
            this.debugScreen.method_25419();
            this.onClose();
        }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Starts Instruction for all mobs"), i, j)));
        this.addWidget(new class_4185(135, 340, 50, 20, (class_2561)new class_2585("Debug"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).method_5628(), true, InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions)), (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Starts Instruction without closing the debug menu"), i, j)));
        this.addWidget(new class_4185(220, 5, 100, 20, (class_2561)new class_2585("Walk Builder"), button -> {
            positionMode = Instruction.Type.MOVE_TO;
            this.debugScreen.method_25419();
        }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Left click to place, Right click to cancel"), i, j)));
        this.addWidget(new class_4185(220, 30, 100, 20, (class_2561)new class_2585("Teleport Builder"), button -> {
            positionMode = Instruction.Type.TELEPORT_TO;
            teleportRotation = 0;
            this.debugScreen.method_25419();
        }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Left click to place, Right click to cancel, Mousewheel to rotate"), i, j)));
        if (this.entity instanceof Meganeura) {
            this.addWidget(new class_4185(220, 55, 100, 20, (class_2561)new class_2585("Attach Builder"), button -> {
                positionMode = Instruction.Type.ATTACH_TO;
                this.debugScreen.method_25419();
            }));
        }
        List list = ((Prehistoric)this.entity).field_6002.method_18466(class_1309.class, class_4051.method_36626().method_18418(30.0).method_36627(), (class_1309)this.entity, ((Prehistoric)this.entity).method_5829().method_1014(30.0));
        this.leapEntities = new EntityList(width - 315, 200, 300, list, this.minecraft, entity1 -> {
            Instruction.LeapAttack instruction = new Instruction.LeapAttack(entity1.method_5628());
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        });
        if (this.entity instanceof PrehistoricFlying) {
            this.addWidget(new class_4185(220, 55, 100, 20, (class_2561)new class_2585("Fly Builder"), button -> {
                positionMode = Instruction.Type.FLY_TO;
                this.debugScreen.method_25419();
            }));
            this.addWidget(new class_4185(220, 80, 100, 20, (class_2561)new class_2585("Land Builder"), button -> {
                positionMode = Instruction.Type.FLY_LAND;
                this.debugScreen.method_25419();
            }));
        }
        if (this.entity instanceof PrehistoricLeaping) {
            this.addWidget(new class_4185(220, 55, 100, 20, (class_2561)new class_2585("Leap Builder"), button -> {
                positionMode = Instruction.Type.LEAP_LAND;
                this.debugScreen.method_25419();
            }));
            this.addWidget(new class_4185(width - 115, 5, 90, 20, (class_2561)new class_2585("Open Leap"), button -> {
                this.closeLists();
                this.addWidget(this.leapEntities);
            }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Won't save correctly when leaving the world"), i, j)));
        }
        this.attackEntities = new EntityList(width - 315, 200, 300, list, this.minecraft, entity1 -> {});
        List<String> controllers = ((Prehistoric)this.entity).getFactory().getOrCreateAnimationData(((Prehistoric)this.entity).method_5628()).getAnimationControllers().keySet().stream().toList();
        this.animations = new AnimationList(width - 315, ((Prehistoric)this.entity).getAllAnimations(), controllers, this.minecraft, animationObject -> {
            Instruction.PlayAnim instruction = new Instruction.PlayAnim(animationObject.name(), animationObject.controller(), animationObject.loop(), (int)animationObject.transitionLength());
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        });
        this.addWidget(new class_4185(width - 215, 5, 90, 20, (class_2561)new class_2585("Open Animations"), button -> {
            this.closeLists();
            this.addWidget(this.animations);
        }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Stops and plays animation x times or for x seconds"), i, j)));
        class_342 zPosInput = this.addWidget(new class_342(this.minecraft.field_1772, 325, 30, 30, 20, (class_2561)new class_2585("")));
        zPosInput.method_1852(new DecimalFormat("##", DecimalFormatSymbols.getInstance(Locale.US)).format(5L));
        this.addWidget(new class_4185(325, 5, 70, 20, (class_2561)new class_2585("Add Idle"), button -> {
            Instruction.Idle instruction = new Instruction.Idle(Integer.parseInt(zPosInput.method_1882()) * 20);
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        }));
        this.addWidget(new class_4185(400, 5, 70, 20, (class_2561)new class_2585("Add Sleep"), button -> {
            Instruction.Sleep instruction = new Instruction.Sleep(Integer.parseInt(zPosInput.method_1882()) * 20);
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        }));
    }

    private void closeLists() {
        this.widgets.remove((Object)this.leapEntities);
        this.renderables.remove((Object)this.leapEntities);
        this.widgets.remove((Object)this.animations);
        this.renderables.remove((Object)this.animations);
    }

    @Override
    protected void onOpen() {
        activeEntity = (Prehistoric)this.entity;
    }

    @Override
    protected void onClose() {
        activeEntity = null;
    }

    public static void addPosition(class_3965 hitResult) {
        if (activeEntity == null) {
            return;
        }
        class_2338 target = hitResult.method_17777().method_10093(hitResult.method_17780());
        if (positionMode == Instruction.Type.MOVE_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.MoveTo(target));
        } else if (positionMode == Instruction.Type.FLY_LAND) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.FlyLand(target));
        } else if (positionMode == Instruction.Type.TELEPORT_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.TeleportTo(target, -teleportRotation + 180));
        } else if (positionMode == Instruction.Type.ATTACH_TO) {
            target = hitResult.method_17777();
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.AttachTo(target, hitResult.method_17780(), hitResult.method_17784()));
        } else if (positionMode == Instruction.Type.LEAP_LAND) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.LeapLand(hitResult.method_17784(), hitResult.method_17784().method_1031(0.0, 2.0, 0.0)));
        }
    }

    public static void addFlyPosition(class_2338 target) {
        if (positionMode == Instruction.Type.FLY_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.FlyTo(target));
        }
    }

    public static boolean positionActive() {
        return positionMode != Instruction.Type.IDLE;
    }

    @Override
    protected void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
    }

    static {
        positionMode = Instruction.Type.IDLE;
    }

    public record Pair(int id, List<Instruction> instructions) {
    }

    private static class AnimationList
    extends AbstractAnimationList {
        public AnimationList(int x0, Map<String, ? extends AnimationInfo> animations, List<String> controllers, class_310 minecraft, Consumer<AbstractAnimationList.AnimationObject> function) {
            super(x0, 300, 25, 60, animations, minecraft, function);
            int buttonX = x0 + this.rowWidth + 15;
            if (!controllers.isEmpty()) {
                this.currentControllerName = controllers.get(0);
                this.addWidget(class_4064.method_32523((String)"", () -> controllers, class_2585::new, options -> this.currentControllerName, (options, option, controller) -> {
                    this.currentControllerName = controller;
                }).method_18520(class_310.method_1551().field_1690, buttonX, this.field_19085, 100));
            }
            this.addWidget(new DebugSlider(buttonX, this.field_19085 + 25, 100, 20, (class_2561)new class_2585("Count: "), (class_2561)new class_2585(""), 0.0, 20.0, this.transitionLength, 1.0, 3, true){

                @Override
                protected void method_25344() {
                    transitionLength = (float)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            });
            this.addWidget(class_4064.method_32522((String)"Time based", options -> this.loop, (options, option, loop) -> {
                this.loop = loop;
            }).method_18520(class_310.method_1551().field_1690, buttonX, this.field_19085 + 50, 100));
        }
    }
}

