/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.blockentity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnuBarrierOriginBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.AnuBarrierBlockEntity;
import java.util.stream.IntStream;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_827;

public class AnuBarrierRenderer
implements class_827<AnuBarrierBlockEntity> {
    private final float textureWidth = 16.0f;
    private final float textureHeight = 16.0f;
    private static final class_2960[] LOCATIONS = (class_2960[])IntStream.range(1, 32).mapToObj(idx -> FossilMod.location("textures/block/anu_portal/anu_portal_" + idx + ".png")).toArray(class_2960[]::new);

    public AnuBarrierRenderer(class_5614.class_5615 context) {
    }

    public void render(AnuBarrierBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        poseStack.method_22903();
        class_2350 direction = (class_2350)blockEntity.method_11010().method_11654((class_2769)AnuBarrierOriginBlock.FACING);
        poseStack.method_22904(0.5, 0.0, 0.5);
        poseStack.method_22907(class_1160.field_20705.method_23214(-direction.method_10144() + 180.0f));
        poseStack.method_22904(-0.5, 0.0, -0.5);
        poseStack.method_22905(0.0625f, 0.0625f, direction.method_10166() == class_2350.class_2351.field_11048 ? 0.063f : 0.062f);
        int i = (int)(blockEntity.method_10997().method_8510() % (long)LOCATIONS.length);
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23689((class_2960)LOCATIONS[i]));
        int fixedLight = class_761.method_23794((class_1920)blockEntity.method_10997(), (class_2338)blockEntity.method_11016().method_10093(direction));
        this.renderBarrier(blockEntity, poseStack, vertexConsumer, fixedLight);
        poseStack.method_22909();
    }

    private void renderBarrier(AnuBarrierBlockEntity blockEntity, class_4587 poseStack, class_4588 vertexConsumer, int packedLight) {
        int maxWidth = (blockEntity.radius * 2 + 1) * 16;
        int maxHeight = blockEntity.height * 16;
        if (blockEntity.getState() == 1) {
            this.renderRectangle(poseStack, vertexConsumer, maxWidth, 0.0f, maxHeight, packedLight);
        } else if (blockEntity.getState() != 0) {
            int colCount;
            float step = class_3532.method_16439((float)((float)blockEntity.getBarrierTimer() / AnuBarrierBlockEntity.duration), (float)0.0f, (float)maxHeight);
            int rowWidth = (int)(2.0f + step * 2.0f);
            int x = colCount = rowWidth / 2;
            int y = 0;
            while (x > 0) {
                if (x * x + y * y > colCount * colCount) {
                    --x;
                    continue;
                }
                int prevY = y;
                boolean done = false;
                while (!done) {
                    if (x * x + ++y * y <= colCount * colCount) continue;
                    done = true;
                    this.renderRectangle(poseStack, vertexConsumer, Math.min(x * 2, maxWidth), prevY, Math.min(y, maxHeight) - prevY, packedLight);
                }
                --x;
            }
        }
    }

    private void renderRectangle(class_4587 poseStack, class_4588 vertexConsumer, int width, float y, int height, int packedLight) {
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        class_4581 matrix3f = poseStack.method_23760().method_23762();
        float minX = 8.0f - ((float)width - (float)width / 2.0f);
        float maxX = minX + (float)width;
        float maxY = y + (float)height;
        float offset = -class_3532.method_15375((float)((float)width / 2.0f));
        float minTexX = ((float)width + offset) / 16.0f;
        float maxTexX = offset / 16.0f;
        float minTexY = (16.0f - y) / 16.0f;
        float maxTexY = minTexY - (float)height / 16.0f;
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, y, maxTexX, minTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, y, minTexX, minTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, packedLight, true);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, packedLight, true);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, y, minTexX, minTexY, packedLight, true);
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, y, maxTexX, minTexY, packedLight, true);
    }

    private void vertex(class_1159 matrix4f, class_4581 matrix3f, class_4588 vertexConsumer, float x, float y, float u, float v, int n, boolean back) {
        if (back) {
            vertexConsumer.method_22918(matrix4f, x, y, 8.0f).method_1336(125, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(n).method_23763(matrix3f, 0.0f, 0.0f, -1.0f).method_1344();
        } else {
            vertexConsumer.method_22918(matrix4f, x, y, 8.0f).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(n).method_23763(matrix3f, 0.0f, 0.0f, -1.0f).method_1344();
        }
    }
}

