/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.renderer.RendererFabricFix;
import com.github.teamfossilsarcheology.fossil.entity.StoneTablet;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class StoneTabletRenderer
extends class_897<StoneTablet>
implements RendererFabricFix {
    private static final class_2960 TEXTURE = FossilMod.location("textures/entity/stone_tablet.png");

    public StoneTabletRenderer(class_5617.class_5618 context) {
        super(context);
    }

    private static int getLightColor(StoneTablet entity, float centerX, float centerY) {
        int x = entity.method_31477();
        int y = class_3532.method_15357((double)(entity.method_23318() + (double)(centerY / 16.0f)));
        int z = entity.method_31479();
        class_2350 direction = entity.method_5735();
        if (direction == class_2350.field_11043) {
            x = class_3532.method_15357((double)(entity.method_23317() + (double)(centerX / 16.0f)));
        }
        if (direction == class_2350.field_11039) {
            z = class_3532.method_15357((double)(entity.method_23321() - (double)(centerX / 16.0f)));
        }
        if (direction == class_2350.field_11035) {
            x = class_3532.method_15357((double)(entity.method_23317() - (double)(centerX / 16.0f)));
        }
        if (direction == class_2350.field_11034) {
            z = class_3532.method_15357((double)(entity.method_23321() + (double)(centerX / 16.0f)));
        }
        return class_761.method_23794((class_1920)entity.field_6002, (class_2338)new class_2338(x, y, z));
    }

    public void render(StoneTablet entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22907(class_1160.field_20705.method_23214(180.0f - entityYaw));
        StoneTablet.Variant variant = entity.variant;
        poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23576((class_2960)this.getTextureLocation(entity)));
        this.renderTablet(poseStack, vertexConsumer, entity, variant.sizeX, variant.sizeY, variant.offsetX, variant.offsetY);
        poseStack.method_22909();
        super.method_3936((class_1297)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private void renderTablet(class_4587 poseStack, class_4588 vertexConsumer, StoneTablet entity, int width, int height, int texU, int texV) {
        class_4587.class_4665 pose = poseStack.method_23760();
        class_1159 matrix4f = pose.method_23761();
        class_4581 matrix3f = pose.method_23762();
        float offsetX = (float)(-width) / 2.0f;
        float offsetY = (float)(-height) / 2.0f;
        for (int blockX = 0; blockX < width / 16; ++blockX) {
            for (int blockZ = 0; blockZ < height / 16; ++blockZ) {
                float minX = offsetX + (float)(blockX * 16);
                float maxX = offsetX + (float)((blockX + 1) * 16);
                float minY = offsetY + (float)(blockZ * 16);
                float maxY = offsetY + (float)((blockZ + 1) * 16);
                int light = StoneTabletRenderer.getLightColor(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                float minTexX = (float)(texU + width - blockX * 16) / 256.0f;
                float maxTexX = (float)(texU + width - (blockX + 1) * 16) / 256.0f;
                float minTexY = (float)(texV + height - blockZ * 16) / 256.0f;
                float maxTexY = (float)(texV + height - (blockZ + 1) * 16) / 256.0f;
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, minY, maxTexX, minTexY, 0.4f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, minY, minTexX, minTexY, 0.4f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, 0.4f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, 0.4f, 0, 0, -1, light);
                minTexY = (float)(texV + (height + 128) - blockZ * 16) / 256.0f;
                maxTexY = (float)(texV + (height + 128) - (blockZ + 1) * 16) / 256.0f;
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, minY, minTexX, minTexY, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, minY, maxTexX, minTexY, 0.5f, 0, 0, 1, light);
            }
        }
    }

    private void vertex(class_1159 matrix4f, class_4581 matrix3f, class_4588 vertexConsumer, float x, float y, float u, float v, float z, int k, int l, int m, int n) {
        vertexConsumer.method_22918(matrix4f, x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(n).method_23763(matrix3f, (float)k, (float)l, (float)m).method_1344();
    }

    @NotNull
    public class_2960 getTextureLocation(StoneTablet entity) {
        return TEXTURE;
    }

    @Override
    public class_2960 method_3931(class_1297 entity) {
        return this.getTextureLocation((StoneTablet)entity);
    }
}

