/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_5134;

public class LeapSystem
extends AISystem {
    public static final int JUMP_DISTANCE = 30;
    private final PrehistoricLeaping mob;
    private final class_2945 entityData;
    private UUID loadedTarget;
    private class_1309 target;
    private class_243 blockTarget;
    private boolean leaping;
    private long jumpDelayTick = -1L;
    private long landingDelayTick = -1L;
    private long landingEndTick = -1L;
    private long lastLeapEndTick = -1L;

    public LeapSystem(PrehistoricLeaping mob) {
        super(mob);
        this.mob = mob;
        this.entityData = mob.method_5841();
    }

    @Override
    public void serverTick() {
        ServerAnimationInfo animation;
        long currentTick = this.mob.field_6002.method_8510();
        if (this.mob.method_5854() != null) {
            if (this.mob.method_5854().method_5667().equals(this.loadedTarget)) {
                this.setLeapTarget((class_1309)this.mob.method_5854());
                this.loadedTarget = null;
            } else if (this.target == null && this.isAttackRiding()) {
                this.mob.method_5848();
                this.stopAttackRiding();
            }
        }
        if (!this.isLeaping() && this.target != null && this.target.method_5805()) {
            this.mob.method_5951((class_1297)this.target, 100.0f, 10.0f);
            if (this.mob.method_5858((class_1297)this.target) < 30.0) {
                this.startLeap();
                if (this.mob.hasLeapAnimation()) {
                    animation = (ServerAnimationInfo)this.mob.getLeapStartAnimation();
                    this.jumpDelayTick = (long)((double)currentTick + animation.actionDelay);
                } else {
                    this.jumpDelayTick = currentTick + 2L;
                }
                this.mob.method_18799(class_243.field_1353);
            }
        }
        if (!this.isLeaping() && this.blockTarget != null && this.mob.method_5707(this.blockTarget) < 30.0) {
            this.startLeap();
            if (this.mob.hasLeapAnimation()) {
                animation = (ServerAnimationInfo)this.mob.getLeapStartAnimation();
                this.jumpDelayTick = (long)((double)currentTick + animation.actionDelay);
            } else {
                this.jumpDelayTick = currentTick + 2L;
            }
            this.mob.method_18799(class_243.field_1353);
        }
        if (this.isLeaping()) {
            if (this.target == null && this.blockTarget == null) {
                this.stopLeap();
            }
            if (this.target != null && (this.target.method_5782() && this.mob.method_5854() != this.target || this.target.method_29504())) {
                if (this.jumpDelayTick != -1L) {
                    this.blockTarget = this.target.method_19538();
                }
                this.setAttackRiding(false);
                this.setLeapTarget(null);
            }
            if (currentTick == this.jumpDelayTick) {
                class_243 offset;
                double y;
                if (this.target != null) {
                    y = Math.min(this.target.method_23318() + (double)this.target.method_17682() - this.mob.method_23318(), 5.0);
                    offset = Util.directionVecTo((class_1297)this.mob, (class_1297)this.target).method_1029();
                    offset = offset.method_1031(this.target.method_18798().field_1352, 0.0, this.target.method_18798().field_1350);
                } else if (this.blockTarget != null) {
                    y = Math.min(this.blockTarget.field_1351 - this.mob.method_23318(), 5.0);
                    offset = this.blockTarget.method_1020(this.mob.method_19538()).method_1029();
                } else {
                    y = 0.0;
                    offset = class_243.field_1353;
                }
                this.mob.method_18800(offset.field_1352, -0.027 * Math.pow(y, 2.0) + 0.262 * y + 0.183, offset.field_1350);
                this.setLeapStarted(false);
                this.setLeapFlying(true);
                this.landingDelayTick = this.jumpDelayTick + 5L;
                this.jumpDelayTick = -1L;
            }
            if (this.mob.method_24828() && this.landingDelayTick != -1L && this.landingDelayTick <= currentTick) {
                if (this.mob.hasLeapAnimation()) {
                    ServerAnimationInfo animation2 = (ServerAnimationInfo)this.mob.getLandAnimation();
                    this.landingEndTick = (long)((double)currentTick + animation2.animation.animationLength);
                } else {
                    this.landingEndTick = currentTick + 2L;
                }
                this.landingDelayTick = -1L;
                this.setLeapFlying(false);
                this.setLanding(true);
            }
            if (this.landingEndTick != -1L && this.landingEndTick <= currentTick) {
                this.setLanding(false);
                this.setLeaping(false);
                this.landingEndTick = -1L;
                this.setBlockLeapTarget(null);
                this.setLeapTarget(null);
            }
            if (this.isAttackRiding() && this.target != null) {
                if (this.mob.field_6012 % 20 == 0) {
                    this.target.method_5643(class_1282.method_5511((class_1309)this.mob), (float)this.mob.method_26825(class_5134.field_23721));
                }
                if (this.target.method_29504()) {
                    this.stopAttackRiding();
                }
            }
            if (!(this.isLeapFlying() || this.hasLeapStarted() || this.isLanding() || this.isAttackRiding())) {
                this.setLeaping(false);
            }
        }
    }

    public void startLeap() {
        this.jumpDelayTick = -1L;
        this.landingDelayTick = -1L;
        this.landingEndTick = -1L;
        this.setLeapFlying(false);
        this.setLeaping(true);
        this.setLeapStarted(true);
    }

    public void stopLeap() {
        this.setLeaping(false);
        this.setLeapFlying(false);
        this.setLeapStarted(false);
        this.setLanding(false);
        this.setLeapTarget(null);
    }

    public boolean isLeapingAt(class_1297 entity) {
        return this.target == entity && this.isLeapFlying();
    }

    public void tryAttackRiding(class_1297 target) {
        if (target.method_5685().isEmpty() && this.mob.hasLeapAnimation()) {
            this.setLeapFlying(false);
            this.setAttackRiding(true);
        } else {
            target.method_5643(class_1282.method_5511((class_1309)this.mob), (float)this.mob.method_26825(class_5134.field_23721));
        }
    }

    public void stopAttackRiding() {
        this.setLeaping(false);
        this.setAttackRiding(false);
        this.setLeapTarget(null);
    }

    public boolean isLeaping() {
        return this.leaping;
    }

    private void setLeaping(boolean leaping) {
        this.leaping = leaping;
    }

    public boolean isLeapFlying() {
        return (Boolean)this.entityData.method_12789(PrehistoricLeaping.LEAP_FLYING);
    }

    private void setLeapFlying(boolean leapFlying) {
        this.entityData.method_12778(PrehistoricLeaping.LEAP_FLYING, (Object)leapFlying);
    }

    public void setBlockLeapTarget(class_243 target) {
        this.blockTarget = target;
    }

    public void setLeapTarget(class_1309 target) {
        this.target = target;
        this.entityData.method_12778(PrehistoricLeaping.LEAP_TARGET_ID, (Object)-2);
        this.entityData.method_12778(PrehistoricLeaping.LEAP_TARGET_ID, (Object)(target == null ? -1 : target.method_5628()));
    }

    public boolean isLanding() {
        return (Boolean)this.entityData.method_12789(PrehistoricLeaping.LEAP_LANDING);
    }

    private void setLanding(boolean landing) {
        this.entityData.method_12778(PrehistoricLeaping.LEAP_LANDING, (Object)landing);
    }

    public boolean isAttackRiding() {
        return (Boolean)this.entityData.method_12789(PrehistoricLeaping.LEAP_RIDING);
    }

    public void setAttackRiding(boolean attackRiding) {
        if (((Boolean)this.entityData.method_12789(PrehistoricLeaping.LEAP_RIDING)).booleanValue() && !attackRiding) {
            this.lastLeapEndTick = this.mob.field_6002.method_8510();
        }
        this.entityData.method_12778(PrehistoricLeaping.LEAP_RIDING, (Object)attackRiding);
    }

    public long getLastLeapEndTick() {
        return this.lastLeapEndTick;
    }

    public void setLastLeapEndTick(long lastLeapEndTick) {
        this.lastLeapEndTick = lastLeapEndTick;
    }

    public boolean hasLeapStarted() {
        return (Boolean)this.entityData.method_12789(PrehistoricLeaping.LEAP_STARTED);
    }

    public void setLeapStarted(boolean value) {
        this.entityData.method_12778(PrehistoricLeaping.LEAP_STARTED, (Object)value);
    }

    @Override
    public void saveAdditional(class_2487 tag) {
        tag.method_10556("AttackRiding", this.isAttackRiding());
        if (this.target != null) {
            tag.method_25927("AttackRidingVehicle", this.target.method_5667());
        }
    }

    @Override
    public void load(class_2487 tag) {
        if (tag.method_10577("AttackRiding") && tag.method_10545("AttackRidingVehicle")) {
            this.setAttackRiding(true);
            this.setLeaping(true);
            this.loadedTarget = tag.method_25926("AttackRidingVehicle");
        }
    }
}

