/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.slf4j.Logger;

public abstract class FoodValueProvider
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final class_2403 generator;
    protected final boolean keepOldFiles;
    private final Path basePath;
    protected Map<FoodType, FoodAppender> builders;

    protected FoodValueProvider(class_2403 generator, boolean keepOldFiles) {
        this.generator = generator;
        this.keepOldFiles = keepOldFiles;
        this.basePath = generator.method_10313().resolve("data/fossil/food");
        this.builders = Arrays.stream(FoodType.values()).collect(Collectors.toMap(Function.identity(), type -> new FoodAppender()));
    }

    private Path getPath(FoodType type) {
        return this.basePath.resolve(type.name().toLowerCase(Locale.ENGLISH) + ".json");
    }

    public void method_10319(class_2408 cache) throws IOException {
        this.buildFoodValues();
        if (this.keepOldFiles) {
            cache.field_11282.entrySet().stream().filter(entry -> ((Path)entry.getKey()).startsWith(this.basePath)).forEach(entry -> cache.method_10325((Path)entry.getKey(), (String)entry.getValue()));
        }
        this.builders.forEach((type, foodAppender) -> {
            Path path = this.getPath((FoodType)((Object)type));
            if (foodAppender.items.isEmpty() && foodAppender.entities.isEmpty()) {
                if (this.keepOldFiles && cache.field_11282.containsKey(path)) {
                    cache.method_10325(path, (String)cache.field_11282.get(path));
                }
                return;
            }
            JsonObject jsonobject = foodAppender.serializeToJson();
            try {
                String jsonString = GSON.toJson((JsonElement)jsonobject);
                String hash = field_11280.hashUnencodedChars((CharSequence)jsonString).toString();
                if (!Objects.equals(cache.method_10323(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedWriter.write(jsonString);
                    }
                }
                cache.method_10325(path, hash);
            }
            catch (IOException var14) {
                LOGGER.error("Couldn't save food values to {}", (Object)path, (Object)var14);
            }
        });
    }

    protected abstract void buildFoodValues();

    protected FoodAppender type(FoodType type) {
        return this.builders.get((Object)type);
    }

    protected static class FoodAppender {
        private final List<Entry> items = new ObjectArrayList();
        private final List<Entry> entities = new ObjectArrayList();

        public void itemTag(class_6862<class_1792> tag) {
            this.items.add(new Entry(tag.comp_327(), -1, "tag"));
        }

        public void item(class_1935 item) {
            this.item(item, -1);
        }

        public void item(class_1935 item, int value) {
            this.items.add(new Entry(class_2378.field_11142.method_10221((Object)item.method_8389()), value, "item"));
        }

        public void entityTag(class_6862<class_1299<?>> tag) {
            this.entities.add(new Entry(tag.comp_327(), -1, "tag"));
        }

        public void entity(class_1299<?> entityType) {
            this.entity(entityType, -1);
        }

        public void entity(class_1299<?> entityType, int value) {
            this.entity(class_2378.field_11145.method_10221(entityType), value);
        }

        public void entity(class_2960 location, int value) {
            this.entities.add(new Entry(location, value, "entity"));
        }

        public JsonObject serializeToJson() {
            JsonObject root = new JsonObject();
            JsonArray itemArray = new JsonArray();
            JsonArray entityArray = new JsonArray();
            root.add("items", (JsonElement)itemArray);
            root.add("entities", (JsonElement)entityArray);
            this.items.stream().sorted(FoodAppender::compare).forEach(entry -> itemArray.add((JsonElement)entry.serialize()));
            this.entities.stream().sorted(FoodAppender::compare).forEach(entry -> entityArray.add((JsonElement)entry.serialize()));
            return root;
        }

        private static int compare(Entry one, Entry other) {
            int i = one.id.method_12836().compareTo(other.id.method_12836());
            if (i == 0) {
                i = one.id.method_12832().compareTo(other.id.method_12832());
            }
            return i;
        }

        private record Entry(class_2960 id, int value, String key) {
            public JsonObject serialize() {
                JsonObject object = new JsonObject();
                object.addProperty(this.key, this.id.toString());
                if (this.value >= 0) {
                    object.addProperty("value", (Number)this.value);
                }
                return object;
            }
        }
    }
}

