/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.event;

import com.faboslav.variantsandventures.common.entity.mob.GelidEntity;
import com.faboslav.variantsandventures.common.events.entity.ProjectileHitEvent;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.throwableitemprojectile.Snowball;

public final class GelidOnSnowballHitEvent {
    public static void handleSnowballHit(ProjectileHitEvent event) {
        Projectile projectile = event.projectile();
        if (!(projectile instanceof Snowball) || !(projectile.getOwner() instanceof GelidEntity)) {
            return;
        }
        Entity target = event.hitResult().getEntity();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        target.playSound(GelidOnSnowballHitEvent.getImpactSound(), 1.0f, 0.4f / (((LivingEntity)target).getRandom().nextFloat() * 0.4f + 0.8f));
        target.hurt(projectile.getOwner().damageSources().thrown((Entity)projectile, projectile.getOwner()), 4.0f);
        target.setTicksFrozen(240);
    }

    private static SoundEvent getImpactSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_SNOWBALL_IMPACT.get();
    }
}

