/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.init;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.model.GelidEntityModel;
import com.faboslav.variantsandventures.common.client.model.MurkEntityModel;
import com.faboslav.variantsandventures.common.client.model.ThicketEntityModel;
import com.faboslav.variantsandventures.common.events.client.RegisterEntityLayersEvent;
import com.faboslav.variantsandventures.common.util.LayerDefinitionFactory;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.monster.skeleton.SkeletonModel;
import net.minecraft.client.model.monster.zombie.ZombieModel;
import net.minecraft.client.renderer.entity.ArmorModelSet;

public final class VariantsAndVenturesModelLayers {
    private static final String GELID_ID = "gelid";
    private static final String THICKET_ID = "thicket";
    private static final String MURK_ID = "murk";
    private static final String VERDANT_ID = "verdant";
    private static final String GELID_BABY_ID = "gelid_baby";
    private static final String THICKET_BABY_ID = "thicket_baby";
    public static final ModelLayerLocation GELID = new ModelLayerLocation(VariantsAndVentures.makeID("gelid"), "main");
    public static final ModelLayerLocation GELID_OUTER = new ModelLayerLocation(VariantsAndVentures.makeID("gelid"), "outer");
    public static final ModelLayerLocation MURK = new ModelLayerLocation(VariantsAndVentures.makeID("murk"), "main");
    public static final ModelLayerLocation THICKET = new ModelLayerLocation(VariantsAndVentures.makeID("thicket"), "main");
    public static final ModelLayerLocation THICKET_OUTER = new ModelLayerLocation(VariantsAndVentures.makeID("thicket"), "outer");
    public static final ModelLayerLocation VERDANT = new ModelLayerLocation(VariantsAndVentures.makeID("verdant"), "main");
    public static final ModelLayerLocation GELID_BABY = new ModelLayerLocation(VariantsAndVentures.makeID("gelid_baby"), "main");
    public static final ModelLayerLocation GELID_BABY_OUTER = new ModelLayerLocation(VariantsAndVentures.makeID("gelid_baby"), "outer");
    public static final ModelLayerLocation THICKET_BABY = new ModelLayerLocation(VariantsAndVentures.makeID("thicket_baby"), "main");
    public static final ModelLayerLocation THICKET_BABY_OUTER = new ModelLayerLocation(VariantsAndVentures.makeID("thicket_baby"), "outer");
    public static final ArmorModelSet<ModelLayerLocation> GELID_ARMOR = ModelLayers.registerArmorSet((String)"gelid");
    public static final ArmorModelSet<ModelLayerLocation> GELID_BABY_ARMOR = ModelLayers.registerArmorSet((String)"gelid_baby");
    public static final ArmorModelSet<ModelLayerLocation> MURK_ARMOR = ModelLayers.registerArmorSet((String)"murk");
    public static final ArmorModelSet<ModelLayerLocation> THICKET_ARMOR = ModelLayers.registerArmorSet((String)"thicket");
    public static final ArmorModelSet<ModelLayerLocation> THICKET_BABY_ARMOR = ModelLayers.registerArmorSet((String)"thicket_baby");
    public static final ArmorModelSet<ModelLayerLocation> VERDANT_ARMOR = ModelLayers.registerArmorSet((String)"verdant");

    public static void registerEntityLayers(RegisterEntityLayersEvent event) {
        event.register(GELID, GelidEntityModel::createBodyLayer);
        event.register(GELID_OUTER, GelidEntityModel::createOuterLayer);
        event.register(MURK, MurkEntityModel::createBodyLayer);
        event.register(THICKET, ThicketEntityModel::createBodyLayer);
        event.register(THICKET_OUTER, ThicketEntityModel::createOuterLayer);
        event.register(VERDANT, SkeletonModel::createBodyLayer);
        VariantsAndVenturesModelLayers.registerArmorLayers(event, GELID_ARMOR, GelidEntityModel.createArmorLayers());
        VariantsAndVenturesModelLayers.registerArmorLayers(event, GELID_BABY_ARMOR, (ArmorModelSet<LayerDefinition>)GelidEntityModel.createArmorLayers().map(layerDefinition -> layerDefinition.apply(ZombieModel.BABY_TRANSFORMER)));
        VariantsAndVenturesModelLayers.registerArmorLayers(event, MURK_ARMOR, MurkEntityModel.createArmorLayers());
        VariantsAndVenturesModelLayers.registerArmorLayers(event, THICKET_ARMOR, ThicketEntityModel.createArmorLayers());
        VariantsAndVenturesModelLayers.registerArmorLayers(event, THICKET_BABY_ARMOR, (ArmorModelSet<LayerDefinition>)ThicketEntityModel.createArmorLayers().map(layerDefinition -> layerDefinition.apply(ZombieModel.BABY_TRANSFORMER)));
        VariantsAndVenturesModelLayers.registerArmorLayers(event, VERDANT_ARMOR, LayerDefinitionFactory.createArmorLayers());
        event.register(GELID_BABY, () -> GelidEntityModel.createBodyLayer().apply(ZombieModel.BABY_TRANSFORMER));
        event.register(GELID_BABY_OUTER, () -> GelidEntityModel.createOuterLayer().apply(ZombieModel.BABY_TRANSFORMER));
        event.register(THICKET_BABY, () -> ThicketEntityModel.createBodyLayer().apply(ZombieModel.BABY_TRANSFORMER));
        event.register(THICKET_BABY_OUTER, () -> ThicketEntityModel.createOuterLayer().apply(ZombieModel.BABY_TRANSFORMER));
    }

    public static void registerArmorLayers(RegisterEntityLayersEvent event, ArmorModelSet<ModelLayerLocation> armorModelSet, ArmorModelSet<LayerDefinition> armorLayers) {
        event.register((ModelLayerLocation)armorModelSet.head(), () -> armorLayers.head());
        event.register((ModelLayerLocation)armorModelSet.chest(), () -> armorLayers.chest());
        event.register((ModelLayerLocation)armorModelSet.legs(), () -> armorLayers.legs());
        event.register((ModelLayerLocation)armorModelSet.feet(), () -> armorLayers.feet());
    }

    private VariantsAndVenturesModelLayers() {
    }
}

