/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.util;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public final class AdvancementHelper {
    public static void triggerMonsterHunter(Level level, DamageSource damageSource) {
        if (level.isClientSide()) {
            return;
        }
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        Identifier advancementId = VariantsAndVentures.makeNamespacedId("minecraft:adventure/kill_a_mob");
        AdvancementHolder advancement = server.getAdvancements().get(advancementId);
        if (advancement == null) {
            return;
        }
        Entity entity = damageSource.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancement);
        if (progress.isDone()) {
            return;
        }
        for (String criterion : progress.getRemainingCriteria()) {
            player.getAdvancements().award(advancement, criterion);
        }
    }
}

