/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class WanderAroundOnSurfaceGoal
extends Goal {
    private final PathfinderMob mob;
    private double x;
    private double y;
    private double z;
    private final double speed;
    private final Level world;

    public WanderAroundOnSurfaceGoal(PathfinderMob mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.world = mob.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        boolean isDay = this.world.isBrightOutside();
        if (!isDay) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        Vec3 vec3d = this.getWanderTarget();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.x;
        this.y = vec3d.y;
        this.z = vec3d.z;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.x, this.y, this.z, this.speed);
    }

    @Nullable
    private Vec3 getWanderTarget() {
        RandomSource random = this.mob.getRandom();
        BlockPos blockPos = this.mob.blockPosition();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockPos2 = blockPos.offset(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
            if (!this.world.getBlockState(blockPos2).is(Blocks.WATER)) continue;
            return Vec3.atBottomCenterOf((Vec3i)blockPos2);
        }
        return null;
    }
}

