/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.init;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.config.VariantsAndVenturesConfig;
import com.faboslav.variantsandventures.common.mixin.JigsawStructureAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.Random;
import net.minecraft.world.level.levelgen.structure.pools.alias.RandomGroup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public final class VariantsAndVenturesStructurePoolAliases {
    public static void init(MinecraftServer server) {
        VariantsAndVenturesStructurePoolAliases.updateTrialChamberSpawners(server);
    }

    private static void updateTrialChamberSpawners(MinecraftServer server) {
        VariantsAndVenturesConfig config = VariantsAndVentures.getConfig();
        Registry structureRegistry = server.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        JigsawStructure structure = (JigsawStructure)structureRegistry.getValue(VariantsAndVentures.makeNamespacedId("minecraft:trial_chambers"));
        JigsawStructureAccessor structureAccessor = (JigsawStructureAccessor)structure;
        List<PoolAliasBinding> originalPoolAliasBindings = structureAccessor.getPoolAliasBindings();
        ArrayList<PoolAliasBinding> newPoolAliasBindings = new ArrayList<PoolAliasBinding>();
        for (PoolAliasBinding originalPoolAliasBinding : originalPoolAliasBindings) {
            if (originalPoolAliasBinding instanceof RandomGroup) {
                RandomGroup randomGroupStructurePoolAliasBinding = (RandomGroup)originalPoolAliasBinding;
                SimpleWeightedRandomList.Builder dataPoolBuilder = SimpleWeightedRandomList.builder();
                List groups = randomGroupStructurePoolAliasBinding.groups().unwrap();
                for (WeightedEntry.Wrapper group : groups) {
                    dataPoolBuilder.add((Object)((List)group.data()));
                }
                if (config.enableMurkSpawnersInTrialChambers) {
                    dataPoolBuilder.add(List.of(PoolAliasBinding.direct((String)"trial_chambers/spawner/contents/ranged", (String)"trial_chambers/spawner/ranged/murk"), PoolAliasBinding.direct((String)"trial_chambers/spawner/contents/slow_ranged", (String)"trial_chambers/spawner/slow_ranged/murk")));
                }
                if (config.enableVerdantSpawnersInTrialChambers) {
                    dataPoolBuilder.add(List.of(PoolAliasBinding.direct((String)"trial_chambers/spawner/contents/ranged", (String)"trial_chambers/spawner/ranged/verdant"), PoolAliasBinding.direct((String)"trial_chambers/spawner/contents/slow_ranged", (String)"trial_chambers/spawner/slow_ranged/verdant")));
                }
                RandomGroup newRandomGroupStructurePoolAliasBinding = PoolAliasBinding.randomGroup((SimpleWeightedRandomList)dataPoolBuilder.build());
                newPoolAliasBindings.add((PoolAliasBinding)newRandomGroupStructurePoolAliasBinding);
                continue;
            }
            if (originalPoolAliasBinding instanceof Random) {
                Random newRandomStructurePoolAliasBinding;
                Random randomStructurePoolAliasBinding = (Random)originalPoolAliasBinding;
                String alias = randomStructurePoolAliasBinding.alias().location().getPath();
                List<ResourceKey> registryKeys = randomStructurePoolAliasBinding.allTargets().toList();
                if (Objects.equals(alias, "trial_chambers/spawner/contents/melee")) {
                    SimpleWeightedRandomList.Builder dataPoolBuilder = SimpleWeightedRandomList.builder();
                    registryKeys.forEach(registryKey -> {
                        String value = registryKey.location().getPath();
                        dataPoolBuilder.add((Object)value);
                    });
                    if (config.enableGelidSpawnersInTrialChambers) {
                        dataPoolBuilder.add((Object)"trial_chambers/spawner/melee/gelid");
                    }
                    if (config.enableThicketSpawnersInTrialChambers) {
                        dataPoolBuilder.add((Object)"trial_chambers/spawner/melee/thicket");
                    }
                    newRandomStructurePoolAliasBinding = PoolAliasBinding.random((String)alias, (SimpleWeightedRandomList)dataPoolBuilder.build());
                } else {
                    newRandomStructurePoolAliasBinding = randomStructurePoolAliasBinding;
                }
                newPoolAliasBindings.add((PoolAliasBinding)newRandomStructurePoolAliasBinding);
                continue;
            }
            newPoolAliasBindings.add(originalPoolAliasBinding);
        }
        structureAccessor.setPoolAliasBindings(newPoolAliasBindings);
    }

    private VariantsAndVenturesStructurePoolAliases() {
    }
}

