/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.Events.BlueprintEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.client.VisualizeBlueprintDatas;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingGraphics;
import nimble.portable_blueprints.robautile.RenderingMethods;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderBlueprintsPreview {
    private static final List<Tuple<BlockPos, BlockState>> ListaBlocchiSingleRender = new ArrayList<Tuple<BlockPos, BlockState>>();
    public static boolean prepared = false;
    private static boolean doCleanup = false;
    private static Long TimeAnimation = System.currentTimeMillis();
    private static Vec3i lunghezza = Vec3i.ZERO;
    private static final Map<RenderLevelStageEvent.Stage, List<RenderType>> STAGE_RENDER_TYPES = Map.of(RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS, List.of(RenderType.solid(), RenderType.cutout(), RenderType.cutoutMipped()), RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS, List.of(RenderType.translucent()));
    public static final int MAX_BLOCKS_FOR_Time = 1000;
    private static final Map<RenderType, List<VertexBuffer>> vertexBuffers = new HashMap<RenderType, List<VertexBuffer>>();
    private static final List<Tuple<BlockPos, VertexBuffer>> vertexBuffersLiquids = new ArrayList<Tuple<BlockPos, VertexBuffer>>();
    private static ScheduledExecutorService executor = null;
    private static boolean datiVertexPronti = false;
    private static ItemStack lastBlueprintItem = null;
    private static final Map<RenderType, List<Tuple<BlockPos, BlockState>>> datiBlocchiRender = new HashMap<RenderType, List<Tuple<BlockPos, BlockState>>>();
    private static final List<Tuple<BlockPos, BlockState>> datiRenderLiquid = new ArrayList<Tuple<BlockPos, BlockState>>();
    private static boolean isDatiVertexPronti = false;
    private static Vec3 originPos = Vec3.ZERO;
    private static Vec3 finalOriginPos = Vec3.ZERO;
    private static long moveTimeAnimation = 0L;
    public static Direction DirezioneHitboxSelected = null;
    public static int NblockBlueprint = -1;
    public static int nAvanzamento = 0;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (doCleanup) {
            doCleanup = false;
            RenderBlueprintsPreview.cleanup();
        }
        RenderBlueprintsPreview.renderHologramLoadingBar(event);
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level == null) {
                return;
            }
            if (!prepared) {
                RenderBlueprintsPreview.prepare();
            }
            RenderBlueprintsPreview.preparaVertexBuffers();
        }
        if (Minecraft.getInstance().player != null || event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES || event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            CompoundTag nbt;
            ItemStack item = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
            if (ModItems.getBlueprintItems().contains(item.getItem()) && (nbt = OldVersionUtilities.getItemStackNBT(item)).contains("originPos")) {
                Minecraft mc = Minecraft.getInstance();
                Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
                RenderBlueprintsPreview.render(OldVersionUtilities.getEventPosestack(event), cameraPos, event.getProjectionMatrix(), event.getStage());
            }
        }
    }

    public static void prepare() {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        ItemStack item = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
        if (prepared || VisualizeBlueprintDatas.VisualizeBlueprint == null || !ModItems.getBlueprintItems().contains(item.getItem())) {
            return;
        }
        prepared = true;
        RenderBlueprintsPreview.cleanup();
        lastBlueprintItem = item.copy();
        RenderBlueprintsPreview.preparaDatiPerVertexBuffer();
    }

    public static void preparaDatiPerVertexBuffer() {
        if (Minecraft.getInstance().level == null || lastBlueprintItem == null) {
            return;
        }
        if (executor != null) {
            executor.shutdownNow();
        }
        executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(() -> {
            try {
                PoseStack poseStack = new PoseStack();
                poseStack.pushPose();
                try {
                    Blueprint.BlueprintDatas schem = VisualizeBlueprintDatas.VisualizeBlueprint;
                    CompoundTag nbt = OldVersionUtilities.getItemStackNBT(lastBlueprintItem);
                    Minecraft mc = Minecraft.getInstance();
                    BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
                    datiBlocchiRender.clear();
                    datiRenderLiquid.clear();
                    if (nbt.getShort("rotateValue") != 0) {
                        schem = schem.rotate(nbt.getShort("rotateValue"));
                    }
                    if (nbt.getBoolean("mirrowX") || nbt.getBoolean("mirrowY") || nbt.getBoolean("mirrowZ")) {
                        schem = schem.Mirrow(nbt.getBoolean("mirrowX"), nbt.getBoolean("mirrowY"), nbt.getBoolean("mirrowZ"));
                    }
                    lunghezza = new Vec3i(schem.lunghezzaX, schem.altezza, schem.lunghezzaZ);
                    int n_volte = 0;
                    for (int v = 0; v < 2; ++v) {
                        for (int altezze : v == 0 ? schem.BlocksData.keySet() : schem.NotSolidBlocksData.keySet()) {
                            for (Map.Entry<String, String> bloccoDati : v == 0 ? schem.BlocksData.get(altezze).entrySet() : schem.NotSolidBlocksData.get(altezze).entrySet()) {
                                BlockState bs;
                                BlockPos offsetPos = new BlockPos(Operazioni.getVec3iFromString(bloccoDati.getKey()));
                                String blockstate = bloccoDati.getValue();
                                String bloccoId = blockstate.substring(blockstate.indexOf("<bid>") + 5, blockstate.indexOf("</bid>"));
                                BlockState blockState = bs = (blockstate = blockstate.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equalsIgnoreCase("null") ? Operazioni.getBlockFromString(bloccoId).defaultBlockState() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockstate);
                                if (bs.hasProperty((Property)BlockStateProperties.BED_PART) && ((BedPart)bs.getValue((Property)BlockStateProperties.BED_PART)).equals((Object)BedPart.HEAD)) continue;
                                BakedModel model = dispatcher.getBlockModel(bs);
                                if (RenderBlueprintsPreview.isLiquidBlock(bs)) {
                                    datiRenderLiquid.add((Tuple<BlockPos, BlockState>)new Tuple((Object)offsetPos, (Object)bs));
                                } else {
                                    LegacyRandomSource threadRandom = new LegacyRandomSource(System.currentTimeMillis());
                                    for (RenderType renderType : model.getRenderTypes(bs, (RandomSource)threadRandom, ModelData.EMPTY)) {
                                        if (!datiBlocchiRender.containsKey(renderType)) {
                                            datiBlocchiRender.put(renderType, new ArrayList());
                                        }
                                        datiBlocchiRender.get(renderType).add((Tuple<BlockPos, BlockState>)new Tuple((Object)offsetPos, (Object)bs));
                                    }
                                }
                                if (++n_volte < 1000) continue;
                                Thread.sleep(1L);
                                n_volte = 0;
                            }
                        }
                    }
                    datiVertexPronti = true;
                }
                finally {
                    poseStack.popPose();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public static void preparaVertexBuffers() {
        if (Minecraft.getInstance().level == null || !datiVertexPronti || isDatiVertexPronti || VisualizeBlueprintDatas.originPosVisualizeBlueprint == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = new PoseStack();
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
        try {
            BufferBuilder bufferBuilder;
            for (RenderType renderType : datiBlocchiRender.keySet()) {
                bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                for (Tuple<BlockPos, BlockState> datiBlocco : datiBlocchiRender.get(renderType)) {
                    if (RenderBlueprintsPreview.isBlockEntity((BlockState)datiBlocco.getB())) {
                        if (ListaBlocchiSingleRender.contains(datiBlocco)) continue;
                        ListaBlocchiSingleRender.add(datiBlocco);
                        continue;
                    }
                    poseStack.pushPose();
                    poseStack.translate((float)((BlockPos)datiBlocco.getA()).getX(), (float)((BlockPos)datiBlocco.getA()).getY(), (float)((BlockPos)datiBlocco.getA()).getZ());
                    int color = blockColors.getColor((BlockState)datiBlocco.getB(), (BlockAndTintGetter)mc.level, (BlockPos)datiBlocco.getA(), 0);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    BakedModel model = dispatcher.getBlockModel((BlockState)datiBlocco.getB());
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), (VertexConsumer)bufferBuilder, (BlockState)datiBlocco.getB(), model, r, g, b, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
                    poseStack.popPose();
                }
                MeshData rendered = bufferBuilder.build();
                if (rendered == null) continue;
                VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                vertexBuffer.bind();
                vertexBuffer.upload(rendered);
                if (!vertexBuffers.containsKey(renderType)) {
                    vertexBuffers.put(renderType, new ArrayList());
                }
                vertexBuffers.get(renderType).add(vertexBuffer);
                VertexBuffer.unbind();
            }
            for (Tuple tuple : datiRenderLiquid) {
                bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                BlockPos pos = new BlockPos(((BlockPos)tuple.getA()).getX() & 0xF, ((BlockPos)tuple.getA()).getY(), ((BlockPos)tuple.getA()).getZ() & 0xF);
                dispatcher.renderLiquid(pos, (BlockAndTintGetter)mc.level, (VertexConsumer)bufferBuilder, (BlockState)tuple.getB(), ((BlockState)tuple.getB()).getFluidState());
                MeshData rendered = bufferBuilder.build();
                VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                vertexBuffer.bind();
                vertexBuffer.upload(rendered);
                vertexBuffersLiquids.add((Tuple<BlockPos, VertexBuffer>)new Tuple((Object)((BlockPos)tuple.getA()), (Object)vertexBuffer));
                VertexBuffer.unbind();
            }
            isDatiVertexPronti = true;
            finalOriginPos = originPos = new Vec3((double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getX(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getY(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getZ());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void render(PoseStack poseStack, Vec3 cameraPos, Matrix4f matrix4f, RenderLevelStageEvent.Stage stage) {
        if (!prepared || !isDatiVertexPronti || VisualizeBlueprintDatas.VisualizeBlueprint == null || VisualizeBlueprintDatas.originPosVisualizeBlueprint == null) {
            return;
        }
        Vec3 vOriginPos = new Vec3((double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getX(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getY(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getZ());
        int v = 100000;
        if (!finalOriginPos.equals((Object)vOriginPos)) {
            moveTimeAnimation = System.currentTimeMillis() + (long)v;
            finalOriginPos = vOriginPos;
        }
        float t = 1.0f;
        if (moveTimeAnimation - System.currentTimeMillis() <= (long)v) {
            t = 1.0f - (float)(moveTimeAnimation - System.currentTimeMillis()) / (float)v;
        }
        originPos = Operazioni.lerp(originPos, finalOriginPos, (double)t);
        if (!lunghezza.equals((Object)Vec3i.ZERO) && stage.equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            RenderingGraphics.renderBorderBox(new PoseStack(), matrix4f, originPos, originPos.add((double)(lunghezza.getX() - 1), (double)(lunghezza.getY() - 1), (double)(lunghezza.getZ() - 1)), ModConfig.getBlueprintAreaColor(), 1.0f, false);
        }
        poseStack.pushPose();
        float yAdd = 0.0f;
        if (TimeAnimation >= System.currentTimeMillis()) {
            yAdd = (float)(-VisualizeBlueprintDatas.VisualizeBlueprint.altezza) * ((float)(TimeAnimation - System.currentTimeMillis()) / 2000.0f);
            yAdd *= 2.0f;
        }
        poseStack.translate(RenderBlueprintsPreview.originPos.x - cameraPos.x, RenderBlueprintsPreview.originPos.y + (double)yAdd - cameraPos.y, RenderBlueprintsPreview.originPos.z - cameraPos.z);
        RenderSystem.enableDepthTest();
        for (RenderType renderType : vertexBuffers.keySet()) {
            if (!STAGE_RENDER_TYPES.containsKey(stage) || !STAGE_RENDER_TYPES.get(stage).contains(renderType)) continue;
            for (VertexBuffer vertexBuffer : vertexBuffers.get(renderType)) {
                vertexBuffer.bind();
                if (renderType.equals(RenderType.solid()) || renderType.equals(RenderType.cutout()) || renderType.equals(RenderType.cutoutMipped())) {
                    RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
                } else if (renderType.equals(RenderType.translucent()) || renderType.equals(RenderType.translucentMovingBlock())) {
                    RenderSystem.setShader(GameRenderer::getRendertypeTranslucentShader);
                } else if (renderType.equals(RenderType.tripwire())) {
                    RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
                try {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)BlueprintEvent.HologramTrasparency);
                    vertexBuffer.drawWithShader(poseStack.last().pose(), matrix4f, Objects.requireNonNull(RenderSystem.getShader()));
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
            }
            VertexBuffer.unbind();
        }
        Frustum frustum = Minecraft.getInstance().levelRenderer.getFrustum();
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getRendertypeTranslucentShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            for (Tuple<BlockPos, VertexBuffer> tuple : vertexBuffersLiquids) {
                ((VertexBuffer)tuple.getB()).bind();
                Vec3 blockPos = new Vec3((double)((BlockPos)tuple.getA()).getX(), (double)((BlockPos)tuple.getA()).getY(), (double)((BlockPos)tuple.getA()).getZ()).add((double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getX(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getY(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.getZ());
                AABB blockAABB = new AABB(blockPos, blockPos.add(1.0, 1.0, 1.0));
                if (!frustum.isVisible(blockAABB)) continue;
                try {
                    poseStack.pushPose();
                    BlockPos pos = new BlockPos(((BlockPos)tuple.getA()).getX() & 0xF, ((BlockPos)tuple.getA()).getY() & 0xF, ((BlockPos)tuple.getA()).getZ() & 0xF);
                    poseStack.translate((float)(((BlockPos)tuple.getA()).getX() - pos.getX()), (float)(((BlockPos)tuple.getA()).getY() - pos.getY()), (float)(((BlockPos)tuple.getA()).getZ() - pos.getZ()));
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)BlueprintEvent.HologramTrasparency);
                    ((VertexBuffer)tuple.getB()).drawWithShader(poseStack.last().pose(), matrix4f, Objects.requireNonNull(RenderSystem.getShader()));
                    poseStack.popPose();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VertexBuffer.unbind();
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
        poseStack.popPose();
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            Minecraft minecraft = Minecraft.getInstance();
            BlockRenderDispatcher blockRenderDispatcher = minecraft.getBlockRenderer();
            BlockEntityRenderDispatcher renderBlockEntity = minecraft.getBlockEntityRenderDispatcher();
            for (Tuple<BlockPos, BlockState> datiBlocco : ListaBlocchiSingleRender) {
                Vec3 blockPos = new Vec3((double)((BlockPos)datiBlocco.getA()).getX(), (double)((BlockPos)datiBlocco.getA()).getY(), (double)((BlockPos)datiBlocco.getA()).getZ()).add(RenderBlueprintsPreview.originPos.x, RenderBlueprintsPreview.originPos.y, RenderBlueprintsPreview.originPos.z);
                AABB blockAABB = new AABB(blockPos, blockPos.add(1.0, 1.0, 1.0));
                if (!frustum.isVisible(blockAABB)) continue;
                poseStack.pushPose();
                poseStack.translate(RenderBlueprintsPreview.originPos.x - cameraPos.x, RenderBlueprintsPreview.originPos.y + (double)yAdd - cameraPos.y, RenderBlueprintsPreview.originPos.z - cameraPos.z);
                poseStack.translate((float)((BlockPos)datiBlocco.getA()).getX(), (float)((BlockPos)datiBlocco.getA()).getY(), (float)((BlockPos)datiBlocco.getA()).getZ());
                try {
                    blockRenderDispatcher.renderSingleBlock((BlockState)datiBlocco.getB(), poseStack, (MultiBufferSource)minecraft.renderBuffers().bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, (RenderType)(((BlockState)datiBlocco.getB()).getRenderShape().equals((Object)RenderShape.MODEL) ? RenderType.solid() : null));
                    RenderingMethods.RenderItemInWorld(new PoseStack(), new Vec3((double)((BlockPos)datiBlocco.getA()).getX(), (double)((BlockPos)datiBlocco.getA()).getY(), (double)((BlockPos)datiBlocco.getA()).getZ()), Operazioni.getCorrectItemStackFromId(Blocks.AIR).getItem(), 1.0f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                poseStack.popPose();
            }
        }
        if (DirezioneHitboxSelected != null && stage.equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            RenderBlueprintsPreview.renderingSelectMovingArea(new PoseStack());
        }
    }

    private static void renderingSelectMovingArea(PoseStack poseStack) {
        Vec3 angolo2 = originPos.add((double)lunghezza.getX(), (double)lunghezza.getY(), (double)lunghezza.getZ());
        AABB box = null;
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH)) {
            box = new AABB(originPos, new Vec3(angolo2.x, angolo2.y, RenderBlueprintsPreview.originPos.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            box = new AABB(angolo2, new Vec3(RenderBlueprintsPreview.originPos.x, RenderBlueprintsPreview.originPos.y, angolo2.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            box = new AABB(originPos, new Vec3(RenderBlueprintsPreview.originPos.x, angolo2.y, angolo2.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.EAST)) {
            box = new AABB(angolo2, new Vec3(angolo2.x, RenderBlueprintsPreview.originPos.y, RenderBlueprintsPreview.originPos.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            box = new AABB(originPos, new Vec3(angolo2.x, RenderBlueprintsPreview.originPos.y, angolo2.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.UP)) {
            box = new AABB(angolo2, new Vec3(RenderBlueprintsPreview.originPos.x, angolo2.y, RenderBlueprintsPreview.originPos.z));
        }
        Vec3 colore = ModConfig.getBlueprintAreaColor();
        float r = (float)colore.x;
        float g = (float)colore.y;
        float b = (float)colore.z;
        float a = 0.5f;
        if (box == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        float minX = (float)(box.minX - view.x);
        float maxX = (float)(box.maxX - view.x);
        float minZ = (float)(box.minZ - view.z);
        float maxZ = (float)(box.maxZ - view.z);
        float maxY = (float)(box.maxY - view.y);
        float minY = (float)(box.minY - view.y);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.debugSectionQuads());
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH) || DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            buffer.addVertex(matrix, minX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.EAST) || DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.UP) || DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            buffer.addVertex(matrix, minX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
        }
        bufferSource.endBatch();
    }

    public static boolean isBlockEntity(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            try {
                BlockEntity be = entityBlock.newBlockEntity(BlockPos.ZERO, state);
                if (be == null) {
                    return false;
                }
                BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
                return renderer != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLiquidBlock(BlockState state) {
        if (state.getBlock() instanceof LiquidBlock) {
            return !state.getFluidState().isEmpty();
        }
        return false;
    }

    private static void cleanup() {
        for (RenderType renderType : vertexBuffers.keySet()) {
            for (VertexBuffer vertex : vertexBuffers.get(renderType)) {
                vertex.close();
            }
        }
        vertexBuffers.clear();
        vertexBuffersLiquids.clear();
        ListaBlocchiSingleRender.clear();
        lunghezza = Vec3i.ZERO;
        if (executor != null && !executor.isShutdown()) {
            executor.shutdownNow();
            executor = null;
        }
        lastBlueprintItem = null;
        datiVertexPronti = false;
        isDatiVertexPronti = false;
        originPos = Vec3.ZERO;
        finalOriginPos = Vec3.ZERO;
    }

    public static void CleanAndPrepare() {
        RenderBlueprintsPreview.doCleanUp();
        prepared = false;
    }

    public static void doCleanUp() {
        doCleanup = true;
    }

    public static void renderHologramLoadingBar(RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SKY) || Minecraft.getInstance().player == null) {
            return;
        }
        if (nAvanzamento <= NblockBlueprint) {
            Minecraft.getInstance().player.displayClientMessage(RenderBlueprintsPreview.progresso(), true);
            if (nAvanzamento == NblockBlueprint) {
                NblockBlueprint = -1;
                nAvanzamento = 0;
                prepared = false;
                TimeAnimation = System.currentTimeMillis() + 2000L;
            }
        }
    }

    public static void setNuovoAvanzamentoHologramLoadingBar(int nBlocchi) {
        nAvanzamento = 0;
        NblockBlueprint = nBlocchi;
        RenderBlueprintsPreview.cleanup();
    }

    public static void aggiungiAvanzamento() {
        ++nAvanzamento;
    }

    private static Component progresso() {
        int barrePiene = (int)((float)nAvanzamento / (float)NblockBlueprint * 15.0f);
        int barreVuote = 15 - barrePiene;
        if (barrePiene < 0) {
            barrePiene = 0;
        }
        if (barreVuote < 0) {
            barreVuote = 0;
        }
        return Component.literal((String)"\u2b1b".repeat(barrePiene)).withStyle(ChatFormatting.DARK_BLUE).append((Component)Component.literal((String)"\u2b1b".repeat(barreVuote)).withStyle(ChatFormatting.BLACK));
    }
}

