/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingGraphics;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderScannerAnimation {
    private static Map<UUID, AnimazioneScanningDatas> animazioneScanningDatas = new HashMap<UUID, AnimazioneScanningDatas>();

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID id : animazioneScanningDatas.keySet()) {
            AnimazioneScanningDatas animazioneScanningData = animazioneScanningDatas.get(id);
            animazioneScanningData.render(event);
            if (!animazioneScanningData.canRemove) continue;
            toRemove.add(id);
        }
        for (UUID id : toRemove) {
            animazioneScanningDatas.remove(id);
        }
    }

    public static void resetAll() {
        animazioneScanningDatas.clear();
    }

    public static void addAnimation(UUID idAnimazione, BlockPos angolo1, BlockPos angolo2) {
        animazioneScanningDatas.put(idAnimazione, new AnimazioneScanningDatas(angolo1, angolo2));
    }

    public static void removeAnimazione(UUID idAnimazione) {
        if (animazioneScanningDatas.containsKey(idAnimazione)) {
            animazioneScanningDatas.get(idAnimazione).stop();
        }
    }

    public static void addProgress(UUID animationID) {
        if (animazioneScanningDatas.containsKey(animationID)) {
            animazioneScanningDatas.get(animationID).addProgresso();
        }
    }

    private static class AnimazioneScanningDatas {
        private static final int TempoOscillazione = 1000;
        private final BlockPos angolo1;
        private final BlockPos angolo2;
        private long startTime;
        private boolean canStartOscillatingScanArea = false;
        private long startOscillatingTime = System.currentTimeMillis();
        private boolean oscillatingDirection = false;
        private final Vec3 minAngolo;
        private final Vec3 maxAngolo;
        private boolean isStopped = false;
        public boolean canRemove = false;
        private boolean usedOnce = false;
        private double altezzaLast = 0.0;
        private int progresso = 0;
        private int maxProgresso;

        public AnimazioneScanningDatas(BlockPos angolo1, BlockPos angolo2) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.startTime = System.currentTimeMillis();
            int minX = Math.min(angolo1.getX(), angolo2.getX());
            int maxX = Math.max(angolo1.getX(), angolo2.getX()) + 1;
            int minZ = Math.min(angolo1.getZ(), angolo2.getZ());
            int maxZ = Math.max(angolo1.getZ(), angolo2.getZ()) + 1;
            int maxY = Math.max(angolo1.getY(), angolo2.getY()) + 1;
            int minY = Math.min(angolo1.getY(), angolo2.getY());
            this.minAngolo = new Vec3((double)minX, (double)minY, (double)minZ);
            this.maxAngolo = new Vec3((double)maxX, (double)maxY, (double)maxZ);
            this.maxProgresso = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
            this.altezzaLast = this.minAngolo.y + (double)0.05f;
        }

        public void addProgresso() {
            ++this.progresso;
            if (this.progresso >= this.maxProgresso) {
                this.stop();
            }
        }

        public void render(RenderLevelStageEvent event) {
            this.renderScanningArea();
        }

        private void renderScanningArea() {
            PoseStack poseStack = new PoseStack();
            poseStack.pushPose();
            Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            poseStack.translate(-view.x, -view.y, -view.z);
            float minX = (float)this.minAngolo.x;
            float minY = (float)this.minAngolo.y;
            float minZ = (float)this.minAngolo.z;
            float maxX = (float)this.maxAngolo.x;
            float maxY = (float)this.maxAngolo.y;
            float maxZ = (float)this.maxAngolo.z;
            double alphaV = (float)(System.currentTimeMillis() - this.startTime) / 250.0f;
            if (alphaV > 1.0) {
                alphaV = 1.0;
            } else if (alphaV < 0.0) {
                alphaV = 0.0;
            }
            alphaV = !this.isStopped ? alphaV : 1.0 - alphaV;
            float alphaInside = (float)Operazioni.lerp(0.0, 0.5, alphaV);
            float alphaOutside = (float)Operazioni.lerp(0.0, 1.0, alphaV);
            if (this.isStopped && alphaV <= 0.0) {
                this.canRemove = true;
            }
            double Targetaltezza = this.minAngolo.y + (double)0.05f;
            if (alphaV >= 1.0 || this.isStopped) {
                Targetaltezza = (double)((float)this.progresso / (float)this.maxProgresso) * (this.maxAngolo.y - (double)0.05f - (this.minAngolo.y + (double)0.05f)) + this.minAngolo.y;
            }
            float altezza = (float)Operazioni.lerp(this.altezzaLast, Targetaltezza, (double)0.05f);
            this.altezzaLast = altezza;
            float lunghezzaX = (float)(this.maxAngolo.x - this.minAngolo.x);
            float lunghezzaZ = (float)(this.maxAngolo.z - this.minAngolo.z);
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.debugSectionQuads());
            Matrix4f matrix4f = poseStack.last().pose();
            Vec3 color = ModConfig.getScannerAreaColor();
            buffer.addVertex(matrix4f, minX, altezza, minZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            buffer.addVertex(matrix4f, maxX, altezza, minZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            buffer.addVertex(matrix4f, maxX, altezza, maxZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            buffer.addVertex(matrix4f, minX, altezza, maxZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            buffer.addVertex(matrix4f, minX, altezza, maxZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            buffer.addVertex(matrix4f, maxX, altezza, maxZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            buffer.addVertex(matrix4f, maxX, altezza, minZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            buffer.addVertex(matrix4f, minX, altezza, minZ).setColor((float)color.x, (float)color.y, (float)color.z, alphaInside);
            float scale = 0.25f;
            float meta = scale / 2.0f;
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, matrix4f, new Vec3((double)(minX - meta), (double)altezza, (double)(minZ - scale)).toVector3f(), lunghezzaZ + scale, scale, Direction.SOUTH, color.scale(0.8), alphaOutside);
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, matrix4f, new Vec3((double)(maxX + meta), (double)altezza, (double)(maxZ + scale)).toVector3f(), lunghezzaZ + scale, scale, Direction.NORTH, color.scale(0.8), alphaOutside);
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, matrix4f, new Vec3((double)(minX - scale), (double)altezza, (double)(maxZ + meta)).toVector3f(), lunghezzaX + scale, scale, Direction.EAST, color.scale(0.8), alphaOutside);
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, matrix4f, new Vec3((double)(maxX + scale), (double)altezza, (double)(minZ - meta)).toVector3f(), lunghezzaX + scale, scale, Direction.WEST, color.scale(0.8), alphaOutside);
            bufferSource.endBatch(RenderType.debugSectionQuads());
            poseStack.popPose();
            if (alphaV >= 1.0) {
                this.renderParticles(altezza);
            }
        }

        private void renderParticles(double altezza) {
            if (System.currentTimeMillis() % 5L != 0L) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            double randomX = this.minAngolo.x + (this.maxAngolo.x - this.minAngolo.x) * Math.random();
            double randomZ = this.minAngolo.z + (this.maxAngolo.z - this.minAngolo.z) * Math.random();
            altezza = altezza + 2.0 * Math.random() - 1.0;
            if (player.blockPosition().distManhattan(new Vec3i((int)randomX, (int)altezza, (int)randomZ)) > 30) {
                return;
            }
            Vec3 color = ModConfig.getScannerAreaColor();
            player.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.x, (float)color.y, (float)color.z), 1.5f), randomX, altezza, randomZ, 0.0, 0.0, 0.0);
        }

        public void stop() {
            if (!this.isStopped) {
                this.isStopped = true;
                this.startTime = System.currentTimeMillis();
            }
        }
    }
}

