/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.client.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import nimble.portable_blueprints.Events.RenderBlueprintsPreview;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.client.VisualizeBlueprintDatas;
import nimble.portable_blueprints.items.Blueprint;
import nimble.portable_blueprints.network.CtoS_CreateStructureByBlueprint;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.server_blacklist_blocks.CtoS_ServerBlacklistBlocks;
import nimble.portable_blueprints.network.update_item_blueprint_nbt.CtoS_UpdateItemBlueprintNBT;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.AdvancedButton;
import nimble.portable_blueprints.robautile.AdvancedScrolling;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingMethods;
import nimble.portable_blueprints.robautile.ScrollingText;
import org.joml.Vector2i;

public class BlueprintScreen
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"textures/gui/blueprint_gui.png");
    private int CentroX;
    private int CentroY;
    private int W;
    private int H;
    private AdvancedScrolling scrolling;
    private int ScrollingValue = 0;
    boolean FirstLoad = true;
    private RenderingMethods.GuiGraphicsElement Titolo;
    private AdvancedButton B_Reload;
    private AdvancedButton B_ROTATE_LEFT;
    private AdvancedButton B_ROTATE_RIGHT;
    private AdvancedButton B_ROTATE_RESET;
    private AdvancedButton B_MIRROW_X;
    private AdvancedButton B_MIRROW_Y;
    private AdvancedButton B_MIRROW_Z;
    private AdvancedButton B_SKIP_OBSTRUCTION_BLOCK;
    private AdvancedButton B_BUILD_ANYWAY;
    private int ultimaGrandezza = 0;
    private Blueprint.BlueprintDatas BD = null;
    public Map<Item, Integer> ItemQuantity = new HashMap<Item, Integer>();
    private List<BlockPos> posContainer = new ArrayList<BlockPos>();
    private ItemStack blueprintItem = null;
    private AdvancedButton B_BUILD;
    private boolean hasOrigin = false;
    private int posYLista = 0;
    private int posYMaxLista = 0;
    private List<ItemRequestWidget> itemRequestWidgets = new ArrayList<ItemRequestWidget>();
    short tickCount = 1;

    protected BlueprintScreen(Component component) {
        super(component);
    }

    public BlueprintScreen(ItemStack blueprintItem, List<BlockPos> posContainer) {
        super((Component)Component.empty());
        this.blueprintItem = blueprintItem;
        this.posContainer = posContainer;
        PacketHandler.sendToServer(new CtoS_ServerBlacklistBlocks(UUID.randomUUID()));
        this.hasOrigin = OldVersionUtilities.getItemStackNBT(blueprintItem).contains("originPos");
    }

    protected void init() {
        super.init();
        this.W = this.width;
        this.H = this.height;
        this.CentroX = this.W / 2;
        this.CentroY = this.H / 2;
        this.scrolling = new AdvancedScrolling(this.CentroX + 55, this.CentroY, 12, 15, new AdvancedScrolling.Image(TEXTURE, 0, 0, 232, 0, 12, 15), new AdvancedScrolling.Image(TEXTURE, 0, 0, 244, 0, 12, 15), this.CentroY - 60, this.CentroY + 45);
        this.addRenderableWidget((GuiEventListener)this.scrolling);
        this.Titolo = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.TESTO_Parametri(this.CentroX - 81, this.CentroY - 68, "", 1.0f, Minecraft.getInstance().font, 0, false, RenderingMethods.PosizioneTesto.SINISTRA, true));
        int px = this.CentroX - 80;
        int py = this.CentroY + 62;
        this.B_Reload = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.Reload()).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 241, 15, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 241, 30, 15, 15)).pressedImageTick(new AdvancedButton.Image(TEXTURE, px, py, 241, 45, 15, 15), 60).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_reload"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_Reload);
        px = this.CentroX + 4;
        py = this.CentroY + 62;
        this.B_ROTATE_RIGHT = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.RotateStructure(true, false)).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 0, 211, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 0, 226, 15, 15)).pressedImageTick(new AdvancedButton.Image(TEXTURE, px, py, 0, 241, 15, 15), 60).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_rotate_right"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_ROTATE_RIGHT);
        px = this.CentroX - 12;
        py = this.CentroY + 62;
        this.B_ROTATE_RESET = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.RotateStructure(false, true)).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 30, 211, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 30, 226, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_rotate_reset"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_ROTATE_RESET);
        px = this.CentroX - 28;
        py = this.CentroY + 62;
        this.B_ROTATE_LEFT = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.RotateStructure(false, false)).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 15, 211, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 15, 226, 15, 15)).pressedImageTick(new AdvancedButton.Image(TEXTURE, px, py, 15, 241, 15, 15), 60).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_rotate_left"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_ROTATE_LEFT);
        px = this.CentroX + 20;
        py = this.CentroY + 62;
        this.B_MIRROW_X = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.mirrowStructure((short)0)).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 45, 211, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 45, 226, 15, 15)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, px, py, 45, 241, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_mirrow_x"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_MIRROW_X);
        px = this.CentroX + 36;
        py = this.CentroY + 62;
        this.B_MIRROW_Y = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.mirrowStructure((short)1)).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 60, 211, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 60, 226, 15, 15)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, px, py, 60, 241, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_mirrow_y"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_MIRROW_Y);
        px = this.CentroX + 52;
        py = this.CentroY + 62;
        this.B_MIRROW_Z = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.mirrowStructure((short)2)).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 75, 211, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 75, 226, 15, 15)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, px, py, 75, 241, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_mirrow_z"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_MIRROW_Z);
        px = this.CentroX - 44;
        py = this.CentroY + 62;
        this.B_SKIP_OBSTRUCTION_BLOCK = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.skipObstructionBlock()).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 90, 211, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 90, 226, 15, 15)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, px, py, 90, 241, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_skip_obstruction_block"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_SKIP_OBSTRUCTION_BLOCK);
        px = this.CentroX - 60;
        py = this.CentroY + 62;
        this.B_BUILD_ANYWAY = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.buildAnyway()).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 105, 226, 15, 15)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, px, py, 105, 211, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_build_anyway"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_BUILD_ANYWAY);
        px = this.CentroX - 99;
        py = this.CentroY + 62;
        this.B_BUILD = AdvancedButton.builder((Component)Component.literal((String)""), pAdvanceButton -> this.build()).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 0, 0, 0, 0)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 222, 241, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.blueprint.button_build"))).build();
        if (this.hasOrigin) {
            this.addRenderableWidget((GuiEventListener)this.B_BUILD);
        }
        this.richiediItemQuantityContainer();
        this.updateList();
    }

    private void build() {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(this.blueprintItem);
        if (nbt.contains("originPos") && (Blueprint.condiviso_con_player(nbt) || !nbt.getString("owner").equals("server") && !nbt.getString("owner").equals("worn") && !nbt.getString("owner").equals("") && UUID.fromString(nbt.getString("owner")).equals(Minecraft.getInstance().player.getUUID()))) {
            if (nbt.getString("owner").equals("server")) {
                PacketHandler.sendToServer(new CtoS_CreateStructureByBlueprint(this.blueprintItem, true, false, new BlockPos(Operazioni.getVec3iFromString(nbt.getString("originPos")))));
            } else if (nbt.getString("owner").equals("worn")) {
                PacketHandler.sendToServer(new CtoS_CreateStructureByBlueprint(this.blueprintItem, false, true, new BlockPos(Operazioni.getVec3iFromString(nbt.getString("originPos")))));
            } else if (!nbt.getString("owner").equals("")) {
                PacketHandler.sendToServer(new CtoS_CreateStructureByBlueprint(this.blueprintItem, false, false, new BlockPos(Operazioni.getVec3iFromString(nbt.getString("originPos")))));
            }
            nbt.putBoolean("visualizeBuild", false);
            nbt.remove("originPos");
            OldVersionUtilities.impostaItemStackNBT(this.blueprintItem, nbt);
            Minecraft.getInstance().setScreen(null);
        }
    }

    private void buildAnyway() {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(this.blueprintItem);
        if (nbt.contains("buildAnyway")) {
            PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "buildAnyway", !nbt.getBoolean("buildAnyway")));
            nbt.putBoolean("buildAnyway", !nbt.getBoolean("buildAnyway"));
            OldVersionUtilities.impostaItemStackNBT(this.blueprintItem, nbt);
        } else {
            PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "buildAnyway", true));
        }
    }

    private void skipObstructionBlock() {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(this.blueprintItem);
        if (nbt.contains("skipObstructionBlock")) {
            PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "skipObstructionBlock", !nbt.getBoolean("skipObstructionBlock")));
            nbt.putBoolean("skipObstructionBlock", !nbt.getBoolean("skipObstructionBlock"));
            OldVersionUtilities.impostaItemStackNBT(this.blueprintItem, nbt);
        } else {
            PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "skipObstructionBlock", true));
        }
    }

    private void RotateStructure(boolean right, boolean reset) {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(this.blueprintItem);
        if (nbt.contains("rotateValue")) {
            short val = nbt.getShort("rotateValue");
            if (reset) {
                val = 0;
            } else if (right) {
                if ((val = (short)(val + 1)) > 3) {
                    val = 0;
                }
            } else if ((val = (short)(val - 1)) < 0) {
                val = 3;
            }
            PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "rotateValue", val));
            nbt.putShort("rotateValue", val);
            OldVersionUtilities.impostaItemStackNBT(this.blueprintItem, nbt);
        }
        RenderBlueprintsPreview.CleanAndPrepare();
    }

    private void mirrowStructure(short xMir) {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(this.blueprintItem);
        switch (xMir) {
            case 0: {
                PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "mirrowX", !nbt.getBoolean("mirrowX")));
                nbt.putBoolean("mirrowX", !nbt.getBoolean("mirrowX"));
                break;
            }
            case 1: {
                PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "mirrowY", !nbt.getBoolean("mirrowY")));
                nbt.putBoolean("mirrowY", !nbt.getBoolean("mirrowY"));
                break;
            }
            case 2: {
                PacketHandler.sendToServer(new CtoS_UpdateItemBlueprintNBT(this.blueprintItem, "mirrowZ", !nbt.getBoolean("mirrowZ")));
                nbt.putBoolean("mirrowZ", !nbt.getBoolean("mirrowZ"));
            }
        }
        OldVersionUtilities.impostaItemStackNBT(this.blueprintItem, nbt);
        RenderBlueprintsPreview.CleanAndPrepare();
    }

    private void Reload() {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(this.blueprintItem);
        if (nbt.getString("owner").equals("server")) {
            System.out.println("server");
            VisualizeBlueprintDatas.newVisualizeBlueprint(true, nbt.getString("nome"), nbt.getInt("altezza"), nbt.getInt("lunghezzaX"), nbt.getInt("lunghezzaZ"), false);
        } else if (nbt.getString("owner").equals("worn")) {
            System.out.println("worn");
            VisualizeBlueprintDatas.newVisualizeBlueprint(false, true, nbt.getString("nome"), nbt.getInt("altezza"), nbt.getInt("lunghezzaX"), nbt.getInt("lunghezzaZ"), false);
        } else if (!nbt.getString("owner").equals("")) {
            System.out.println(nbt.getString("owner"));
            VisualizeBlueprintDatas.newVisualizeBlueprint(UUID.fromString(nbt.getString("owner")), nbt.getString("nome"), nbt.getInt("altezza"), nbt.getInt("lunghezzaX"), nbt.getInt("lunghezzaZ"), false);
        }
        ArrayList<ItemRequestWidget> toRemove = new ArrayList<ItemRequestWidget>();
        for (int x = 0; x < this.itemRequestWidgets.size(); ++x) {
            if (this.itemRequestWidgets.get(x) != null) {
                this.itemRequestWidgets.get(x).remove();
            }
            toRemove.add(this.itemRequestWidgets.get(x));
        }
        for (ItemRequestWidget r : toRemove) {
            this.itemRequestWidgets.remove(r);
        }
        this.BD = null;
        this.richiediItemQuantityContainer();
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (!(VisualizeBlueprintDatas.VisualizeBlueprint == null || this.BD != null && this.BD.getAllBlocksCount() == this.ultimaGrandezza && ClientMethods.ServerBlackListBlocksCompleta)) {
            this.BD = VisualizeBlueprintDatas.VisualizeBlueprint;
            this.Titolo.testoParametri.setTesto(this.BD.nome);
            this.ultimaGrandezza = this.BD.getAllBlocksCount();
            this.ItemQuantity.clear();
            for (int v = 0; v < 2; ++v) {
                for (Integer altezza : v == 0 ? this.BD.BlocksData.keySet() : this.BD.NotSolidBlocksData.keySet()) {
                    for (Map.Entry<String, String> dati_blocco : v == 0 ? this.BD.BlocksData.get(altezza).entrySet() : this.BD.NotSolidBlocksData.get(altezza).entrySet()) {
                        ItemStack itemStack;
                        BlockState state;
                        String blockdata = dati_blocco.getValue();
                        String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
                        BlockState blockState = state = (blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equals("null") ? Operazioni.getBlockFromString(bloccoId).defaultBlockState() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockdata);
                        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && ((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER) || state.hasProperty((Property)BlockStateProperties.BED_PART) && ((BedPart)state.getValue((Property)BlockStateProperties.BED_PART)).equals((Object)BedPart.HEAD) || (itemStack = Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId))).is(Items.AIR)) continue;
                        if (this.ItemQuantity.containsKey(itemStack.getItem())) {
                            this.ItemQuantity.replace(itemStack.getItem(), this.ItemQuantity.get(itemStack.getItem()) + 1);
                            continue;
                        }
                        this.ItemQuantity.put(itemStack.getItem(), 1);
                    }
                }
            }
            this.updateList();
        }
        this.posYLista = (int)((double)this.posYMaxLista * this.scrolling.getValue());
        if (this.blueprintItem != null) {
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(this.blueprintItem);
            if (this.B_MIRROW_X != null) {
                boolean bl = this.B_MIRROW_X.PressedImageCondition = nbt.contains("mirrowX") ? nbt.getBoolean("mirrowX") : false;
            }
            if (this.B_MIRROW_Y != null) {
                boolean bl = this.B_MIRROW_Y.PressedImageCondition = nbt.contains("mirrowY") ? nbt.getBoolean("mirrowY") : false;
            }
            if (this.B_MIRROW_Z != null) {
                boolean bl = this.B_MIRROW_Z.PressedImageCondition = nbt.contains("mirrowZ") ? nbt.getBoolean("mirrowZ") : false;
            }
            if (this.B_SKIP_OBSTRUCTION_BLOCK != null) {
                boolean bl = this.B_SKIP_OBSTRUCTION_BLOCK.PressedImageCondition = nbt.contains("skipObstructionBlock") ? nbt.getBoolean("skipObstructionBlock") : false;
            }
            if (this.B_BUILD_ANYWAY != null) {
                this.B_BUILD_ANYWAY.PressedImageCondition = nbt.contains("buildAnyway") ? nbt.getBoolean("buildAnyway") : false;
            }
        }
        gg.blit(TEXTURE, this.CentroX - 87, this.CentroY - 80, 0, 0, 176, 161);
        if (this.hasOrigin) {
            gg.blit(TEXTURE, this.CentroX - 103, this.CentroY + 58, 237, 233, 19, 23);
        }
        super.render(gg, mouseX, mouseY, delta);
        if (this.BD != null) {
            this.Titolo.render(gg);
        }
        Map<Item, Integer> itemQuantityFromInventory = ClientMethods.ItemDentroInventari;
        RenderingMethods.enableScissorFromGui(Minecraft.getInstance(), this.CentroX - 80, this.CentroY - 60, 128, 120);
        for (ItemRequestWidget bw : this.itemRequestWidgets) {
            if (bw == null) continue;
            bw.render(gg);
            if (itemQuantityFromInventory.containsKey(bw.item)) {
                bw.setQuantitaInInventory(itemQuantityFromInventory.get(bw.item));
                continue;
            }
            bw.setQuantitaInInventory(0);
        }
        RenderingMethods.disableScissor();
        if (this.FirstLoad) {
            this.FirstLoad = false;
            this.updateList();
        }
    }

    private void updateList() {
        for (int x = 0; x < this.itemRequestWidgets.size(); ++x) {
            if (this.itemRequestWidgets.get(x) == null) continue;
            this.itemRequestWidgets.get(x).remove();
        }
        this.itemRequestWidgets.clear();
        int count = 0;
        for (Item key : this.ItemQuantity.keySet()) {
            ItemRequestWidget irw = new ItemRequestWidget(this.CentroX - 80, this.CentroY - 60 + 20 * count, key);
            irw.setItemNeeded(this.ItemQuantity.get(key));
            this.itemRequestWidgets.add(irw);
            ++count;
        }
        this.posYMaxLista = (this.itemRequestWidgets.size() - 6) * 20;
        if (this.posYMaxLista < 0) {
            this.posYMaxLista = 0;
        }
    }

    public void richiediItemQuantityContainer() {
        ClientMethods.mandaRichiestaItemQuantityContainer(this.posContainer);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrolling != null) {
            this.scrolling._mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrolling != null) {
            this.scrolling._mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double v) {
        if (this.scrolling != null) {
            this.scrolling._mouseScrolled(mouseX, mouseY, delta, v);
        }
        return super.mouseScrolled(mouseX, mouseY, delta, v);
    }

    public void onClose() {
        for (ItemRequestWidget irw : this.itemRequestWidgets) {
            if (irw == null) continue;
            irw.remove();
        }
        super.onClose();
    }

    public void tick() {
        this.tickCount = (short)(this.tickCount + 1);
        if (this.tickCount > 20) {
            this.tickCount = 1;
        }
        super.tick();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(float p_336041_) {
    }

    public class ItemRequestWidget {
        public Item item;
        public int ItemNeeded = 0;
        public ScrollingText NomeScrolling;
        public ScrollingText QuantityScrolling;
        public RenderingMethods.GuiGraphicsElement Nome;
        public RenderingMethods.GuiGraphicsElement QuantityNeeded;
        public RenderingMethods.GuiGraphicsElement Sfondo;
        public int x;
        public int y;
        public boolean isRunning = true;
        public boolean completato = false;
        public int QuantitaInInventory = 0;
        public boolean blacklistItem = false;

        public ItemRequestWidget(int _x, int _y, Item item) {
            this.x = _x;
            this.y = _y;
            this.item = item;
            String id = BuiltInRegistries.ITEM.getKey((Object)item).toString();
            Object name = new ItemStack((ItemLike)item).getHoverName().getString();
            if (ClientMethods.ServerBlackListBlocks.contains(id)) {
                name = (String)name + Component.translatable((String)"gui.portable_blueprints.blueprint.blacklist_block").getString();
                this.blacklistItem = true;
            }
            this.NomeScrolling = new ScrollingText((String)name, 18);
            this.QuantityScrolling = new ScrollingText("", 18);
            this.Nome = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.TESTO_Parametri(this.x + 22, this.y + 6, this.NomeScrolling.TestoVisualizzabile, 1.0f, Minecraft.getInstance().font, 0xFFFFFF, true, RenderingMethods.PosizioneTesto.SINISTRA, true));
            this.QuantityNeeded = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.TESTO_Parametri(this.x + 22, this.y + 15, String.valueOf(this.ItemNeeded), 1.0f, Minecraft.getInstance().font, 0xFFFFFF, true, RenderingMethods.PosizioneTesto.SINISTRA, true));
            this.Sfondo = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.BLIT_Parametri(this.x, this.y, 0, 161, 143, 25, TEXTURE));
            Thread tickerThread = new Thread(() -> {
                int tickCount = 1;
                try {
                    while (this.isRunning) {
                        this.tick(tickCount);
                        tickCount = (short)(tickCount + 1);
                        if (tickCount > 20) {
                            tickCount = 1;
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            tickerThread.setDaemon(true);
            tickerThread.start();
        }

        public void render(GuiGraphics gg) {
            gg.pose().pushPose();
            gg.pose().translate(0.0f, (float)(-BlueprintScreen.this.posYLista), 0.0f);
            this.Nome.testoParametri.setTesto((String)(this.blacklistItem ? this.NomeScrolling.TestoVisualizzabile : (this.completato ? "\u00a7m" + this.NomeScrolling.TestoVisualizzabile : this.NomeScrolling.TestoVisualizzabile)));
            this.Nome.testoParametri.color = this.blacklistItem ? 0xFF0000 : (this.completato ? 65280 : 0xFFFFFF);
            this.Nome.render(gg);
            String QNT = this.getStringItemNeeded();
            if (!this.QuantityScrolling.TestoVisualizzabile.equals(QNT)) {
                this.QuantityScrolling.changeText(QNT);
            }
            this.QuantityNeeded.testoParametri.setTesto(this.QuantityScrolling.TestoVisualizzabile);
            this.QuantityNeeded.render(gg);
            this.Sfondo.render(gg);
            RenderingMethods.RenderItemInGui(gg, new Vector2i(this.x + 2, this.y + 2), Vec2.ZERO, 1.0f, new ItemStack((ItemLike)this.item));
            gg.pose().popPose();
        }

        public void setItemNeeded(int quantity) {
            this.ItemNeeded = quantity;
        }

        private String getStringItemNeeded() {
            Object v = "";
            int itemAttuali = this.ItemNeeded - this.QuantitaInInventory;
            this.completato = itemAttuali <= 0;
            int maxStack = new ItemStack((ItemLike)this.item).getMaxStackSize();
            int quantitaMaxStack = (int)Math.floor(itemAttuali / maxStack);
            int restanti = itemAttuali - quantitaMaxStack * maxStack;
            if (restanti < 0) {
                restanti = 0;
            }
            if (quantitaMaxStack > 0) {
                v = (String)v + maxStack + "x" + quantitaMaxStack;
                if (restanti > 0) {
                    v = (String)v + " + " + restanti;
                }
            } else {
                v = (String)v + itemAttuali;
            }
            return this.completato ? "" : v;
        }

        private void tick(int TickCount) {
            if (TickCount % 5 == 0 && this.NomeScrolling != null) {
                this.NomeScrolling.update();
                this.QuantityScrolling.update();
            }
        }

        public void remove() {
            this.isRunning = false;
        }

        public void setQuantitaInInventory(int x) {
            this.QuantitaInInventory = x;
        }
    }
}

