/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.items;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.DistExecutor;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.client.VisualizeBlueprintDatas;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.network.CtoS_RemoveItemIfBlueprintNotExist;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.ServerBlueprints.CtoS_ServerBlueprintsData;
import nimble.portable_blueprints.network.ottieni_shared_blueprint_data.CtoS_SharedBlueprintData;
import nimble.portable_blueprints.portable_blueprints.MOD;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;

public class Blueprint
extends Item {
    private int Tick = 0;

    public Blueprint(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!(pEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pEntity;
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(pStack);
        if (pLevel.isClientSide && pEntity instanceof LocalPlayer) {
            boolean isCurrentlyHolding;
            LocalPlayer Lplayer = (LocalPlayer)pEntity;
            ItemStack mainHand = Lplayer.getMainHandItem();
            if (ItemStack.matches((ItemStack)pStack, (ItemStack)mainHand) && (nbt.getString("owner").equals(Lplayer.getUUID().toString()) || Blueprint.condiviso_con_player(nbt))) {
                nbt.putBoolean("visualizeBuild", true);
                if (nbt.contains("originPos") && nbt.contains("nome")) {
                    VisualizeBlueprintDatas.originPosVisualizeBlueprint = new BlockPos(Operazioni.getVec3iFromString(nbt.getString("originPos")));
                }
            } else {
                nbt.putBoolean("visualizeBuild", false);
            }
            boolean bl = isCurrentlyHolding = player.getMainHandItem() == pStack;
            if (isCurrentlyHolding && !nbt.getBoolean("wasHolding")) {
                nbt.putBoolean("wasHolding", true);
                this.onItemEquipped(player, nbt, pStack);
            } else if (!isCurrentlyHolding && nbt.getBoolean("wasHolding")) {
                nbt.putBoolean("wasHolding", false);
                this.onItemUnequipped(player, nbt);
            }
            OldVersionUtilities.impostaItemStackNBT(pStack, nbt);
        } else if (!pLevel.isClientSide && nbt.contains("inventari_blocco_selezionati")) {
            ArrayList<String> daRimuovere = new ArrayList<String>();
            for (String pos : nbt.getString("inventari_blocco_selezionati").split("!;!")) {
                BlockPos p;
                if (pos.equals("") || pLevel.getBlockEntity(p = new BlockPos(Operazioni.getVec3iFromString(pos))) != null && pLevel.getBlockEntity(p).getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && MOD.isModContainerConsentito(pLevel.getBlockEntity(p))) continue;
                daRimuovere.add(pos);
            }
            for (String dr : daRimuovere) {
                this.rimuoviBloccoInventario(nbt, dr);
            }
            OldVersionUtilities.impostaItemStackNBT(pStack, nbt);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide() && context.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
            Level level = context.getLevel();
            BlockPos positionClicked = context.getClickedPos();
            BlockState state = level.getBlockState(positionClicked);
            Player pl = context.getPlayer();
            ItemStack itemStack = context.getItemInHand();
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(itemStack);
            if (level.getBlockEntity(positionClicked) != null && level.getBlockEntity(positionClicked).getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && MOD.isModContainerConsentito(level.getBlockEntity(positionClicked))) {
                String posString = Operazioni.getVec3iString(new Vec3i(positionClicked.getX(), positionClicked.getY(), positionClicked.getZ()));
                if (this.contieneBloccoInventario(nbt, posString)) {
                    this.rimuoviBloccoInventario(nbt, posString);
                } else {
                    this.aggiungiBloccoInventario(nbt, posString, level);
                }
                OldVersionUtilities.impostaItemStackNBT(itemStack, nbt);
                return InteractionResult.FAIL;
            }
            if (nbt.contains("originPos") && positionClicked.equals((Object)new BlockPos(Operazioni.getVec3iFromString(nbt.getString("originPos"))).offset(0, -1, 0))) {
                nbt.remove("originPos");
            } else {
                nbt.putString("originPos", Operazioni.getVec3iString(new Vec3i(positionClicked.getX(), positionClicked.getY() + 1, positionClicked.getZ())));
            }
            OldVersionUtilities.impostaItemStackNBT(itemStack, nbt);
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player.pick(5.0, 0.0f, false).getType() == HitResult.Type.MISS && world.isClientSide) {
            ItemStack itemStack = player.getMainHandItem();
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(itemStack);
            if (!(Blueprint.condiviso_con_player(nbt) || nbt.getString("owner").equals("server") || nbt.getString("owner").equals("worn") || (nbt.getString("owner").equals("") || UUID.fromString(nbt.getString("owner")).equals(player.getUUID())) && !nbt.getString("owner").equals(""))) {
                return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)world.isClientSide);
            }
            ArrayList<BlockPos> bp = new ArrayList<BlockPos>();
            if (nbt.contains("inventari_blocco_selezionati")) {
                for (String pos : nbt.getString("inventari_blocco_selezionati").split("!;!")) {
                    if (pos.equals("")) continue;
                    BlockPos p = new BlockPos(Operazioni.getVec3iFromString(pos));
                    bp.add(p);
                }
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientMethods.openBlueprintItemGUI(player.getMainHandItem(), bp));
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)world.isClientSide);
    }

    public void setBlueprint(ItemStack b, ServerPlayer player, UUID owner, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(b);
        String owner_name = "?";
        Optional profile = player.getServer().getProfileCache().get(owner);
        if (profile != null) {
            owner_name = ((GameProfile)profile.get()).getName();
        }
        nbt.putString("nome", nome);
        nbt.putString("owner", owner.toString());
        nbt.putString("owner_name", owner_name);
        nbt.putInt("altezza", altezza);
        nbt.putInt("lunghezzaX", lunghezzaX);
        nbt.putInt("lunghezzaZ", lunghezzaZ);
        nbt.putBoolean("visualizeBuild", false);
        nbt.putShort("rotateValue", (short)0);
        nbt.putBoolean("mirrowX", false);
        nbt.putBoolean("mirrowY", false);
        nbt.putBoolean("mirrowZ", false);
        nbt.putString("inventari_blocco_selezionati", "");
        nbt.putBoolean("wasHolding", false);
        nbt.putBoolean("skipObstructionBlock", false);
        nbt.putBoolean("buildAnyway", false);
        OldVersionUtilities.impostaItemStackNBT(b, nbt);
    }

    public void setServerBlueprint(ItemStack blueprint, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(blueprint);
        String owner_name = Component.translatable((String)"gui.portable_blueprints.tablet.shared_by_server").getString();
        nbt.putString("nome", nome);
        nbt.putString("owner", "server");
        nbt.putString("owner_name", owner_name);
        nbt.putInt("altezza", altezza);
        nbt.putInt("lunghezzaX", lunghezzaX);
        nbt.putInt("lunghezzaZ", lunghezzaZ);
        nbt.putBoolean("visualizeBuild", false);
        nbt.putShort("rotateValue", (short)0);
        nbt.putBoolean("mirrowX", false);
        nbt.putBoolean("mirrowY", false);
        nbt.putBoolean("mirrowZ", false);
        nbt.putString("inventari_blocco_selezionati", "");
        nbt.putBoolean("wasHolding", false);
        nbt.putBoolean("skipObstructionBlock", false);
        nbt.putBoolean("buildAnyway", false);
        OldVersionUtilities.impostaItemStackNBT(blueprint, nbt);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext world, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag nbt = OldVersionUtilities.getItemStackNBT(stack);
        if (Screen.hasShiftDown()) {
            boolean alterna_colore = true;
            for (String val : Component.translatable((String)"item.portable_blueprints.description.blueprint_4").getString().split("%n%")) {
                if (val.equals("")) continue;
                tooltip.add((Component)Component.literal((String)val).withStyle(alterna_colore ? ChatFormatting.GOLD : ChatFormatting.YELLOW));
                alterna_colore = !alterna_colore;
            }
        } else {
            if (stack.is((Item)ModItems.BLUEPRINT.get())) {
                tooltip.add((Component)Component.literal((String)Component.translatable((String)"item.portable_blueprints.description.blueprint_1").getString().replace("%v%", nbt.contains("owner_name") ? nbt.getString("owner_name") : "?")).withStyle(ChatFormatting.DARK_AQUA));
            }
            if (nbt.contains("nome") && nbt.getString("nome").contains("[Global]")) {
                tooltip.add((Component)Component.literal((String)Component.translatable((String)"item.portable_blueprints.description.blueprint_2").getString().replace("%v%", nbt.getString("nome").replace("[Global]", ""))).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)"\u00a7d[Global]")));
            } else {
                tooltip.add((Component)Component.literal((String)Component.translatable((String)"item.portable_blueprints.description.blueprint_2").getString().replace("%v%", nbt.contains("nome") ? nbt.getString("nome") : "?")).withStyle(ChatFormatting.DARK_AQUA));
            }
            if (Blueprint.condiviso_con_player(nbt)) {
                tooltip.add((Component)Component.translatable((String)"item.portable_blueprints.description.blueprint_swm").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            tooltip.add((Component)Component.translatable((String)"item.portable_blueprints.description.blueprint_3").withStyle(ChatFormatting.GOLD));
        }
        super.appendHoverText(stack, world, tooltip, flag);
    }

    public void aggiungiBloccoInventario(CompoundTag tag, String pos, Level level) {
        Object newList = "";
        int size = this.sizeBloccoInventario(tag);
        boolean rimossoPrimo = false;
        for (String p : tag.getString("inventari_blocco_selezionati").split("!;!")) {
            if (p.equals("")) continue;
            if (size >= level.getGameRules().getInt(ModGameRules.MaxBlueprintContainers) && !rimossoPrimo) {
                rimossoPrimo = true;
                continue;
            }
            newList = (String)newList + p + "!;!";
        }
        newList = (String)newList + pos;
        if (Minecraft.getInstance().player != null && ((Boolean)ModConfig.ContainerMessagesEnabled.get()).booleanValue()) {
            TextColor t = (TextColor)TextColor.parseColor((String)((String)ModConfig.ContainerAreaColor.get())).getOrThrow();
            try {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"chat_message.portable_blueprints.container.linked").getString().replace("%v%", pos)).withStyle(Style.EMPTY.withColor(t)), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tag.putString("inventari_blocco_selezionati", (String)newList);
    }

    public void rimuoviBloccoInventario(CompoundTag tag, String pos) {
        Object newList = "";
        int size = this.sizeBloccoInventario(tag);
        int arrivato = 0;
        for (String p : tag.getString("inventari_blocco_selezionati").split("!;!")) {
            if (p.equals("")) continue;
            if (!p.equals(pos)) {
                newList = (String)newList + p + (arrivato < size ? "!;!" : "");
            }
            ++arrivato;
        }
        if (Minecraft.getInstance().player != null && ((Boolean)ModConfig.ContainerMessagesEnabled.get()).booleanValue()) {
            TextColor t = (TextColor)TextColor.parseColor((String)((String)ModConfig.ContainerAreaColor.get())).getOrThrow();
            try {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"chat_message.portable_blueprints.container.unlinked").getString().replace("%v%", pos)).withStyle(Style.EMPTY.withColor(t)), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tag.putString("inventari_blocco_selezionati", (String)newList);
    }

    public boolean contieneBloccoInventario(CompoundTag tag, String pos) {
        for (String p : tag.getString("inventari_blocco_selezionati").split("!;!")) {
            if (p.equals("") || !p.equals(pos)) continue;
            return true;
        }
        return false;
    }

    public int sizeBloccoInventario(CompoundTag tag) {
        int quantiti = 0;
        for (String p : tag.getString("inventari_blocco_selezionati").split("!;!")) {
            if (p.equals("")) continue;
            ++quantiti;
        }
        return quantiti;
    }

    public void onItemEquipped(Player player, CompoundTag nbt, ItemStack item) {
        PacketHandler.sendToServer(new CtoS_SharedBlueprintData());
        PacketHandler.sendToServer(new CtoS_ServerBlueprintsData());
        PacketHandler.sendToServer(new CtoS_RemoveItemIfBlueprintNotExist(nbt.getString("nome"), item));
        if (nbt.getString("owner").equals("server") || nbt.getString("owner").equals("worn") || !nbt.getString("owner").equals("server") && !nbt.getString("owner").equals("") && UUID.fromString(nbt.getString("owner")).equals(player.getUUID()) || Blueprint.condiviso_con_player(nbt)) {
            if (nbt.getString("owner").equals("server")) {
                VisualizeBlueprintDatas.newVisualizeBlueprint(true, nbt.getString("nome"), nbt.getInt("altezza"), nbt.getInt("lunghezzaX"), nbt.getInt("lunghezzaZ"), false);
            } else if (nbt.getString("owner").equals("worn")) {
                VisualizeBlueprintDatas.newVisualizeBlueprint(false, true, nbt.getString("nome"), nbt.getInt("altezza"), nbt.getInt("lunghezzaX"), nbt.getInt("lunghezzaZ"), false);
            } else if (!nbt.getString("owner").equals("")) {
                VisualizeBlueprintDatas.newVisualizeBlueprint(UUID.fromString(nbt.getString("owner")), nbt.getString("nome"), nbt.getInt("altezza"), nbt.getInt("lunghezzaX"), nbt.getInt("lunghezzaZ"), false);
            }
        }
    }

    public void onItemUnequipped(Player player, CompoundTag nbt) {
    }

    public static boolean condiviso_con_player(CompoundTag nbt) {
        try {
            PacketHandler.sendToServer(new CtoS_ServerBlueprintsData());
            if (nbt.getString("owner").equals("server")) {
                return ClientMethods.ServerBlueprints.contains(nbt.getString("nome"));
            }
            if (nbt.getString("owner").equals("worn")) {
                return true;
            }
            return ClientMethods.SharedWithMeBlueprints != null && ClientMethods.SharedWithMeBlueprints.ContieneSWMBlueprint(UUID.fromString(nbt.getString("owner")), nbt.getString("nome"));
        }
        catch (Exception e) {
            return false;
        }
    }
}

