/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.altro.BlockBlueprintUsage;
import nimble.portable_blueprints.altro.Blueprint;

public class CtoS_CreateBlueprint {
    private static Map<UUID, PachettoDati> DatiPachetto = new HashMap<UUID, PachettoDati>();
    private final BlockPos angolo1;
    private final BlockPos angolo2;
    private final String nome;
    private final boolean consideraCreativeBlocks;
    private final UUID uuidRichiesta;
    private final String datoLista;

    public CtoS_CreateBlueprint() {
        this.angolo1 = new BlockPos(0, 0, 0);
        this.angolo2 = new BlockPos(0, 0, 0);
        this.nome = "";
        this.consideraCreativeBlocks = false;
        this.datoLista = "";
        this.uuidRichiesta = UUID.randomUUID();
    }

    public CtoS_CreateBlueprint(BlockPos angolo1, BlockPos angolo2, String nome, boolean consideraCreativeBlocks, UUID uuidRichiesta) {
        this.angolo1 = angolo1;
        this.angolo2 = angolo2;
        this.nome = nome;
        this.consideraCreativeBlocks = consideraCreativeBlocks;
        this.datoLista = "";
        this.uuidRichiesta = uuidRichiesta;
    }

    public CtoS_CreateBlueprint(String dato, UUID uuidRichiesta) {
        this.angolo1 = new BlockPos(0, 0, 0);
        this.angolo2 = new BlockPos(0, 0, 0);
        this.nome = "";
        this.consideraCreativeBlocks = false;
        this.datoLista = dato;
        this.uuidRichiesta = uuidRichiesta;
    }

    public CtoS_CreateBlueprint(FriendlyByteBuf buffer) {
        this.angolo1 = buffer.readBlockPos();
        this.angolo2 = buffer.readBlockPos();
        this.nome = buffer.readUtf();
        this.consideraCreativeBlocks = buffer.readBoolean();
        this.datoLista = buffer.readUtf();
        this.uuidRichiesta = buffer.readUUID();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.angolo1);
        buffer.writeBlockPos(this.angolo2);
        buffer.writeUtf(this.nome);
        buffer.writeBoolean(this.consideraCreativeBlocks);
        buffer.writeUtf(this.datoLista);
        buffer.writeUUID(this.uuidRichiesta);
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            ServerLevel level = player.serverLevel();
            if (BlockBlueprintUsage.PlayersBlock.contains(player.getName().getString())) {
                if (!this.nome.equals("")) {
                    player.displayClientMessage((Component)Component.translatable((String)"chat_message.portable_blueprints.block_scanner").withStyle(ChatFormatting.RED), false);
                }
                return;
            }
            if ((this.nome.equals("") || this.nome.isEmpty()) && DatiPachetto.containsKey(this.uuidRichiesta)) {
                if (this.datoLista.equals("\ufffdEND\ufffd")) {
                    PachettoDati pachettoDati = DatiPachetto.get(this.uuidRichiesta);
                    Blueprint.CreateBlueprint(level, pachettoDati.angolo1, pachettoDati.angolo2, pachettoDati.nome, player.getUUID(), pachettoDati.consideraCreativeBlocks, pachettoDati.ScannerIgnoredBlocks);
                    DatiPachetto.remove(this.uuidRichiesta);
                } else {
                    CtoS_CreateBlueprint.DatiPachetto.get((Object)this.uuidRichiesta).ScannerIgnoredBlocks.add(this.datoLista);
                }
            } else if (!(this.nome.equals("") || this.nome.isEmpty() || DatiPachetto.containsKey(this.uuidRichiesta))) {
                player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"hotbar_message.portable_blueprints.blueprint_creation").getString().replace("%v%", this.nome)).withStyle(ChatFormatting.GREEN), true);
                DatiPachetto.put(this.uuidRichiesta, new PachettoDati(this, this.angolo1, this.angolo2, this.nome, this.consideraCreativeBlocks));
            }
        });
        return true;
    }

    public static List<String> creaListaDati(List<String> dati) {
        ArrayList<String> listaDati = new ArrayList<String>();
        for (String s : dati) {
            if (s.length() <= 30000) {
                listaDati.add(s);
                continue;
            }
            listaDati.add(s.substring(0, 30000));
        }
        listaDati.add("\ufffdEND\ufffd");
        return listaDati;
    }

    private class PachettoDati {
        public List<String> ScannerIgnoredBlocks = new ArrayList<String>();
        private final BlockPos angolo1;
        private final BlockPos angolo2;
        private final String nome;
        private final boolean consideraCreativeBlocks;

        public PachettoDati(CtoS_CreateBlueprint ctoS_CreateBlueprint, BlockPos angolo1, BlockPos angolo2, String nome, boolean consideraCreativeBlocks) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.nome = nome;
            this.consideraCreativeBlocks = consideraCreativeBlocks;
        }
    }
}

