/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import java.io.File;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;

public class CtoS_RemoveItemIfBlueprintNotExist {
    private final ItemStack item;
    private final String nome;

    public CtoS_RemoveItemIfBlueprintNotExist() {
        this.item = null;
        this.nome = "";
    }

    public CtoS_RemoveItemIfBlueprintNotExist(String nome, ItemStack item) {
        this.item = item;
        this.nome = nome;
    }

    public CtoS_RemoveItemIfBlueprintNotExist(FriendlyByteBuf buffer) {
        this.item = OldVersionUtilities.readItemStack(buffer);
        this.nome = buffer.readUtf();
    }

    public void encode(FriendlyByteBuf buffer) {
        OldVersionUtilities.writeItemStack(buffer, this.item);
        buffer.writeUtf(this.nome);
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            ServerLevel level = player.serverLevel();
            boolean esiste = false;
            try {
                for (File f : OldVersionUtilities.getItemStackNBT(this.item).getString("owner").equals("server") ? Blueprint.getServerBlueprintFile(level).listFiles() : (OldVersionUtilities.getItemStackNBT(this.item).getString("owner").equals("worn") ? Blueprint.getWornBlueprintFile(level).listFiles() : Blueprint.getFileForBlueprints(level, UUID.fromString(OldVersionUtilities.getItemStackNBT(this.item).getString("owner"))).listFiles())) {
                    if (!f.getName().equals(this.nome + ".bp")) continue;
                    esiste = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!esiste) {
                for (int x = 0; x < player.getInventory().getContainerSize(); ++x) {
                    CompoundTag nbt;
                    if (!OldVersionUtilities.getItemStackNBT(player.getInventory().getItem(x)).contains("nome") || !player.getInventory().getItem(x).getItem().equals(this.item.getItem()) || !(nbt = OldVersionUtilities.getItemStackNBT(player.getInventory().getItem(x))).getString("nome").equals(OldVersionUtilities.getItemStackNBT(this.item).getString("nome")) || !nbt.contains("owner") || !nbt.getString("owner").equals(OldVersionUtilities.getItemStackNBT(this.item).getString("owner"))) continue;
                    player.getInventory().setItem(x, ItemStack.EMPTY);
                    player.displayClientMessage((Component)Component.translatable((String)"hotbar_message.portable_blueprints.blueprint_missing").withStyle(ChatFormatting.RED), true);
                    break;
                }
            }
        });
        return true;
    }
}

