/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.SharedBlueprints;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.altro.Blueprint;

public class CtoS_RemoveShareWithOthers {
    private final UUID creatore_richiesta;
    private final UUID ricevente;
    private final String nome;

    public CtoS_RemoveShareWithOthers() {
        this.creatore_richiesta = null;
        this.ricevente = null;
        this.nome = "";
    }

    public CtoS_RemoveShareWithOthers(String nome, UUID creatore_richiesta, UUID ricevente) {
        this.ricevente = ricevente;
        this.creatore_richiesta = creatore_richiesta;
        this.nome = nome;
    }

    public CtoS_RemoveShareWithOthers(FriendlyByteBuf buffer) {
        this.creatore_richiesta = buffer.readUUID();
        this.ricevente = buffer.readUUID();
        this.nome = buffer.readUtf();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.creatore_richiesta);
        buffer.writeUUID(this.ricevente);
        buffer.writeUtf(this.nome);
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            ServerLevel level = player.serverLevel();
            Blueprint.removeSharedBlueprint(level, this.nome, this.creatore_richiesta, this.ricevente);
        });
        return true;
    }
}

