/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.Events.ModEventClientForge;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;

public class StoC_AnimazionePosizionamentoBlocco {
    private final Item item;
    private final Long EndTime;
    private final Vec3 startpos;
    private final Vec3 endpos;

    public StoC_AnimazionePosizionamentoBlocco() {
        this.item = null;
        this.EndTime = 0L;
        this.startpos = Vec3.ZERO;
        this.endpos = Vec3.ZERO;
    }

    public StoC_AnimazionePosizionamentoBlocco(Item item, Long EndTime, Vec3 startpos, Vec3 endpos) {
        this.item = item;
        this.EndTime = EndTime;
        this.startpos = startpos;
        this.endpos = endpos;
    }

    public StoC_AnimazionePosizionamentoBlocco(FriendlyByteBuf buffer) {
        this.item = OldVersionUtilities.readItemStack(buffer).getItem();
        this.EndTime = buffer.readLong();
        this.startpos = Operazioni.getVec3FromString(buffer.readUtf());
        this.endpos = Operazioni.getVec3FromString(buffer.readUtf());
    }

    public void encode(FriendlyByteBuf buffer) {
        OldVersionUtilities.writeItemStack(buffer, new ItemStack((ItemLike)this.item));
        buffer.writeLong(this.EndTime.longValue());
        buffer.writeUtf(Operazioni.getVec3String(this.startpos));
        buffer.writeUtf(Operazioni.getVec3String(this.endpos));
    }

    public static void handle(StoC_AnimazionePosizionamentoBlocco msg, CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            if (Minecraft.getInstance().player.blockPosition().distManhattan(new Vec3i((int)msg.startpos.x, (int)msg.startpos.y, (int)msg.startpos.z)) <= 200) {
                ModEventClientForge.AnimPosBlocks.add(new ModEventClientForge.AnimazionePosizionamentoBlocco(msg.item, msg.EndTime, msg.startpos, msg.endpos));
            }
        });
    }
}

