/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.Events.RenderScannerAnimation;
import nimble.portable_blueprints.portable_blueprints.ModConfig;

public class StoC_ScannerAnimation {
    private final UUID animationID;
    private final boolean active;
    private final boolean add;
    private final BlockPos angolo1;
    private final BlockPos angolo2;

    public StoC_ScannerAnimation() {
        this.animationID = UUID.randomUUID();
        this.active = false;
        this.angolo1 = new BlockPos(0, 0, 0);
        this.angolo2 = new BlockPos(0, 0, 0);
        this.add = false;
    }

    public StoC_ScannerAnimation(UUID animationID, boolean active, BlockPos angolo1, BlockPos angolo2) {
        this.animationID = animationID;
        this.active = active;
        this.angolo1 = angolo1;
        this.angolo2 = angolo2;
        this.add = false;
    }

    public StoC_ScannerAnimation(UUID animationID) {
        this.animationID = animationID;
        this.active = false;
        this.angolo1 = new BlockPos(0, 0, 0);
        this.angolo2 = new BlockPos(0, 0, 0);
        this.add = true;
    }

    public StoC_ScannerAnimation(FriendlyByteBuf buffer) {
        this.animationID = buffer.readUUID();
        this.active = buffer.readBoolean();
        this.angolo1 = buffer.readBlockPos();
        this.angolo2 = buffer.readBlockPos();
        this.add = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.animationID);
        buffer.writeBoolean(this.active);
        buffer.writeBlockPos(this.angolo1);
        buffer.writeBlockPos(this.angolo2);
        buffer.writeBoolean(this.add);
    }

    public static void handle(StoC_ScannerAnimation msg, CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            if (!((Boolean)ModConfig.ScanningAnimationEnabled.get()).booleanValue()) {
                return;
            }
            if (msg.add) {
                RenderScannerAnimation.addProgress(msg.animationID);
            } else if (msg.active) {
                RenderScannerAnimation.addAnimation(msg.animationID, msg.angolo1, msg.angolo2);
            } else {
                RenderScannerAnimation.removeAnimazione(msg.animationID);
            }
        });
    }
}

