/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.contenuto_container_selezionati;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.contenuto_container_selezionati.StoC_ContenutoContainerSelezionati;

public class CtoS_ContenutoContainerSelezionati {
    private List<BlockPos> posizioni = new ArrayList<BlockPos>();
    private final int IDRequest;

    public CtoS_ContenutoContainerSelezionati() {
        this.IDRequest = -1;
    }

    public CtoS_ContenutoContainerSelezionati(List<BlockPos> p, int IDRequest) {
        this.IDRequest = IDRequest;
        this.posizioni = p;
    }

    public CtoS_ContenutoContainerSelezionati(FriendlyByteBuf buffer) {
        this.IDRequest = buffer.readInt();
        int nPosizioni = buffer.readInt();
        for (int x = 0; x < nPosizioni; ++x) {
            this.posizioni.add(buffer.readBlockPos());
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.IDRequest);
        buffer.writeInt(this.posizioni.size());
        for (int x = 0; x < this.posizioni.size(); ++x) {
            buffer.writeBlockPos(this.posizioni.get(x));
        }
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            ServerLevel level = player.serverLevel();
            Map<Item, Integer> container = Blueprint.getAllItemQuantityFromInventory(player, level, this.posizioni);
            for (Map.Entry<Item, Integer> c : container.entrySet()) {
                PacketHandler.sendToPlayer(new StoC_ContenutoContainerSelezionati(this.IDRequest, c.getKey(), c.getValue()), player);
            }
        });
        return true;
    }
}

