/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.richiesta_contenuto;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.richiesta_contenuto.StoC_RichiestaGamerule;

public class CtoS_RichiestaGamerule {
    private final int idRichesta;
    private final TipoRichiesta tipoRichiesta;

    public CtoS_RichiestaGamerule() {
        this.idRichesta = -1;
        this.tipoRichiesta = null;
    }

    public CtoS_RichiestaGamerule(int idRichesta, TipoRichiesta tipoRichiesta) {
        this.idRichesta = idRichesta;
        this.tipoRichiesta = tipoRichiesta;
    }

    public CtoS_RichiestaGamerule(FriendlyByteBuf buffer) {
        this.idRichesta = buffer.readInt();
        this.tipoRichiesta = (TipoRichiesta)buffer.readEnum(TipoRichiesta.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.idRichesta);
        buffer.writeEnum((Enum)this.tipoRichiesta);
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            ServerLevel level = player.serverLevel();
            switch (this.tipoRichiesta.ordinal()) {
                case 0: {
                    PacketHandler.sendToPlayer(new StoC_RichiestaGamerule(this.idRichesta, level.getLevelData().getGameRules().getInt(ModGameRules.Max_Blueprints_for_player)), player);
                    break;
                }
                case 1: {
                    PacketHandler.sendToPlayer(new StoC_RichiestaGamerule(this.idRichesta, level.getLevelData().getGameRules().getInt(ModGameRules.MaxScannerBlockCount)), player);
                    break;
                }
                case 2: {
                    PacketHandler.sendToPlayer(new StoC_RichiestaGamerule(this.idRichesta, level.getLevelData().getGameRules().getBoolean(ModGameRules.AllowGlobalBlueprints)), player);
                }
            }
        });
        return true;
    }

    public static enum TipoRichiesta {
        MAX_BLUEPRINTS_FOR_PLAYER,
        MAX_STRUCTURE_BLOCK_COUNT,
        ALLOW_GLOBAL_BLUEPRINTS;

    }
}

