/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.update_item_blueprint_nbt;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.update_item_blueprint_nbt.StoC_UpdateItemBlueprintNBT;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;

public class CtoS_UpdateItemBlueprintNBT {
    private final ItemStack item;
    private final String nome;
    private final boolean valore_booleano;
    private final short valore_short;
    private final BlockPos posNuova;

    public CtoS_UpdateItemBlueprintNBT() {
        this.item = null;
        this.nome = "";
        this.valore_booleano = false;
        this.valore_short = 0;
        this.posNuova = BlockPos.ZERO;
    }

    public CtoS_UpdateItemBlueprintNBT(ItemStack item, String nome, boolean valore_booleano) {
        this.item = item;
        this.nome = nome;
        this.valore_booleano = valore_booleano;
        this.valore_short = 0;
        this.posNuova = BlockPos.ZERO;
    }

    public CtoS_UpdateItemBlueprintNBT(ItemStack item, String nome, short valore_short) {
        this.item = item;
        this.nome = nome;
        this.valore_booleano = false;
        this.valore_short = valore_short;
        this.posNuova = BlockPos.ZERO;
    }

    public CtoS_UpdateItemBlueprintNBT(ItemStack item, String nome, BlockPos posNuova) {
        this.item = item;
        this.nome = nome;
        this.valore_booleano = false;
        this.valore_short = 0;
        this.posNuova = posNuova;
    }

    public CtoS_UpdateItemBlueprintNBT(FriendlyByteBuf buffer) {
        this.item = OldVersionUtilities.readItemStack(buffer);
        this.nome = buffer.readUtf();
        this.valore_booleano = buffer.readBoolean();
        this.valore_short = buffer.readShort();
        this.posNuova = buffer.readBlockPos();
    }

    public void encode(FriendlyByteBuf buffer) {
        OldVersionUtilities.writeItemStack(buffer, this.item);
        buffer.writeUtf(this.nome);
        buffer.writeBoolean(this.valore_booleano);
        buffer.writeShort((int)this.valore_short);
        buffer.writeBlockPos(this.posNuova);
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            ItemStack itemStack = player.getMainHandItem();
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(itemStack);
            if (this.nome.equals("skipObstructionBlock") || this.nome.equals("mirrowX") || this.nome.equals("mirrowY") || this.nome.equals("mirrowZ") || this.nome.equals("buildAnyway")) {
                nbt.putBoolean(this.nome, this.valore_booleano);
            } else if (this.nome.equals("rotateValue")) {
                nbt.putShort(this.nome, this.valore_short);
            } else if (this.nome.equals("originPos")) {
                nbt.putString(this.nome, Operazioni.getVec3iString((Vec3i)this.posNuova));
            }
            OldVersionUtilities.impostaItemStackNBT(itemStack, nbt);
            PacketHandler.sendToPlayer(new StoC_UpdateItemBlueprintNBT(!this.nome.equals("originPos")), player);
        });
        return true;
    }
}

