/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.update_item_scanner_nbt;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;

public class CtoS_UpdateItemScannerNBT {
    private final ItemStack item;
    private final String nome;
    private final boolean is_valore_string;
    private final String valore_stringa;

    public CtoS_UpdateItemScannerNBT() {
        this.item = null;
        this.nome = "";
        this.is_valore_string = false;
        this.valore_stringa = "";
    }

    public CtoS_UpdateItemScannerNBT(ItemStack item, String nome, String valore_stringa) {
        this.item = item;
        this.nome = nome;
        this.is_valore_string = true;
        this.valore_stringa = valore_stringa;
    }

    public CtoS_UpdateItemScannerNBT(FriendlyByteBuf buffer) {
        this.item = OldVersionUtilities.readItemStack(buffer);
        this.nome = buffer.readUtf();
        this.is_valore_string = buffer.readBoolean();
        this.valore_stringa = buffer.readUtf();
    }

    public void encode(FriendlyByteBuf buffer) {
        OldVersionUtilities.writeItemStack(buffer, this.item);
        buffer.writeUtf(this.nome);
        buffer.writeBoolean(this.is_valore_string);
        buffer.writeUtf(this.valore_stringa);
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            if (player != null && this.is_valore_string) {
                ItemStack item = player.getMainHandItem();
                CompoundTag nbt = OldVersionUtilities.getItemStackNBT(item);
                if (this.nome.equals("coordinateAngolo1") || this.nome.equals("coordinateAngolo2")) {
                    nbt.putString(this.nome, this.valore_stringa);
                } else if (this.nome.equals("angolo1") || this.nome.equals("angolo2")) {
                    nbt.putBoolean(this.nome, Boolean.parseBoolean(this.valore_stringa));
                }
                OldVersionUtilities.impostaItemStackNBT(item, nbt);
            }
        });
        return true;
    }
}

