/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.visualize_blueprint_data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.visualize_blueprint_data.StoC_VisualizeBlueprintData;
import nimble.portable_blueprints.robautile.Operazioni;

public class CtoS_VisualizeBlueprintData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String nomeBlueprintRichiesto;
    private final int IDRichiestaBlueprint;
    private final UUID owner_blueprint;
    private final boolean isServerBlueprint;
    private final boolean isWornBlueprint;

    public CtoS_VisualizeBlueprintData() {
        this.nomeBlueprintRichiesto = "";
        this.IDRichiestaBlueprint = 0;
        this.owner_blueprint = null;
        this.isServerBlueprint = false;
        this.isWornBlueprint = false;
    }

    public CtoS_VisualizeBlueprintData(int IDRichiestaBlueprint, String nomeBlueprintRichiesto, UUID owner_blueprint) {
        this.IDRichiestaBlueprint = IDRichiestaBlueprint;
        this.nomeBlueprintRichiesto = nomeBlueprintRichiesto;
        this.owner_blueprint = owner_blueprint;
        this.isServerBlueprint = false;
        this.isWornBlueprint = false;
    }

    public CtoS_VisualizeBlueprintData(int IDRichiestaBlueprint, String nomeBlueprintRichiesto, boolean isServerBlueprint) {
        this.IDRichiestaBlueprint = IDRichiestaBlueprint;
        this.nomeBlueprintRichiesto = nomeBlueprintRichiesto;
        this.owner_blueprint = UUID.randomUUID();
        this.isServerBlueprint = isServerBlueprint;
        this.isWornBlueprint = false;
    }

    public CtoS_VisualizeBlueprintData(int IDRichiestaBlueprint, String nomeBlueprintRichiesto, boolean isServerBlueprint, boolean isWornBlueprint) {
        this.IDRichiestaBlueprint = IDRichiestaBlueprint;
        this.nomeBlueprintRichiesto = nomeBlueprintRichiesto;
        this.owner_blueprint = UUID.randomUUID();
        this.isServerBlueprint = false;
        this.isWornBlueprint = isWornBlueprint;
    }

    public CtoS_VisualizeBlueprintData(FriendlyByteBuf buffer) {
        this.IDRichiestaBlueprint = buffer.readInt();
        this.nomeBlueprintRichiesto = buffer.readUtf();
        this.owner_blueprint = buffer.readUUID();
        this.isServerBlueprint = buffer.readBoolean();
        this.isWornBlueprint = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.IDRichiestaBlueprint);
        buffer.writeUtf(this.nomeBlueprintRichiesto);
        buffer.writeUUID(this.owner_blueprint);
        buffer.writeBoolean(this.isServerBlueprint);
        buffer.writeBoolean(this.isWornBlueprint);
    }

    public boolean handle(CustomPayloadEvent.Context supplier) {
        supplier.enqueueWork(() -> {
            ServerPlayer player = supplier.getSender();
            ServerLevel level = player.serverLevel();
            File blueprintFile = null;
            for (File f : this.isServerBlueprint ? Blueprint.getServerBlueprintFile(level).listFiles() : (this.isWornBlueprint ? Blueprint.getWornBlueprintFile(level).listFiles() : Blueprint.getFileForBlueprints(level, this.owner_blueprint).listFiles())) {
                if (!f.getName().equals(this.nomeBlueprintRichiesto + ".bp")) continue;
                blueprintFile = f;
                break;
            }
            if (blueprintFile != null) {
                Blueprint.BlueprintDatas bd = null;
                try {
                    bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (bd != null) {
                    long delayMillis = 1L;
                    List<String> Pachetti = null;
                    try {
                        String bd_string_datas = new String(Files.readAllBytes(blueprintFile.toPath()));
                        if (bd_string_datas.isEmpty()) {
                            return;
                        }
                        Pachetti = Operazioni.splitStringByLength(bd_string_datas, 30000);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (Pachetti == null) {
                        return;
                    }
                    List<String> finalPachetti = Pachetti;
                    new Thread(() -> {
                        int volte = 0;
                        PacketHandler.sendToPlayer(new StoC_VisualizeBlueprintData(this.IDRichiestaBlueprint, "[DATI INIZIALI]<bsize>" + finalPachetti.size() + "</bsize>"), player);
                        try {
                            for (String pachetto : finalPachetti) {
                                PacketHandler.sendToPlayer(new StoC_VisualizeBlueprintData(this.IDRichiestaBlueprint, pachetto), player);
                                if (++volte % 4 != 0) continue;
                                Thread.sleep(delayMillis);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PacketHandler.sendToPlayer(new StoC_VisualizeBlueprintData(this.IDRichiestaBlueprint, "[DATI FINITI]"), player);
                    }).start();
                }
            }
        });
        return true;
    }
}

