/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import nimble.portable_blueprints.robautile.Operazioni;
import org.joml.Vector2i;

public class RenderingMethods {
    public static void GuiGraphicsTestoScalato(GuiGraphics gg, String testo, float Scala, Font font, Vec2 position, int Color, boolean Ombra, PosizioneTesto Position) {
        RenderingMethods.guiGraphicsTestoScalato(gg, testo, Scala, font, position, Color, Ombra, Position, false);
    }

    public static void GuiGraphicsTestoScalato(GuiGraphics gg, String testo, float Scala, Font font, Vec2 position, int Color, boolean Ombra, PosizioneTesto Position, boolean YCentrale) {
        RenderingMethods.guiGraphicsTestoScalato(gg, testo, Scala, font, position, Color, Ombra, Position, YCentrale);
    }

    private static void guiGraphicsTestoScalato(GuiGraphics gg, String testo, float Scala, Font font, Vec2 position, int Color, boolean Ombra, PosizioneTesto Position, boolean YCentrale) {
        String valore = Operazioni.getValueInsideTag(testo, "remove_size");
        if (!valore.isEmpty()) {
            testo = testo.replace("<remove_size>" + valore + "</remove_size>", "");
            Scala -= Float.parseFloat(valore);
        }
        PoseStack poseStack = gg.pose();
        poseStack.pushPose();
        poseStack.scale(Scala, Scala, Scala);
        String[] split = testo.split("%n%");
        for (int x = 0; x < split.length; ++x) {
            float Y;
            testo = split[x];
            if (YCentrale) {
                float f = position.y / Scala;
                Objects.requireNonNull(font);
                float f2 = f - (float)(9 / 2);
                Objects.requireNonNull(font);
                v2 = f2 + (float)(x * 9);
            } else {
                float f = position.y / Scala;
                Objects.requireNonNull(font);
                v2 = Y = f + (float)(x * 9);
            }
            if (Position.equals((Object)PosizioneTesto.CENTRO)) {
                gg.drawString(font, testo, position.x / Scala - (float)(font.width(testo) / 2), Y, Color, Ombra);
                continue;
            }
            if (Position.equals((Object)PosizioneTesto.SINISTRA)) {
                gg.drawString(font, testo, position.x / Scala, Y, Color, Ombra);
                continue;
            }
            gg.drawString(font, testo, position.x / Scala - (float)font.width(testo), Y, Color, Ombra);
        }
        poseStack.popPose();
    }

    public static void renderTextInWorld(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, Vec3 pos, String testo, Font font, float Scale, int Color, float MaxDistanceRender, float MinDistanceResize, boolean onTopOfBlocks) {
        Minecraft mc = Minecraft.getInstance();
        double targetX = pos.x + 0.5;
        double targetY = pos.y + 0.5;
        double targetZ = pos.z + 0.5;
        double camX = camera.getPosition().x;
        double camY = camera.getPosition().y;
        double camZ = camera.getPosition().z;
        double distanceX = targetX - camX;
        double distanceY = targetY - camY;
        double distanceZ = targetZ - camZ;
        double distance = mc.player.position().distanceTo(pos);
        if (distance > (double)MaxDistanceRender) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(distanceX, distanceY, distanceZ);
        poseStack.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(-0.025f, -0.025f, -0.025f);
        if (distance > (double)MinDistanceResize) {
            Scale = (float)Operazioni.lerp((double)Scale, (double)(Scale * 10.0f), (distance - (double)MinDistanceResize) / (double)(MaxDistanceRender - MinDistanceResize));
        }
        poseStack.scale(Scale, Scale, Scale);
        float textWidth = (float)font.width(testo) / 2.0f;
        float f = -textWidth;
        Objects.requireNonNull(font);
        font.drawInBatch(testo, f, (float)(-(9 / 2)), Color, !onTopOfBlocks, poseStack.last().pose(), bufferSource, onTopOfBlocks ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void RenderItemInGui(GuiGraphics gg, Vector2i pos, Vec2 offset, float Scale, ItemStack item) {
        PoseStack pMatrixStack = gg.pose();
        pMatrixStack.pushPose();
        pMatrixStack.scale(Scale, Scale, Scale);
        pMatrixStack.translate(offset.x, offset.y, 0.0f);
        gg.renderFakeItem(item, (int)((float)pos.x / Scale), (int)((float)pos.y / Scale));
        pMatrixStack.popPose();
    }

    public static void renderFixedTextInWorld(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, Vec3 pos, Vec3 rotation, String testo, Font font, float Scale, int Color, float MaxDistanceRender, boolean onTopOfBlocks) {
        Minecraft mc = Minecraft.getInstance();
        double targetX = pos.x + 0.5;
        double targetY = pos.y + 0.5;
        double targetZ = pos.z + 0.5;
        double camX = camera.getPosition().x;
        double camY = camera.getPosition().y;
        double camZ = camera.getPosition().z;
        double distanceX = targetX - camX;
        double distanceY = targetY - camY;
        double distanceZ = targetZ - camZ;
        double distance = mc.player.position().distanceTo(pos);
        if (distance > (double)MaxDistanceRender) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(distanceX, distanceY, distanceZ);
        poseStack.mulPose(Axis.XP.rotationDegrees((float)rotation.x));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)rotation.y));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)rotation.z));
        poseStack.scale(-Scale, -Scale, -Scale);
        float textWidth = (float)font.width(testo) / 2.0f;
        float f = -textWidth;
        Objects.requireNonNull(font);
        font.drawInBatch(testo, f, (float)(-(9 / 2)), Color, !onTopOfBlocks, poseStack.last().pose(), bufferSource, onTopOfBlocks ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void RenderItemInWorld(PoseStack poseStack, Vec3 renderPos, Item item, float scale) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = new ItemStack((ItemLike)item);
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        double x = renderPos.x - cameraPos.x;
        double y = renderPos.y - cameraPos.y;
        double z = renderPos.z - cameraPos.z;
        poseStack.pushPose();
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            float val = (1.0f - scale) / 2.0f;
            poseStack.translate(x - 0.5 + (double)val, y - 0.5 + (double)val, z - 0.5 + (double)val);
            poseStack.scale(scale, scale, scale);
            BlockRenderDispatcher render = mc.getBlockRenderer();
            BlockPos pos = new BlockPos(0, 0, 0);
            ModelData modelData = render.getBlockModel(blockItem.getBlock().defaultBlockState()).getModelData((BlockAndTintGetter)mc.level, pos, blockItem.getBlock().defaultBlockState(), ModelData.builder().build());
            render.renderSingleBlock(blockItem.getBlock().defaultBlockState(), poseStack, (MultiBufferSource)mc.renderBuffers().crumblingBufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, modelData, RenderType.cutout());
        } else {
            poseStack.scale(scale, scale, scale);
            poseStack.translate(x, y, z);
            ItemRenderer itemRenderer = mc.getItemRenderer();
            itemRenderer.render(stack, ItemDisplayContext.FIXED, true, poseStack, (MultiBufferSource)buffer, 0xF000F0, 0, itemRenderer.getModel(stack, null, null, 0));
        }
        buffer.endBatch();
        poseStack.popPose();
    }

    public static void GUITextAutoResize(GuiGraphics gg, String testo, Font font, int Color, float StartPosX, float StartPosY, int width, int height, boolean Ombra) {
        float scale = 1.0f;
        int textWidth = font.width(testo);
        Objects.requireNonNull(font);
        int textHeight = 9;
        if ((float)textWidth * scale > (float)width || (float)textHeight * scale > (float)height) {
            while (((float)textWidth * scale > (float)width || (float)textHeight * scale > (float)height) && !((scale -= 0.01f) <= 0.1f)) {
            }
        } else if ((float)textWidth * scale < (float)width && (float)textHeight * scale < (float)height) {
            while ((float)textWidth * scale < (float)width && (float)textHeight * scale < (float)height && !((scale += 0.01f) >= 100.0f)) {
            }
        }
        float scaledWidth = (float)textWidth * scale;
        float scaledHeight = (float)textHeight * scale;
        float centeredPosX = StartPosX + ((float)width - scaledWidth) / 2.0f;
        float centeredPosY = StartPosY + ((float)height - scaledHeight) / 2.0f;
        gg.pose().pushPose();
        gg.pose().scale(scale, scale, 1.0f);
        gg.drawString(font, testo, centeredPosX / scale, centeredPosY / scale, Color, Ombra);
        gg.pose().popPose();
    }

    public static void enableScissorFromGui(Minecraft mc, int x, int y, int width, int height) {
        double scale = mc.getWindow().getGuiScale();
        int windowWidth = mc.getWindow().getWidth();
        int windowHeight = mc.getWindow().getHeight();
        int px = (int)((double)x * scale);
        int py = (int)((double)y * scale);
        int pw = (int)((double)width * scale);
        int ph = (int)((double)height * scale);
        py = windowHeight - ph - py;
        RenderSystem.enableScissor((int)px, (int)py, (int)pw, (int)ph);
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static enum PosizioneTesto {
        SINISTRA,
        CENTRO,
        DESTRA;

    }

    public static class GuiGraphicsElement {
        private Tipo type = Tipo.FILL;
        public FILL_Parametri fillParametri = null;
        public BLIT_Parametri blitParametri = null;
        public TESTO_Parametri testoParametri = null;
        private ITEM_Parametri itemParametri = null;

        public GuiGraphicsElement(FILL_Parametri fillParametri) {
            this.type = Tipo.FILL;
            this.fillParametri = fillParametri;
        }

        public GuiGraphicsElement(BLIT_Parametri blitParametri) {
            this.type = Tipo.BLIT;
            this.blitParametri = blitParametri;
        }

        public GuiGraphicsElement(TESTO_Parametri testoParametri) {
            this.type = Tipo.TESTO;
            this.testoParametri = testoParametri;
        }

        public GuiGraphicsElement(ITEM_Parametri itemParametri) {
            this.type = Tipo.ITEM;
            this.itemParametri = itemParametri;
        }

        public void render(GuiGraphics gg) {
            switch (this.type.ordinal()) {
                case 0: {
                    if (this.fillParametri == null) break;
                    gg.pose().pushPose();
                    gg.pose().translate(this.fillParametri.PosOffsetX, this.fillParametri.PosOffsetY, 0.0);
                    gg.fill(this.fillParametri.startPosX, this.fillParametri.startPosY, this.fillParametri.endPosX, this.fillParametri.endPosY, this.fillParametri.color);
                    gg.pose().popPose();
                }
                case 1: {
                    if (this.blitParametri == null) break;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    gg.pose().pushPose();
                    gg.pose().translate(this.blitParametri.PosOffsetX, this.blitParametri.PosOffsetY, 0.0f);
                    gg.blit(this.blitParametri.img, this.blitParametri.startPosX, this.blitParametri.startPosY, this.blitParametri.offsetX, this.blitParametri.offsetY, this.blitParametri.width, this.blitParametri.height);
                    gg.pose().popPose();
                    RenderSystem.disableBlend();
                }
                case 2: {
                    if (this.testoParametri == null) break;
                    RenderingMethods.GuiGraphicsTestoScalato(gg, this.testoParametri.testo, this.testoParametri.scale, this.testoParametri.font, new Vec2(this.testoParametri.startPosX, this.testoParametri.startPosY), this.testoParametri.color, this.testoParametri.ombra, this.testoParametri.posizione, this.testoParametri.YCentrata);
                }
                case 3: {
                    if (this.itemParametri == null) break;
                    RenderingMethods.RenderItemInGui(gg, new Vector2i(this.itemParametri.startPosX, this.itemParametri.startPosY), new Vec2(this.itemParametri.offsetX, this.itemParametri.offsetY), this.itemParametri.scale, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(this.itemParametri.id)));
                }
            }
        }

        public static enum Tipo {
            FILL,
            BLIT,
            TESTO,
            ITEM;

        }

        public static class FILL_Parametri {
            public int startPosX;
            public int startPosY;
            public int endPosX;
            public int endPosY;
            public int color;
            public double PosOffsetX;
            public double PosOffsetY;

            public FILL_Parametri(int startPosX, int startPosY, int endPosX, int endPosY, int color) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.endPosX = endPosX;
                this.endPosY = endPosY;
                this.color = color;
            }

            public FILL_Parametri(int startPosX, int startPosY, int endPosX, int endPosY, int color, double PosOffsetX, double PosOffsetY) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.endPosX = endPosX;
                this.endPosY = endPosY;
                this.color = color;
                this.PosOffsetX = PosOffsetX;
                this.PosOffsetY = PosOffsetY;
            }

            public void setPosOffset(double PosOffsetX, double PosOffsetY) {
                this.PosOffsetX = PosOffsetX;
                this.PosOffsetY = PosOffsetY;
            }

            public void setColor(int color) {
                this.color = color;
            }
        }

        public static class BLIT_Parametri {
            public int startPosX;
            public int startPosY;
            public int offsetX;
            public int offsetY;
            public int width;
            public int height;
            public float PosOffsetX = 0.0f;
            public float PosOffsetY = 0.0f;
            public ResourceLocation img;

            public BLIT_Parametri(int startPosX, int startPosY, int offsetX, int offsetY, int width, int height, ResourceLocation img) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.img = img;
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                this.width = width;
                this.height = height;
            }

            public void setPos(int startPosX, int startPosY) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
            }

            public void setPosOffset(float PosOffsetX, float PosOffsetY) {
                this.PosOffsetX = PosOffsetX;
                this.PosOffsetY = PosOffsetY;
            }

            public void setImage(int offsetX, int offsetY, int width, int height, ResourceLocation img) {
                this.img = img;
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                this.width = width;
                this.height = height;
            }
        }

        public static class TESTO_Parametri {
            public int color;
            public String testo;
            public Font font;
            public float startPosX;
            public float startPosY;
            public float scale;
            public boolean ombra;
            public boolean YCentrata;
            public PosizioneTesto posizione;

            public TESTO_Parametri(float startPosX, float startPosY, String testo, float scale, Font font, int color, boolean ombra, PosizioneTesto posizione, boolean YCentrata) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.color = color;
                this.testo = testo;
                this.font = font;
                this.scale = scale;
                this.posizione = posizione;
                this.ombra = ombra;
                this.YCentrata = YCentrata;
            }

            public void setTesto(String val) {
                this.testo = val;
            }
        }

        public static class ITEM_Parametri {
            public String id;
            public int startPosX;
            public int startPosY;
            public float scale;
            public float offsetX;
            public float offsetY;

            public ITEM_Parametri(int startPosX, int startPosY, float offsetX, float offsetY, String id, float scale) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                this.id = id;
                this.scale = scale;
            }
        }
    }
}

