/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber
public class BlueprintWorldInjection {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FolderAssetPath = "config/portable_blueprints/world_injection_worn_blueprints";

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        Path worldDir = server.getWorldPath(LevelResource.ROOT);
        Path wornBlueprintWorldDir = worldDir.resolve("portable_blueprints/worn blueprints");
        Path modpackBpSourceDir = FMLPaths.GAMEDIR.get().resolve(FolderAssetPath);
        try {
            Files.createDirectories(wornBlueprintWorldDir, new FileAttribute[0]);
            BlueprintWorldInjection.creaDirectoryConFileSetting();
            WornBlueprintWorldInjectionSettings WBWIS = null;
            try {
                WBWIS = (WornBlueprintWorldInjectionSettings)GSON.fromJson((Reader)new FileReader(new File(modpackBpSourceDir.toFile(), "settings.json")), WornBlueprintWorldInjectionSettings.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File[] WorldBpFiles = wornBlueprintWorldDir.toFile().listFiles((dir, name) -> name.toLowerCase().endsWith(".bp"));
            if (WBWIS != null && WorldBpFiles != null) {
                for (File file : WorldBpFiles) {
                    try {
                        if (!WBWIS.WornBlueprintToRemove.contains(file.getName())) continue;
                        file.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            try (Stream<Path> files = Files.walk(modpackBpSourceDir, new FileVisitOption[0]);){
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.toString().endsWith(".bp")).forEach(f -> {
                    Path target = wornBlueprintWorldDir.resolve(f.getFileName());
                    try {
                        System.out.println("aggiungi: " + String.valueOf(f.getFileName()) + " | " + String.valueOf(wornBlueprintWorldDir) + " | " + String.valueOf(modpackBpSourceDir));
                        Files.copy(f, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void creaDirectoryConFileSetting() {
        block9: {
            Path modpackBpSourceDir = FMLPaths.GAMEDIR.get().resolve(FolderAssetPath);
            try {
                Files.createDirectories(modpackBpSourceDir, new FileAttribute[0]);
                File wornBlueprintWorldInjectionSettings = new File(modpackBpSourceDir.toFile(), "settings.json");
                if (wornBlueprintWorldInjectionSettings.exists()) break block9;
                try (FileWriter writer = new FileWriter(wornBlueprintWorldInjectionSettings);){
                    writer.write("//Introduction to using World Injection Worn Blueprints:\n");
                    writer.write("//Place all your .bp files in this folder to have them automatically loaded into the world when a player enters it.\n");
                    writer.write("//Using the WornBlueprintToRemove parameter, you can specify a list of .bp filenames to remove from the world (useful if you previously added some you no longer want).\n");
                    writer.write("//The names must exactly match the filename of the blueprint to remove. For example: \"house.bp\",\"tower.bp\"\n\n\n\n");
                    writer.write("{\n");
                    writer.write("  \"WornBlueprintToRemove\": []\n");
                    writer.write("}\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class WornBlueprintWorldInjectionSettings {
        public List<String> WornBlueprintToRemove = List.of("babba.bp");
    }
}

