/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import nimble.portable_blueprints.Events.BlueprintEvent;
import nimble.portable_blueprints.Events.ChangeShapeScanningAreaEvent;
import nimble.portable_blueprints.Events.RenderBlueprintsPreview;
import nimble.portable_blueprints.Events.RenderScannerAnimation;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.client.screen.TabletScreen;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.items.Scanner;
import nimble.portable_blueprints.network.ServerBlueprints.CtoS_ServerBlueprintsData;
import nimble.portable_blueprints.network.ottieni_shared_blueprint_data.CtoS_SharedBlueprintData;
import nimble.portable_blueprints.network.richiesta_contenuto.CtoS_RichiestaGamerule;
import nimble.portable_blueprints.network.save_global_blueprint.StoC_SaveGlobalBlueprint;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingGraphics;
import nimble.portable_blueprints.robautile.RenderingMethods;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="portable_blueprints", value={Dist.CLIENT})
public class ModEventClientForge {
    public static List<AnimazionePosizionamentoBlocco> AnimPosBlocks = new ArrayList<AnimazionePosizionamentoBlocco>();
    public static List<Tuple<BlockState, Vec3>> datiBlocchi = new ArrayList<Tuple<BlockState, Vec3>>();
    public static BlockPos offsetVisualizeBlueprint = BlockPos.ZERO;
    public static BlockPos ultimaLXAltezzaLZSalvata = BlockPos.ZERO;
    public static Vec3 posPrima = Vec3.ZERO;
    public static Vec3 posNonFinita = Vec3.ZERO;
    public static Vec3 posTarget = Vec3.ZERO;
    public static Long inizioAnim = System.currentTimeMillis();
    public static Direction DirezioneHitboxSelected = null;
    private static boolean hasJoinedWorld = false;

    @SubscribeEvent
    public static void renderLevelStageEvent(RenderLevelStageEvent event) {
        event.getPoseStack().pushPose();
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            ModEventClientForge.renderAnimazionePosizionamentoBlocco(event);
        } else if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            CompoundTag nbt;
            ModEventClientForge.renderHoloScannerSelectionBox(event);
            ItemStack item = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND);
            if (ModItems.getBlueprintItems().contains(item.getItem()) && (nbt = OldVersionUtilities.getItemStackNBT(item)).contains("inventari_blocco_selezionati")) {
                for (String pos : nbt.getString("inventari_blocco_selezionati").split("!;!")) {
                    if (pos.equals("")) continue;
                    Vec3i v_ = Operazioni.getVec3iFromString(pos);
                    Vec3 v = new Vec3((double)v_.getX(), (double)v_.getY(), (double)v_.getZ());
                    RenderingGraphics.renderBorderBox(event.getPoseStack(), event.getProjectionMatrix(), v, v, ModConfig.getContainerAreaColor(), 1.0f, (Boolean)ModConfig.SelectedContainerAreaTextureEnabled.get());
                }
            }
        } else if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            ObstructionBlockManager.render(OldVersionUtilities.getEventPosestack(), event.getProjectionMatrix(), event.getCamera());
        }
        event.getPoseStack().popPose();
    }

    private static void renderAnimazionePosizionamentoBlocco(RenderLevelStageEvent event) {
        ArrayList<AnimazionePosizionamentoBlocco> daRimuovere = new ArrayList<AnimazionePosizionamentoBlocco>();
        for (AnimazionePosizionamentoBlocco apb : AnimPosBlocks) {
            apb.render(event.getPoseStack());
            if (!apb.animazioneFinita) continue;
            daRimuovere.add(apb);
        }
        for (AnimazionePosizionamentoBlocco apb : daRimuovere) {
            AnimPosBlocks.remove(apb);
        }
    }

    public static void renderHoloScannerSelectionBox(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)ModItems.SCANNER.get())) {
            ItemStack item = player.getItemInHand(InteractionHand.MAIN_HAND);
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(item);
            boolean angolo1 = nbt.contains("angolo1") ? nbt.getBoolean("angolo1") : false;
            boolean angolo2 = nbt.contains("angolo2") ? nbt.getBoolean("angolo2") : false;
            boolean angoloFantasma = nbt.contains("angoloFantasma") ? nbt.getBoolean("angoloFantasma") : false;
            Vec3i i1 = null;
            Vec3i i2 = null;
            if (!angolo1 && angoloFantasma) {
                i2 = i1 = Operazioni.getVec3iFromString(nbt.getString("coordinateAngoloFantasma"));
            } else if (!angolo2 && angoloFantasma) {
                i1 = Operazioni.getVec3iFromString(nbt.getString("coordinateAngolo1"));
                i2 = Operazioni.getVec3iFromString(nbt.getString("coordinateAngoloFantasma"));
            } else if (angolo1 && angolo2) {
                i1 = Operazioni.getVec3iFromString(nbt.getString("coordinateAngolo1"));
                i2 = Operazioni.getVec3iFromString(nbt.getString("coordinateAngolo2"));
            }
            if (i1 != null && i2 != null) {
                Vec3 Vec3Angolo2 = new Vec3((double)i2.getX(), (double)i2.getY(), (double)i2.getZ());
                if (angolo1 && angolo2 && System.currentTimeMillis() >= inizioAnim) {
                    posNonFinita = null;
                    posPrima = Vec3.ZERO;
                    posTarget = Vec3.ZERO;
                } else if (angolo1) {
                    if (!posTarget.equals((Object)Vec3Angolo2)) {
                        posPrima = posNonFinita == null ? new Vec3((double)i1.getX(), (double)i1.getY(), (double)i1.getZ()) : posNonFinita;
                        posTarget = Vec3Angolo2;
                        inizioAnim = System.currentTimeMillis() + 300L;
                    }
                    float t = 1.0f;
                    if (inizioAnim - System.currentTimeMillis() <= 300L) {
                        t = 1.0f - (float)(inizioAnim - System.currentTimeMillis()) / 300.0f;
                    }
                    if (t <= 1.0f) {
                        posNonFinita = Vec3Angolo2 = Operazioni.lerp(posPrima, posTarget, (double)t);
                    }
                } else {
                    posNonFinita = null;
                }
                RenderingGraphics.renderBorderBox(event.getPoseStack(), event.getProjectionMatrix(), angolo1 ? new Vec3((double)i1.getX(), (double)i1.getY(), (double)i1.getZ()) : Vec3Angolo2, Vec3Angolo2, ModConfig.getScannerAreaColor(), 1.0f, (Boolean)ModConfig.ScanningAreaTextureEnabled.get());
                if (DirezioneHitboxSelected != null) {
                    ModEventClientForge.renderScannerShapeZone(new PoseStack(), new Vec3((double)i1.getX(), (double)i1.getY(), (double)i1.getZ()), Vec3Angolo2);
                }
            }
        }
    }

    private static void renderScannerShapeZone(PoseStack poseStack, Vec3 angolo1, Vec3 angolo2) {
        angolo2 = angolo2.add(1.0, 1.0, 1.0);
        AABB box = null;
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH)) {
            box = new AABB(angolo1, new Vec3(angolo2.x, angolo2.y, angolo1.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            box = new AABB(angolo2, new Vec3(angolo1.x, angolo1.y, angolo2.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            box = new AABB(angolo1, new Vec3(angolo1.x, angolo2.y, angolo2.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.EAST)) {
            box = new AABB(angolo2, new Vec3(angolo2.x, angolo1.y, angolo1.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            box = new AABB(angolo1, new Vec3(angolo2.x, angolo1.y, angolo2.z));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.UP)) {
            box = new AABB(angolo2, new Vec3(angolo1.x, angolo2.y, angolo1.z));
        }
        Vec3 colore = ModConfig.getScannerAreaColor();
        float r = (float)colore.x;
        float g = (float)colore.y;
        float b = (float)colore.z;
        float a = 0.8f;
        if (box == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        float minX = (float)(box.minX - view.x);
        float maxX = (float)(box.maxX - view.x);
        float minZ = (float)(box.minZ - view.z);
        float maxZ = (float)(box.maxZ - view.z);
        float maxY = (float)(box.maxY - view.y);
        float minY = (float)(box.minY - view.y);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.debugSectionQuads());
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH) || DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            buffer.addVertex(matrix, minX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.EAST) || DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, minY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.UP) || DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            buffer.addVertex(matrix, minX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, minZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, minX, maxY, maxZ).setColor(r, g, b, a);
            buffer.addVertex(matrix, maxX, maxY, maxZ).setColor(r, g, b, a);
        }
        bufferSource.endBatch();
    }

    @SubscribeEvent
    public static void playerEsceDalMondo(PlayerEvent.PlayerLoggedOutEvent event) {
        ClientMethods.Reset();
        offsetVisualizeBlueprint = BlockPos.ZERO;
        datiBlocchi.clear();
        TabletScreen.FirsOpen = true;
        StoC_SaveGlobalBlueprint.StaGiaGestendoUnaBlueprint = false;
        RenderBlueprintsPreview.doCleanUp();
        RenderScannerAnimation.resetAll();
    }

    @SubscribeEvent
    public static void playerEntraNelMondo(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null && !hasJoinedWorld) {
            hasJoinedWorld = true;
            Thread tickerThread = new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_RichiestaGamerule(510, CtoS_RichiestaGamerule.TipoRichiesta.ALLOW_GLOBAL_BLUEPRINTS), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SharedBlueprintData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_ServerBlueprintsData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            tickerThread.setDaemon(true);
            tickerThread.start();
        }
    }

    @SubscribeEvent
    public static void ScrollingMouseEvent(InputEvent.MouseScrollingEvent event) {
        boolean scrollAvanti;
        BlueprintEvent.ScrollingMouseEvent(event);
        ChangeShapeScanningAreaEvent.ScrollingMouseEvent(event);
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        ItemStack item = mc.player.getMainHandItem().copy();
        boolean bl = scrollAvanti = event.getScrollDeltaY() > 0.0;
        if (item.is((Item)ModItems.SCANNER.get())) {
            boolean isCtrlDown;
            boolean bl2 = isCtrlDown = InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)341) || InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)345);
            if (!isCtrlDown) {
                return;
            }
            int valore = Scanner.ScrollingDistanceAttuale + (scrollAvanti ? 1 : -1);
            if (valore > 100) {
                valore = 100;
            } else if (valore < 5) {
                valore = 5;
            }
            Scanner.ScrollingDistanceAttuale = valore;
            event.setCanceled(true);
        }
    }

    public static class ObstructionBlockManager {
        public static List<Tuple<Long, BlockPos>> Blocks = new ArrayList<Tuple<Long, BlockPos>>();
        private static VertexBuffer dynamicMesh = null;
        private static Long updateAfter = System.currentTimeMillis();
        private static boolean updated = true;

        public static void aggiungiBlocco(BlockPos pos) {
            boolean trovato = false;
            Tuple<Long, BlockPos> toRemove = null;
            for (Tuple<Long, BlockPos> data : Blocks) {
                if (!((BlockPos)data.getB()).equals((Object)pos)) continue;
                trovato = true;
                toRemove = data;
                break;
            }
            if (!trovato) {
                Blocks.add((Tuple<Long, BlockPos>)new Tuple((Object)(System.currentTimeMillis() + 60000L), (Object)pos));
                updateAfter = System.currentTimeMillis() + 100L;
                updated = false;
            } else {
                Blocks.remove(toRemove);
                Blocks.add((Tuple<Long, BlockPos>)new Tuple((Object)(System.currentTimeMillis() + 60000L), (Object)pos));
            }
        }

        private static void updateMesh() {
            if (dynamicMesh != null) {
                dynamicMesh.close();
            }
            BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            for (Tuple<Long, BlockPos> pos : Blocks) {
                ObstructionBlockManager.addCube(builder, (float)((BlockPos)pos.getB()).getX() - 0.0025f, (float)((BlockPos)pos.getB()).getY() - 0.0025f, (float)((BlockPos)pos.getB()).getZ() - 0.0025f, 1.005f, 255, 0, 0, 80);
            }
            MeshData meshData = builder.build();
            dynamicMesh = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            dynamicMesh.bind();
            if (meshData != null) {
                dynamicMesh.upload(meshData);
            } else {
                dynamicMesh = null;
            }
            VertexBuffer.unbind();
        }

        private static void addCube(BufferBuilder builder, float x, float y, float z, float size, int r, int g, int b, int a) {
            float x1 = x;
            float y1 = y;
            float z1 = z;
            float x2 = x + size;
            float y2 = y + size;
            float z2 = z + size;
            builder.addVertex(x1, y1, z2).setColor(r, g, b, a);
            builder.addVertex(x2, y1, z2).setColor(r, g, b, a);
            builder.addVertex(x2, y2, z2).setColor(r, g, b, a);
            builder.addVertex(x1, y2, z2).setColor(r, g, b, a);
            builder.addVertex(x2, y1, z1).setColor(r, g, b, a);
            builder.addVertex(x1, y1, z1).setColor(r, g, b, a);
            builder.addVertex(x1, y2, z1).setColor(r, g, b, a);
            builder.addVertex(x2, y2, z1).setColor(r, g, b, a);
            builder.addVertex(x1, y1, z1).setColor(r, g, b, a);
            builder.addVertex(x1, y1, z2).setColor(r, g, b, a);
            builder.addVertex(x1, y2, z2).setColor(r, g, b, a);
            builder.addVertex(x1, y2, z1).setColor(r, g, b, a);
            builder.addVertex(x2, y1, z2).setColor(r, g, b, a);
            builder.addVertex(x2, y1, z1).setColor(r, g, b, a);
            builder.addVertex(x2, y2, z1).setColor(r, g, b, a);
            builder.addVertex(x2, y2, z2).setColor(r, g, b, a);
            builder.addVertex(x1, y2, z2).setColor(r, g, b, a);
            builder.addVertex(x2, y2, z2).setColor(r, g, b, a);
            builder.addVertex(x2, y2, z1).setColor(r, g, b, a);
            builder.addVertex(x1, y2, z1).setColor(r, g, b, a);
            builder.addVertex(x1, y1, z1).setColor(r, g, b, a);
            builder.addVertex(x2, y1, z1).setColor(r, g, b, a);
            builder.addVertex(x2, y1, z2).setColor(r, g, b, a);
            builder.addVertex(x1, y1, z2).setColor(r, g, b, a);
        }

        public static void reset() {
            Blocks.clear();
            updateAfter = System.currentTimeMillis() + 100L;
            updated = false;
        }

        public static void render(PoseStack poseStack, Matrix4f projectMatrix4f, Camera camera) {
            if (dynamicMesh != null) {
                poseStack.pushPose();
                poseStack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
                RenderSystem.disableDepthTest();
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                dynamicMesh.bind();
                dynamicMesh.drawWithShader(poseStack.last().pose(), projectMatrix4f, RenderSystem.getShader());
                VertexBuffer.unbind();
                RenderSystem.enableDepthTest();
                poseStack.popPose();
                ArrayList<Tuple<Long, BlockPos>> toRemove = new ArrayList<Tuple<Long, BlockPos>>();
                for (Tuple<Long, BlockPos> tuple : Blocks) {
                    if (System.currentTimeMillis() <= (Long)tuple.getA() && !Minecraft.getInstance().player.level().getBlockState((BlockPos)tuple.getB()).getBlock().equals(net.minecraft.world.level.block.Blocks.AIR)) continue;
                    toRemove.add(tuple);
                }
                for (Tuple tuple : toRemove) {
                    Blocks.remove(tuple);
                }
                if (toRemove.size() > 0) {
                    updateAfter = System.currentTimeMillis() + 100L;
                    updated = false;
                }
            }
            if (!updated && System.currentTimeMillis() > updateAfter) {
                updated = true;
                ObstructionBlockManager.updateMesh();
            }
        }
    }

    public static class AnimazionePosizionamentoBlocco {
        public Vec3 posIniziale;
        public Vec3 posObbiettivo;
        public Item item;
        public Long EndTime;
        public boolean animazioneFinita = false;

        public AnimazionePosizionamentoBlocco(Item item, Long EndTime, Vec3 posIniziale, Vec3 posObbiettivo) {
            this.item = item;
            this.EndTime = EndTime;
            this.posIniziale = posIniziale;
            this.posObbiettivo = posObbiettivo;
        }

        public void render(PoseStack poseStack) {
            float time = 1.0f - (float)(this.EndTime - System.currentTimeMillis()) / 1000.0f;
            if (time > 1.0f) {
                time = 1.0f;
            }
            if (time < 0.0f) {
                time = 0.0f;
            }
            RenderingMethods.RenderItemInWorld(poseStack, Operazioni.lerp(this.posIniziale, this.posObbiettivo, (double)time), this.item, time < 0.25f ? 0.25f : time);
            if (System.currentTimeMillis() > this.EndTime) {
                this.animazioneFinita = true;
            }
        }
    }
}

