/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.network.CtoS_SaveGlobalBlueprintInServer;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;

@EventBusSubscriber
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        CtoS_SaveGlobalBlueprintInServer.resetPlayer(player.getUUID());
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer minecraftServer = event.getServer();
        ServerLevel level = minecraftServer.overworld();
        GameRules rules = level.getGameRules();
        if (ModServerConfig.enable_maxScannerBlockCount) {
            ((GameRules.IntegerValue)rules.getRule(ModGameRules.MaxScannerBlockCount)).set(ModServerConfig.maxScannerBlockCount, minecraftServer);
        }
    }
}

