/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import nimble.portable_blueprints.altro.CustomBlockProprietyHandle;
import nimble.portable_blueprints.altro.PlacingBlockManager;
import nimble.portable_blueprints.altro.ProgressBarBlueprintPlayer;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;
import nimble.portable_blueprints.mod_compatibility.projecte.ProjectEMetodi;
import nimble.portable_blueprints.network.CtoS_SaveGlobalBlueprintInServer;
import nimble.portable_blueprints.network.StoC_AnimazionePosizionamentoBlocco;
import nimble.portable_blueprints.network.StoC_ScannerAnimation;
import nimble.portable_blueprints.portable_blueprints.Mod;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.ModifiableItemInventory;
import nimble.portable_blueprints.robautile.Operazioni;

@EventBusSubscriber
public class Blueprint {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String extension = ".bp";
    public static final String extension_swm = ".swm";
    private static final int MAX_BLOCKS_FOR_TICK = 500;
    public static List<Block> ILLEGAL_BLOCK_IN_SURVIVAL = new ArrayList<Block>();
    private static List<BlueprintStructure> structureDaFare = new ArrayList<BlueprintStructure>();
    private static Map<BlueprintStartingData, BlueprintDatas> creazioneDati = new HashMap<BlueprintStartingData, BlueprintDatas>();

    public static void setup() {
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.BEDROCK);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.END_PORTAL);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.END_PORTAL_FRAME);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.NETHER_PORTAL);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.COMMAND_BLOCK);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.REPEATING_COMMAND_BLOCK);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.CHAIN_COMMAND_BLOCK);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.BARRIER);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.STRUCTURE_BLOCK);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.STRUCTURE_VOID);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.JIGSAW);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.LIGHT);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.MOVING_PISTON);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.FROSTED_ICE);
    }

    public static void CreateBlueprint(ServerLevel level, BlockPos angolo1, BlockPos angolo2, String nome, UUID richiedente, boolean consideraCreativeBlocks, List<String> ScannerIgnoredBlocks) {
        BlueprintStartingData bsd;
        BlockPos angoloIniziale = new BlockPos(angolo1.getX() < angolo2.getX() ? angolo1.getX() : angolo2.getX(), angolo1.getY() < angolo2.getY() ? angolo1.getY() : angolo2.getY(), angolo1.getZ() < angolo2.getZ() ? angolo1.getZ() : angolo2.getZ());
        BlockPos angoloFinale = new BlockPos(angolo1.getX() < angolo2.getX() ? angolo2.getX() : angolo1.getX(), angolo1.getY() < angolo2.getY() ? angolo2.getY() : angolo1.getY(), angolo1.getZ() < angolo2.getZ() ? angolo2.getZ() : angolo1.getZ());
        UUID uuidAnimazioneScanner = UUID.randomUUID();
        if (level.getPlayerByUUID(richiedente) != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)level.getPlayerByUUID(richiedente)), (CustomPacketPayload)new StoC_ScannerAnimation(uuidAnimazioneScanner, true, angoloIniziale, angoloFinale, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!creazioneDati.containsKey(bsd = new BlueprintStartingData(level, nome, angoloIniziale, angoloFinale, richiedente, consideraCreativeBlocks, ScannerIgnoredBlocks, uuidAnimazioneScanner))) {
            BlueprintDatas bd = new BlueprintDatas(nome);
            bd.setX(angoloFinale.getX() - angoloIniziale.getX() + 1);
            bd.setZ(angoloFinale.getZ() - angoloIniziale.getZ() + 1);
            bd.altezza = angoloFinale.getY() - angoloIniziale.getY() + 1;
            creazioneDati.put(bsd, bd);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        block78: {
            block77: {
                if (creazioneDati.isEmpty()) break block77;
                BlueprintStartingData key = null;
                Iterator<BlueprintStartingData> iterator = creazioneDati.keySet().iterator();
                if (iterator.hasNext()) {
                    BlueprintStartingData k;
                    key = k = iterator.next();
                }
                if (key.serverLevel.getPlayerByUUID(key.uuid) == null) {
                    creazioneDati.remove(key);
                    key = null;
                }
                if (key == null) break block78;
                int controllati = 0;
                while (key.posYControllata != key.angolo2.getY() + 1) {
                    while (key.posXControllata != key.angolo2.getX() + 1) {
                        while (key.posZControllata != key.angolo2.getZ() + 1 && controllati < 500) {
                            BlockPos position = new BlockPos(key.posXControllata, key.posYControllata, key.posZControllata);
                            BlockState blockState = key.serverLevel.getBlockState(position);
                            if (blockState.getBlock().equals(Blocks.BUBBLE_COLUMN)) {
                                blockState = Blocks.WATER.defaultBlockState();
                            }
                            if (!(blockState.is(Blocks.AIR) || !key.consideraCreativeBlocks && (key.consideraCreativeBlocks || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.getBlock())) || key.scannerIgnoredBlocks.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString()))) {
                                if (blockState.hasProperty((Property)BlockStateProperties.LEVEL)) {
                                    if (blockState.getBlock() instanceof LiquidBlock && (Integer)blockState.getValue((Property)BlockStateProperties.LEVEL) != 0) {
                                        ++key.posZControllata;
                                        ++controllati;
                                        continue;
                                    }
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.LEVEL_CAULDRON)) {
                                    blockState = blockState.getBlock().equals(Blocks.WATER_CAULDRON) || blockState.getBlock().equals(Blocks.LAVA_CAULDRON) ? Blocks.CAULDRON.defaultBlockState() : (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.LEVEL_COMPOSTER)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.LEVEL_FLOWING)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL_FLOWING, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.LEVEL_HONEY)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL_HONEY, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_1)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_1, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_2)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_3)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_4)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_4, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_5)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_7)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_15)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.hasProperty((Property)BlockStateProperties.AGE_25)) {
                                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_25, (Comparable)Integer.valueOf(0));
                                }
                                String nbt = "";
                                BlockEntity blockEntity = key.serverLevel.getBlockEntity(position);
                                if (blockEntity != null && key.serverLevel.getCapability(Capabilities.ItemHandler.BLOCK, position, (Object)Direction.NORTH) == null) {
                                    nbt = OldVersionUtilities.getAllComponentasAndNBTInJson(blockEntity);
                                }
                                if (!blockState.getPistonPushReaction().name().equals("DESTROY") && !blockState.getCollisionShape((BlockGetter)key.serverLevel, position).isEmpty()) {
                                    creazioneDati.get(key).addBlock(key.altezzaArrivato, Operazioni.getVec3iString(new Vec3i(key.posXControllata - key.angolo1.getX(), key.posYControllata - key.angolo1.getY(), key.posZControllata - key.angolo1.getZ())), Operazioni.getBlockStateString(blockState), nbt);
                                } else {
                                    creazioneDati.get(key).addNonSolidBlock(key.altezzaArrivato, Operazioni.getVec3iString(new Vec3i(key.posXControllata - key.angolo1.getX(), key.posYControllata - key.angolo1.getY(), key.posZControllata - key.angolo1.getZ())), Operazioni.getBlockStateString(blockState), nbt);
                                }
                            }
                            if (key.serverLevel.getPlayerByUUID(key.uuid) != null) {
                                if (!key.annullaAnimazioneScanner) {
                                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)key.serverLevel.getPlayerByUUID(key.uuid)), (CustomPacketPayload)new StoC_ScannerAnimation(key.uuidAnimazioneScanner, false, BlockPos.ZERO, BlockPos.ZERO, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                }
                            } else {
                                key.annullaAnimazioneScanner = true;
                            }
                            ++key.posZControllata;
                            ++controllati;
                        }
                        if (controllati >= 500) break;
                        ++key.posXControllata;
                        key.posZControllata = key.angolo1.getZ();
                    }
                    if (controllati >= 500) break;
                    ++key.posYControllata;
                    ++key.altezzaArrivato;
                    key.posXControllata = key.angolo1.getX();
                }
                if (controllati >= 500) break block78;
                File jsonFile = new File(Blueprint.getFileForBlueprints(key.serverLevel, key.uuid), key.nome + extension);
                try (FileWriter writer = new FileWriter(jsonFile);){
                    GSON.toJson((Object)creazioneDati.get(key), (Appendable)writer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (key.serverLevel.getPlayerByUUID(key.uuid) != null) {
                    key.serverLevel.getPlayerByUUID(key.uuid).displayClientMessage((Component)Component.literal((String)Component.translatable((String)"hotbar_message.portable_blueprints.blueprint_saved").getString().replace("%v%", key.nome)).withStyle(ChatFormatting.GREEN), true);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)key.serverLevel.getPlayerByUUID(key.uuid)), (CustomPacketPayload)new StoC_ScannerAnimation(key.uuidAnimazioneScanner, false, BlockPos.ZERO, BlockPos.ZERO, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                creazioneDati.remove(key);
                break block78;
            }
            if (structureDaFare.size() > 0) {
                ArrayList<BlueprintStructure> toRemove = new ArrayList<BlueprintStructure>();
                int nBlocchiArrivati = 0;
                boolean skip = false;
                for (BlueprintStructure bs : structureDaFare) {
                    if (skip) break;
                    if (!Blueprint.playerIsOnline(bs.owner)) {
                        toRemove.add(bs);
                        continue;
                    }
                    ArrayList<BlockPos> blocchiDaScartareDaEspansione = new ArrayList<BlockPos>();
                    for (BlockPos posBlocco : new ArrayList<BlockPos>(bs.posDiEspansione)) {
                        BlockPos newPos;
                        if (skip) break;
                        BlockState b = bs.serverLevel.getBlockState(Operazioni.SommaBlockPos(bs.bd.offset, posBlocco));
                        if (b.is(Blocks.AIR) || PlacingBlockManager.isRimpiazzabile(b)) {
                            if (bs.solidi && bs.bd.BlocksData.containsKey(posBlocco.getY()) && bs.bd.BlocksData.get(posBlocco.getY()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ())))) {
                                datiBlocco = bs.bd.BlocksData.get(posBlocco.getY()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ())));
                                bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                blockState = (datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equals("null") ? Operazioni.getBlockFromString(bloccoId).defaultBlockState() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                posizioneAnim = Vec3.ZERO;
                                item_trovato = false;
                                if (Blueprint.playerIsOnline(bs.owner)) {
                                    posizioneAnim = bs.owner.position().add(0.0, 1.0, 0.0);
                                    if (bs.free_build || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.getBlock()) && bs.owner.isCreative() || bs.owner.isSpectator()) {
                                        item_trovato = true;
                                    } else if (ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.getBlock())) {
                                        item_trovato = false;
                                    } else if (bs.owner.isCreative() || bs.owner.isSpectator() || blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && ((DoubleBlockHalf)blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER) || blockState.hasProperty((Property)BlockStateProperties.BED_PART) && ((BedPart)blockState.getValue((Property)BlockStateProperties.BED_PART)).equals((Object)BedPart.HEAD)) {
                                        item_trovato = true;
                                    } else {
                                        v = Blueprint.removeItemFromTheContainers((ServerPlayer)bs.owner, bs.serverLevel, bs.posizione_container, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem());
                                        if (!((Boolean)v.getA()).booleanValue() && bs.emc_active && ProjectEMetodi.removeEMCForItem((ServerPlayer)bs.owner, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem())) {
                                            item_trovato = true;
                                        } else {
                                            item_trovato = (Boolean)v.getA();
                                            posizioneAnim = (Vec3)v.getB();
                                        }
                                    }
                                } else {
                                    toRemove.add(bs);
                                    continue;
                                }
                                if (item_trovato) {
                                    if (!blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) || blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                                        p = Operazioni.SommaBlockPos(bs.bd.offset, posBlocco);
                                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StoC_AnimazionePosizionamentoBlocco(Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem(), System.currentTimeMillis() + 1000L, posizioneAnim, new Vec3((double)((float)p.getX() + 0.5f), (double)((float)p.getY() + 0.5f), (double)((float)p.getZ() + 0.5f))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                    }
                                    ProgressBarBlueprintPlayer.visualizza((ServerPlayer)bs.owner);
                                    nbt = bs.bd.BlocksNBT != null && bs.bd.BlocksNBT.containsKey(posBlocco.getY()) && bs.bd.BlocksNBT.get(posBlocco.getY()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ()))) ? bs.bd.BlocksNBT.get(posBlocco.getY()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ()))) : "";
                                    PlacingBlockManager.addNewPlaceBlock(bs.serverLevel, Operazioni.SommaBlockPos(bs.bd.offset, posBlocco), blockState, nbt, bs.allow_nbt, 1000L, bs.owner);
                                }
                            } else if (!bs.solidi && bs.bd.NotSolidBlocksData.containsKey(posBlocco.getY()) && bs.bd.NotSolidBlocksData.get(posBlocco.getY()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ())))) {
                                datiBlocco = bs.bd.NotSolidBlocksData.get(posBlocco.getY()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ())));
                                bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                blockState = (datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equals("null") ? Operazioni.getBlockFromString(bloccoId).defaultBlockState() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                posizioneAnim = Vec3.ZERO;
                                item_trovato = false;
                                if (Blueprint.playerIsOnline(bs.owner)) {
                                    posizioneAnim = bs.owner.position().add(0.0, 1.0, 0.0);
                                    if (bs.free_build || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.getBlock()) && bs.owner.isCreative() || bs.owner.isSpectator()) {
                                        item_trovato = true;
                                    } else if (ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.getBlock())) {
                                        item_trovato = false;
                                    } else if (bs.owner.isCreative() || bs.owner.isSpectator() || blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && ((DoubleBlockHalf)blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER) || blockState.hasProperty((Property)BlockStateProperties.BED_PART) && ((BedPart)blockState.getValue((Property)BlockStateProperties.BED_PART)).equals((Object)BedPart.HEAD)) {
                                        item_trovato = true;
                                    } else {
                                        v = Blueprint.removeItemFromTheContainers((ServerPlayer)bs.owner, bs.serverLevel, bs.posizione_container, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem());
                                        if (!((Boolean)v.getA()).booleanValue() && bs.emc_active && ProjectEMetodi.removeEMCForItem((ServerPlayer)bs.owner, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem())) {
                                            item_trovato = true;
                                        } else {
                                            item_trovato = (Boolean)v.getA();
                                            posizioneAnim = (Vec3)v.getB();
                                        }
                                    }
                                } else {
                                    toRemove.add(bs);
                                    continue;
                                }
                                if (item_trovato) {
                                    if (!blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) || blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                                        p = Operazioni.SommaBlockPos(bs.bd.offset, posBlocco);
                                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StoC_AnimazionePosizionamentoBlocco(Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem(), System.currentTimeMillis() + 1000L, posizioneAnim, new Vec3((double)((float)p.getX() + 0.5f), (double)((float)p.getY() + 0.5f), (double)((float)p.getZ() + 0.5f))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                    }
                                    ProgressBarBlueprintPlayer.visualizza((ServerPlayer)bs.owner);
                                    nbt = bs.bd.BlocksNBT != null && bs.bd.BlocksNBT.containsKey(posBlocco.getY()) && bs.bd.BlocksNBT.get(posBlocco.getY()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ()))) ? bs.bd.BlocksNBT.get(posBlocco.getY()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ()))) : "";
                                    PlacingBlockManager.addNewPlaceBlock(bs.serverLevel, Operazioni.SommaBlockPos(bs.bd.offset, posBlocco), blockState, nbt, bs.allow_nbt, 1000L, bs.owner);
                                }
                            }
                        } else if (Blueprint.playerIsOnline(bs.owner) && (bs.solidi && bs.bd.BlocksData.containsKey(posBlocco.getY()) && bs.bd.BlocksData.get(posBlocco.getY()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ()))) || !bs.solidi && bs.bd.NotSolidBlocksData.containsKey(posBlocco.getY()) && bs.bd.NotSolidBlocksData.get(posBlocco.getY()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.getX(), posBlocco.getY(), posBlocco.getZ()))))) {
                            ProgressBarBlueprintPlayer.visualizza((ServerPlayer)bs.owner);
                        }
                        if (posBlocco.getX() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(-1, 0, 0)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.getZ() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(0, 0, -1)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.getY() + 1 < bs.bd.altezza && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(0, 1, 0)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.getX() - 1 >= 0 && posBlocco.getZ() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(-1, 0, -1)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        blocchiDaScartareDaEspansione.add(posBlocco);
                        if (++nBlocchiArrivati < 500) continue;
                        skip = true;
                    }
                    for (BlockPos posDelet : blocchiDaScartareDaEspansione) {
                        bs.posDiEspansione.remove(posDelet);
                    }
                    if (bs.solidi && bs.posDiEspansione.size() == 0) {
                        bs.solidi = false;
                        bs.posDiEspansione.add(new BlockPos(bs.bd.lunghezzaX - 1, 0, bs.bd.lunghezzaZ - 1));
                    }
                    if (bs.posDiEspansione != null && bs.posDiEspansione.size() != 0) continue;
                    toRemove.add(bs);
                }
                for (BlueprintStructure b : toRemove) {
                    structureDaFare.remove(b);
                }
            }
        }
    }

    private static boolean playerIsOnline(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.getServer().getPlayerList().getPlayer(serverPlayer.getUUID()) != null;
        }
        return false;
    }

    public static File getFileForBlueprints(ServerLevel level, UUID uuid) {
        File CartellaMod = new File(level.getServer().getWorldPath(LevelResource.ROOT).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, uuid.toString())).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static boolean BlueprintExist(ServerLevel level, String nome, UUID richiedente) {
        File cartella = Blueprint.getFileForBlueprints(level, richiedente);
        for (File child : cartella.listFiles()) {
            if (!child.getName().equals(nome + extension)) continue;
            return true;
        }
        return false;
    }

    public static void RimuoviBlueprint(ServerLevel level, ServerPlayer player, String nome) {
        SharedWithMe swm = Blueprint.getSharedBlueprints(level, player.getUUID());
        for (UUID shared_with : swm.getAllSpecificSWOBPlayersUUID(nome)) {
            Blueprint.removeSharedBlueprint(level, nome, player.getUUID(), shared_with);
        }
        for (File f : Blueprint.getFileForBlueprints(level, player.getUUID()).listFiles()) {
            if (!f.getName().equals(nome + extension)) continue;
            f.delete();
            break;
        }
    }

    public static void CreaItemBlueprintEDaiAGiocatore(ServerPlayer player, UUID owner, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        boolean added;
        ItemStack blueprint = nome.contains("[Global]") ? new ItemStack((ItemLike)ModItems.GLOBAL_BLUEPRINT.get(), 1) : new ItemStack((ItemLike)ModItems.BLUEPRINT.get(), 1);
        Item item = blueprint.getItem();
        if (item instanceof nimble.portable_blueprints.items.Blueprint) {
            nimble.portable_blueprints.items.Blueprint blueprintItem = (nimble.portable_blueprints.items.Blueprint)item;
            blueprintItem.setBlueprint(blueprint, player, owner, nome, altezza, lunghezzaX, lunghezzaZ);
        }
        if (!(added = player.getInventory().add(blueprint))) {
            player.sendSystemMessage((Component)Component.translatable((String)"system.portable_blueprints.inv_full"), true);
        }
    }

    public static void CreaItemServerBlueprintEDaiAGiocatore(ServerPlayer player, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        boolean added;
        ItemStack blueprint = new ItemStack((ItemLike)ModItems.SERVER_BLUEPRINT.get(), 1);
        Item item = blueprint.getItem();
        if (item instanceof nimble.portable_blueprints.items.Blueprint) {
            nimble.portable_blueprints.items.Blueprint blueprintItem = (nimble.portable_blueprints.items.Blueprint)item;
            blueprintItem.setServerBlueprint(blueprint, nome, altezza, lunghezzaX, lunghezzaZ);
        }
        if (!(added = player.getInventory().add(blueprint))) {
            player.sendSystemMessage((Component)Component.translatable((String)"system.portable_blueprints.inv_full"), true);
        }
    }

    public static void AggiungiStructureAllaCoda(ServerLevel level, BlueprintDatas bd, Player player, List<BlockPos> posizione_container, boolean free_build, short allow_nbt, boolean emc_active) {
        if (!structureDaFare.contains(new BlueprintStructure(level, bd, player, posizione_container, free_build, allow_nbt, emc_active))) {
            structureDaFare.add(new BlueprintStructure(level, bd, player, posizione_container, free_build, allow_nbt, emc_active));
            ProgressBarBlueprintPlayer.creaProgressBar((ServerPlayer)player, bd.getAllBlocksCount());
        }
    }

    public static Map<Item, Integer> getAllItemQuantityFromInventory(ServerPlayer player, ServerLevel level, List<BlockPos> posizioniContainer) {
        HashMap<Item, Integer> ItemQuantity = new HashMap<Item, Integer>();
        for (ItemStack item : player.getInventory().items) {
            if (ItemQuantity.containsKey(item.getItem())) {
                ItemQuantity.replace(item.getItem(), (Integer)ItemQuantity.get(item.getItem()) + item.getCount());
            } else {
                ItemQuantity.put(item.getItem(), item.getCount());
            }
            ModifiableItemInventory.of(level, item).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.getContainerSize(); ++x) {
                    ItemStack itemStack = container.getItem(x);
                    if (ItemQuantity.containsKey(itemStack.getItem())) {
                        ItemQuantity.replace(itemStack.getItem(), (Integer)ItemQuantity.get(itemStack.getItem()) + itemStack.getCount() * item.getCount());
                        continue;
                    }
                    ItemQuantity.put(itemStack.getItem(), itemStack.getCount() * item.getCount());
                }
            });
        }
        for (ItemStack armorItem : player.getInventory().armor) {
            if (ItemQuantity.containsKey(armorItem.getItem())) {
                ItemQuantity.replace(armorItem.getItem(), (Integer)ItemQuantity.get(armorItem.getItem()) + armorItem.getCount());
            } else {
                ItemQuantity.put(armorItem.getItem(), armorItem.getCount());
            }
            ModifiableItemInventory.of(level, armorItem).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.getContainerSize(); ++x) {
                    ItemStack itemStack = container.getItem(x);
                    if (ItemQuantity.containsKey(itemStack.getItem())) {
                        ItemQuantity.replace(itemStack.getItem(), (Integer)ItemQuantity.get(itemStack.getItem()) + itemStack.getCount() * armorItem.getCount());
                        continue;
                    }
                    ItemQuantity.put(itemStack.getItem(), itemStack.getCount() * armorItem.getCount());
                }
            });
        }
        for (BlockPos posizione : posizioniContainer) {
            IItemHandler handler;
            BlockEntity be = level.getBlockEntity(posizione);
            if (be == null || (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, posizione, be.getBlockState(), be, (Object)Direction.DOWN)) == null) continue;
            for (int x = 0; x < handler.getSlots(); ++x) {
                ItemStack item = handler.getStackInSlot(x);
                if (ItemQuantity.containsKey(item.getItem())) {
                    ItemQuantity.replace(item.getItem(), (Integer)ItemQuantity.get(item.getItem()) + item.getCount());
                } else {
                    ItemQuantity.put(item.getItem(), item.getCount());
                }
                ModifiableItemInventory.of(level, item).ifPresent(inv -> {
                    Container container_item = inv.getContainer();
                    for (int xItem = 0; xItem < container_item.getContainerSize(); ++xItem) {
                        ItemStack itemStack = container_item.getItem(xItem);
                        if (ItemQuantity.containsKey(itemStack.getItem())) {
                            ItemQuantity.replace(itemStack.getItem(), (Integer)ItemQuantity.get(itemStack.getItem()) + itemStack.getCount() * item.getCount());
                            continue;
                        }
                        ItemQuantity.put(itemStack.getItem(), itemStack.getCount() * item.getCount());
                    }
                });
            }
        }
        return ItemQuantity;
    }

    public static Tuple<Boolean, Vec3> removeItemFromTheContainers(ServerPlayer player, ServerLevel level, List<BlockPos> posizioniContainer, Item Target) {
        AtomicReference v;
        for (ItemStack item : player.getInventory().items) {
            if (item.getItem().equals(Target)) {
                if (item.getItem().equals(Items.WATER_BUCKET) || item.getItem().equals(Items.LAVA_BUCKET)) {
                    item.setCount(item.getCount() - 1);
                    int item_rimasti = Operazioni.addItemToInventory(player.getInventory(), new ItemStack((ItemLike)Items.BUCKET), 1);
                    if (item_rimasti > 0) {
                        Operazioni.dropItem((Level)level, player.position(), new ItemStack((ItemLike)Items.BUCKET));
                    }
                } else {
                    item.setCount(item.getCount() - 1);
                }
                return new Tuple((Object)true, (Object)player.position().add(0.0, 1.0, 0.0));
            }
            v = new AtomicReference();
            ModifiableItemInventory.of(level, item).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.getContainerSize(); ++x) {
                    ItemStack itemStack = container.getItem(x);
                    if (!itemStack.getItem().equals(Target)) continue;
                    if (itemStack.getItem().equals(Items.WATER_BUCKET) || itemStack.getItem().equals(Items.LAVA_BUCKET)) {
                        itemStack.setCount(itemStack.getCount() - 1);
                        int item_rimasti = Operazioni.addItemToInventory(player.getInventory(), new ItemStack((ItemLike)Items.BUCKET), 1);
                        if (item_rimasti > 0) {
                            Operazioni.dropItem((Level)level, player.position(), new ItemStack((ItemLike)Items.BUCKET));
                        }
                    } else {
                        itemStack.setCount(itemStack.getCount() - 1);
                    }
                    v.set(new Tuple((Object)true, (Object)player.position().add(0.0, 1.0, 0.0)));
                }
                inv.save();
            });
            if (v.get() == null) continue;
            return (Tuple)v.get();
        }
        for (ItemStack armorItem : player.getInventory().armor) {
            if (armorItem.getItem().equals(Target)) {
                if (armorItem.getItem().equals(Items.WATER_BUCKET) || armorItem.getItem().equals(Items.LAVA_BUCKET)) {
                    armorItem.setCount(armorItem.getCount() - 1);
                    int item_rimasti = Operazioni.addItemToInventory(player.getInventory(), new ItemStack((ItemLike)Items.BUCKET), 1);
                    if (item_rimasti > 0) {
                        Operazioni.dropItem((Level)level, player.position(), new ItemStack((ItemLike)Items.BUCKET));
                    }
                } else {
                    armorItem.setCount(armorItem.getCount() - 1);
                }
                return new Tuple((Object)true, (Object)player.position().add(0.0, 1.0, 0.0));
            }
            v = new AtomicReference();
            ModifiableItemInventory.of(level, armorItem).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.getContainerSize(); ++x) {
                    ItemStack itemStack = container.getItem(x);
                    if (!itemStack.getItem().equals(Target)) continue;
                    if (itemStack.getItem().equals(Items.WATER_BUCKET) || itemStack.getItem().equals(Items.LAVA_BUCKET)) {
                        itemStack.setCount(itemStack.getCount() - 1);
                        int item_rimasti = Operazioni.addItemToInventory(player.getInventory(), new ItemStack((ItemLike)Items.BUCKET), 1);
                        if (item_rimasti > 0) {
                            Operazioni.dropItem((Level)level, player.position(), new ItemStack((ItemLike)Items.BUCKET));
                        }
                    } else {
                        itemStack.setCount(itemStack.getCount() - 1);
                    }
                    v.set(new Tuple((Object)true, (Object)player.position().add(0.0, 1.0, 0.0)));
                }
                inv.save();
            });
            if (v.get() == null) continue;
            return (Tuple)v.get();
        }
        for (BlockPos posizione : posizioniContainer) {
            BlockEntity be = level.getBlockEntity(posizione);
            if (be == null) continue;
            AtomicReference<Tuple> v2 = new AtomicReference<Tuple>();
            IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, posizione, be.getBlockState(), be, (Object)Direction.DOWN);
            if (handler != null) {
                for (int x = 0; x < handler.getSlots(); ++x) {
                    ItemStack item = handler.getStackInSlot(x);
                    if (item.getItem().equals(Target)) {
                        if (item.getItem().equals(Items.WATER_BUCKET) || item.getItem().equals(Items.LAVA_BUCKET)) {
                            item.setCount(item.getCount() - 1);
                            int item_rimasti = Operazioni.addItemToInventory(player.getInventory(), new ItemStack((ItemLike)Items.BUCKET), 1);
                            if (item_rimasti > 0) {
                                Operazioni.dropItem((Level)level, player.position(), new ItemStack((ItemLike)Items.BUCKET));
                            }
                        } else {
                            item.setCount(item.getCount() - 1);
                        }
                        v2.set(new Tuple((Object)true, (Object)posizione.getCenter()));
                        continue;
                    }
                    ModifiableItemInventory.of(level, item).ifPresent(inv -> {
                        Container container_item = inv.getContainer();
                        for (int xItem = 0; xItem < container_item.getContainerSize(); ++xItem) {
                            ItemStack itemStack = container_item.getItem(xItem);
                            if (!itemStack.getItem().equals(Target)) continue;
                            if (itemStack.getItem().equals(Items.WATER_BUCKET) || itemStack.getItem().equals(Items.LAVA_BUCKET)) {
                                itemStack.setCount(itemStack.getCount() - 1);
                                int item_rimasti = Operazioni.addItemToInventory(player.getInventory(), new ItemStack((ItemLike)Items.BUCKET), 1);
                                if (item_rimasti > 0) {
                                    Operazioni.dropItem((Level)level, player.position(), new ItemStack((ItemLike)Items.BUCKET));
                                }
                            } else {
                                itemStack.setCount(itemStack.getCount() - 1);
                            }
                            v2.set(new Tuple((Object)true, (Object)player.position().add(0.0, 1.0, 0.0)));
                        }
                        inv.save();
                    });
                }
            }
            if (v2.get() == null) continue;
            return (Tuple)v2.get();
        }
        return new Tuple((Object)false, (Object)Vec3.ZERO);
    }

    public static SharedWithMe getSharedBlueprints(ServerLevel level, UUID uuid) {
        File FileShared = Blueprint.getSharedFile(level, uuid);
        SharedWithMe swm = new SharedWithMe();
        try {
            swm = (SharedWithMe)GSON.fromJson((Reader)new FileReader(FileShared), SharedWithMe.class);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return swm;
    }

    public static void addSharedBlueprint(ServerLevel serverLevel, String nome, UUID creatoreRichiesta, UUID ricevente) {
        if (Blueprint.BlueprintExist(serverLevel, nome, creatoreRichiesta)) {
            FileWriter writer;
            SharedWithMe swm = Blueprint.getSharedBlueprints(serverLevel, creatoreRichiesta);
            swm.addSharedWithOthersBlueprint(ricevente, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, creatoreRichiesta));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            swm = Blueprint.getSharedBlueprints(serverLevel, ricevente);
            swm.addSharedWithMeBlueprint(creatoreRichiesta, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, ricevente));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeSharedBlueprint(ServerLevel serverLevel, String nome, UUID creatoreRichiesta, UUID ricevente) {
        if (Blueprint.BlueprintExist(serverLevel, nome, creatoreRichiesta)) {
            FileWriter writer;
            SharedWithMe swm = Blueprint.getSharedBlueprints(serverLevel, creatoreRichiesta);
            swm.removeSharedWithOthersBlueprint(ricevente, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, creatoreRichiesta));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            swm = Blueprint.getSharedBlueprints(serverLevel, ricevente);
            swm.removeSharedWithMeBlueprint(creatoreRichiesta, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, ricevente));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getSharedFile(ServerLevel serverLevel, UUID target) {
        String file;
        File CartellaMod = new File(serverLevel.getServer().getWorldPath(LevelResource.ROOT).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "shared")).exists()) {
            CartellaMod.mkdir();
        }
        if (!new File(CartellaMod, file = target.toString() + extension_swm).exists()) {
            SharedWithMe swm = new SharedWithMe();
            File jsonFile = new File(CartellaMod, file);
            try (FileWriter writer = new FileWriter(jsonFile);){
                GSON.toJson((Object)swm, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(CartellaMod, file);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static File getGlobalBlueprintDir() {
        File CartellaMod = new File(Minecraft.getInstance().gameDirectory, "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean globalBlueprintExist(String nome) {
        return new File(Blueprint.getGlobalBlueprintDir(), nome + extension).exists();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getGlobalBlueprintsQuantity() {
        int x = 0;
        for (File file : Blueprint.getGlobalBlueprintDir().listFiles()) {
            if (!file.getName().contains(extension)) continue;
            ++x;
        }
        return x;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<String> getAllGlobalBlueprintsName() {
        ArrayList<String> nomi = new ArrayList<String>();
        for (File file : Blueprint.getGlobalBlueprintDir().listFiles()) {
            if (!file.getName().contains(extension)) continue;
            nomi.add(file.getName().replace(extension, ""));
        }
        return nomi;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeGlobalBlueprint(String nome) {
        File f = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
        if (f.exists()) {
            f.delete();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlueprintDatas getGlobalBlueprintClass(String nome) {
        File f = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
        if (f.exists()) {
            try {
                return (BlueprintDatas)GSON.fromJson((Reader)new FileReader(f), BlueprintDatas.class);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServerGlobalBlueprint(String nome) {
        if (ClientMethods.SendingGlobalBlueprintToServer) {
            return;
        }
        Thread tickerThread = new Thread(() -> {
            try {
                Thread.sleep(50L);
                int QuantityBlocksMax = ClientMethods.getRichiestaInteger(507);
                BlueprintDatas bdc = Blueprint.getGlobalBlueprintClass(nome);
                boolean puoMandarlo = false;
                if (bdc != null) {
                    if (bdc.getAllBlocksCount() <= QuantityBlocksMax) {
                        if (ClientMethods.getQuantitaFileBlueprint() < ClientMethods.getRichiestaInteger(508)) {
                            puoMandarlo = true;
                        } else {
                            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"chat_message.portable_blueprints.global_bp_quantity_limit").withStyle(ChatFormatting.RED), false);
                        }
                    } else {
                        Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"chat_message.portable_blueprints.global_bp_blocks_limit").withStyle(ChatFormatting.RED), false);
                    }
                }
                if (puoMandarlo) {
                    ClientMethods.SendingGlobalBlueprintToServer = true;
                    File bd = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
                    if (bd.exists()) {
                        String bd_string_datas = new String(Files.readAllBytes(bd.toPath()));
                        String id_richiesta = UUID.randomUUID().toString();
                        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SaveGlobalBlueprintInServer("[INIZIO DATI BLUEPRINT <id>" + id_richiesta + "</id><nome>" + nome + "</nome>"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SaveGlobalBlueprintInServer("[NOME DEL FILE:" + nome), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        for (String val : Operazioni.splitStringByLength(bd_string_datas, 10000)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SaveGlobalBlueprintInServer("[" + id_richiesta + "]" + val), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            Thread.sleep(10L);
                        }
                        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SaveGlobalBlueprintInServer("[FINE DATI BLUEPRINT DI ID: " + id_richiesta + "]"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ClientMethods.SendingGlobalBlueprintToServer = false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ClientMethods.SendingGlobalBlueprintToServer = false;
            }
        });
        tickerThread.setDaemon(true);
        tickerThread.start();
    }

    public static File getServerBlueprintFile(ServerLevel serverLevel) {
        File CartellaMod = new File(serverLevel.getServer().getWorldPath(LevelResource.ROOT).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "server")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static File getWornBlueprintFile(ServerLevel serverLevel) {
        File CartellaMod = new File(serverLevel.getServer().getWorldPath(LevelResource.ROOT).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "worn blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static File getServerPremissionFile(ServerLevel serverLevel) {
        String file;
        File CartellaMod = new File(serverLevel.getServer().getWorldPath(LevelResource.ROOT).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "server")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "permission")).exists()) {
            CartellaMod.mkdir();
        }
        if (!new File(CartellaMod, file = "permissions.settings").exists()) {
            BlueprintPermission bp = new BlueprintPermission();
            File jsonFile = new File(CartellaMod, file);
            try (FileWriter writer = new FileWriter(jsonFile);){
                GSON.toJson((Object)bp, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(CartellaMod, file);
    }

    private static class BlueprintStartingData {
        public BlockPos angolo1;
        public BlockPos angolo2;
        public String nome;
        public ServerLevel serverLevel;
        public UUID uuid;
        public int posXControllata;
        public int posYControllata;
        public int posZControllata;
        public int altezzaArrivato = 0;
        public boolean consideraCreativeBlocks = false;
        public List<String> scannerIgnoredBlocks;
        public boolean annullaAnimazioneScanner = false;
        public UUID uuidAnimazioneScanner;

        public BlueprintStartingData(ServerLevel serverLevel, String nome, BlockPos angolo1, BlockPos angolo2, UUID uuid, boolean consideraCreativeBlocks, List<String> scannerIgnoredBlocks, UUID uuidAnimazioneScanner) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.nome = nome;
            this.serverLevel = serverLevel;
            this.uuid = uuid;
            this.posXControllata = angolo1.getX();
            this.posYControllata = angolo1.getY();
            this.posZControllata = angolo1.getZ();
            this.consideraCreativeBlocks = consideraCreativeBlocks;
            this.scannerIgnoredBlocks = scannerIgnoredBlocks;
            this.uuidAnimazioneScanner = uuidAnimazioneScanner;
        }
    }

    public static class BlueprintDatas {
        public String nome = "";
        public int altezza = 0;
        public int lunghezzaX = 0;
        public int lunghezzaZ = 0;
        public BlockPos offset = new BlockPos(0, 0, 0);
        public Map<Integer, Map<String, String>> BlocksData = new HashMap<Integer, Map<String, String>>();
        public Map<Integer, Map<String, String>> NotSolidBlocksData = new HashMap<Integer, Map<String, String>>();
        public Map<Integer, Map<String, String>> BlocksNBT = new HashMap<Integer, Map<String, String>>();

        public BlueprintDatas(String NOME) {
            this.nome = NOME;
        }

        public void addBlock(int altezza, String posDalOrigine, String blocco, String nbt) {
            if (BlueprintDatas.ServerBlackListBlock(blocco) || BlueprintDatas.controlloBlocchiModdati(blocco)) {
                return;
            }
            if (this.BlocksData.containsKey(altezza)) {
                this.BlocksData.get(altezza).put(posDalOrigine, blocco);
            } else {
                this.BlocksData.put(altezza, new HashMap());
                this.BlocksData.get(altezza).put(posDalOrigine, blocco);
            }
            if (!nbt.isEmpty()) {
                if (this.BlocksNBT != null && this.BlocksNBT.containsKey(altezza)) {
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                } else {
                    this.BlocksNBT.put(altezza, new HashMap());
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                }
            }
        }

        public void addNonSolidBlock(int altezza, String posDalOrigine, String blocco, String nbt) {
            if (BlueprintDatas.ServerBlackListBlock(blocco) || BlueprintDatas.controlloBlocchiModdati(blocco)) {
                return;
            }
            if (this.NotSolidBlocksData.containsKey(altezza)) {
                this.NotSolidBlocksData.get(altezza).put(posDalOrigine, blocco);
            } else {
                this.NotSolidBlocksData.put(altezza, new HashMap());
                this.NotSolidBlocksData.get(altezza).put(posDalOrigine, blocco);
            }
            if (!nbt.isEmpty()) {
                if (this.BlocksNBT != null && this.BlocksNBT.containsKey(altezza)) {
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                } else {
                    this.BlocksNBT.put(altezza, new HashMap());
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                }
            }
        }

        public void setX(int x) {
            this.lunghezzaX = x;
        }

        public void setZ(int z) {
            this.lunghezzaZ = z;
        }

        public List<String> getBlocksDataByAltezza(int altezza) {
            ArrayList<String> bs = new ArrayList<String>();
            for (String pos : this.BlocksData.get(altezza).keySet()) {
                String valore = this.BlocksData.get(altezza).get(pos);
                bs.add(valore);
            }
            return bs;
        }

        public List<String> getBlocksPosByAltezza(int altezza) {
            ArrayList<String> bs = new ArrayList<String>();
            for (String pos : this.BlocksData.get(altezza).keySet()) {
                bs.add(pos);
            }
            return bs;
        }

        public int getAllBlocksCount() {
            int count = 0;
            for (int v = 0; v < 2; ++v) {
                for (Integer altezza : v == 0 ? this.BlocksData.keySet() : this.NotSolidBlocksData.keySet()) {
                    count += v == 0 ? this.BlocksData.get(altezza).size() : this.NotSolidBlocksData.get(altezza).size();
                }
            }
            return count;
        }

        public BlueprintDatas rotate(short rot) {
            BlueprintDatas ruotato = new BlueprintDatas(this.nome);
            ruotato.altezza = this.altezza;
            if (rot == 1 || rot == 3) {
                ruotato.lunghezzaZ = this.lunghezzaX;
                ruotato.lunghezzaX = this.lunghezzaZ;
            } else {
                ruotato.lunghezzaZ = this.lunghezzaZ;
                ruotato.lunghezzaX = this.lunghezzaX;
            }
            for (int v = 0; v < 2; ++v) {
                for (Map.Entry<Integer, Map<String, String>> posizione_e_blocco : v == 0 ? this.BlocksData.entrySet() : this.NotSolidBlocksData.entrySet()) {
                    Map<String, String> innerMap = posizione_e_blocco.getValue();
                    for (Map.Entry<String, String> dati_blocco : innerMap.entrySet()) {
                        String nbt;
                        BlockPos pos = new BlockPos(Operazioni.getVec3iFromString(dati_blocco.getKey()));
                        String blockdata = dati_blocco.getValue();
                        String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
                        if (!(blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equalsIgnoreCase("null")) {
                            BlockState state = Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockdata);
                            Tuple<Boolean, BlockState> val = BlueprintDatas.setCustomBlockProprietyRotate(bloccoId, state, (short)rot);
                            if (((Boolean)val.getA()).booleanValue()) {
                                state = (BlockState)val.getB();
                            } else {
                                if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                                    state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Operazioni.rotateFacing((Direction)state.getValue((Property)BlockStateProperties.FACING), rot));
                                } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                                    state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Operazioni.rotateFacing((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), rot));
                                }
                                if ((rot == 1 || rot == 3) && state.hasProperty((Property)BlockStateProperties.AXIS)) {
                                    if (((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)).equals((Object)Direction.Axis.X)) {
                                        state = (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
                                    } else if (((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)).equals((Object)Direction.Axis.Z)) {
                                        state = (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
                                    }
                                }
                                for (int g = 0; g < rot; ++g) {
                                    boolean n = false;
                                    boolean s = false;
                                    boolean e = false;
                                    boolean w = false;
                                    if (state.hasProperty((Property)BlockStateProperties.SOUTH) && ((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
                                        w = true;
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.NORTH) && ((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
                                        e = true;
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.WEST) && ((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
                                        n = true;
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.EAST) && ((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
                                        s = true;
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.NORTH)) {
                                        state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(n));
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.SOUTH)) {
                                        state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(s));
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.EAST)) {
                                        state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(e));
                                    }
                                    if (!state.hasProperty((Property)BlockStateProperties.WEST)) continue;
                                    state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(w));
                                }
                                if (state.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
                                    int rotazione_attuale_cartello = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16) + rot * 4;
                                    if (rotazione_attuale_cartello >= 16) {
                                        rotazione_attuale_cartello -= 16;
                                    }
                                    state = (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotazione_attuale_cartello));
                                }
                            }
                            blockdata = Operazioni.getBlockStateString(state);
                        } else {
                            blockdata = dati_blocco.getValue();
                        }
                        String string = nbt = this.BlocksNBT != null && this.BlocksNBT.containsKey(pos.getY()) && this.BlocksNBT.get(pos.getY()).containsKey(dati_blocco.getKey()) ? this.BlocksNBT.get(pos.getY()).get(dati_blocco.getKey()) : "";
                        if (rot == 0) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.getX(), pos.getY(), pos.getZ())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.getX(), pos.getY(), pos.getZ())), blockdata, nbt);
                            continue;
                        }
                        if (rot == 1) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaZ - 1 - pos.getZ(), pos.getY(), pos.getX())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaZ - 1 - pos.getZ(), pos.getY(), pos.getX())), blockdata, nbt);
                            continue;
                        }
                        if (rot == 2) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaX - 1 - pos.getX(), pos.getY(), this.lunghezzaZ - 1 - pos.getZ())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaX - 1 - pos.getX(), pos.getY(), this.lunghezzaZ - 1 - pos.getZ())), blockdata, nbt);
                            continue;
                        }
                        if (rot != 3) continue;
                        if (v == 0) {
                            ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.getZ(), pos.getY(), this.lunghezzaX - 1 - pos.getX())), blockdata, nbt);
                            continue;
                        }
                        ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.getZ(), pos.getY(), this.lunghezzaX - 1 - pos.getX())), blockdata, nbt);
                    }
                }
            }
            return ruotato;
        }

        public BlueprintDatas Mirrow(boolean Mx, boolean My, boolean Mz) {
            BlueprintDatas mirrow = new BlueprintDatas(this.nome);
            mirrow.altezza = this.altezza;
            mirrow.lunghezzaZ = this.lunghezzaZ;
            mirrow.lunghezzaX = this.lunghezzaX;
            for (int v = 0; v < 2; ++v) {
                for (Map.Entry<Integer, Map<String, String>> posizione_e_blocco : v == 0 ? this.BlocksData.entrySet() : this.NotSolidBlocksData.entrySet()) {
                    Map<String, String> innerMap = posizione_e_blocco.getValue();
                    for (Map.Entry<String, String> dati_blocco : innerMap.entrySet()) {
                        String nbt;
                        BlockPos pos = new BlockPos(Operazioni.getVec3iFromString(dati_blocco.getKey()));
                        String blockdata = dati_blocco.getValue();
                        String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
                        blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "");
                        if (Mx) {
                            pos = new BlockPos(this.lunghezzaX - 1 - pos.getX(), pos.getY(), pos.getZ());
                        }
                        if (Mz) {
                            pos = new BlockPos(pos.getX(), pos.getY(), this.lunghezzaZ - 1 - pos.getZ());
                        }
                        if (My) {
                            pos = new BlockPos(pos.getX(), this.altezza - 1 - pos.getY(), pos.getZ());
                        }
                        if (!blockdata.equalsIgnoreCase("null")) {
                            BlockState state = Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockdata);
                            Tuple<Boolean, BlockState> val = BlueprintDatas.setCustomBlockProprietyMirrow(bloccoId, state, Mx, My, Mz);
                            if (((Boolean)val.getA()).booleanValue()) {
                                state = (BlockState)val.getB();
                            } else {
                                boolean suXFatta = false;
                                boolean suYFatta = false;
                                boolean suZFatta = false;
                                for (int statesTime = 0; statesTime < 3; ++statesTime) {
                                    if (statesTime == 0 && !Mx || statesTime == 1 && !My || statesTime == 2 && !Mz) continue;
                                    if (statesTime == 0) {
                                        suXFatta = true;
                                        suYFatta = false;
                                        suZFatta = false;
                                    } else if (statesTime == 1) {
                                        suXFatta = false;
                                        suYFatta = true;
                                        suZFatta = false;
                                    } else if (statesTime == 2) {
                                        suXFatta = false;
                                        suYFatta = false;
                                        suZFatta = true;
                                    }
                                    if (suYFatta && state.hasProperty((Property)BlockStateProperties.ATTACH_FACE)) {
                                        switch ((AttachFace)state.getValue((Property)BlockStateProperties.ATTACH_FACE)) {
                                            case FLOOR: {
                                                state = (BlockState)state.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING);
                                                break;
                                            }
                                            case CEILING: {
                                                state = (BlockState)state.setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR);
                                            }
                                        }
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                                        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                                        if (dir.equals((Object)Direction.NORTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH);
                                        } else if (dir.equals((Object)Direction.EAST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST);
                                        } else if (dir.equals((Object)Direction.SOUTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH);
                                        } else if (dir.equals((Object)Direction.WEST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST);
                                        } else if (dir.equals((Object)Direction.UP)) {
                                            if (!suYFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
                                        } else if (dir.equals((Object)Direction.DOWN)) {
                                            if (!suYFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP);
                                        }
                                    } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                                        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                                        if (dir.equals((Object)Direction.NORTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH);
                                        } else if (dir.equals((Object)Direction.EAST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST);
                                        } else if (dir.equals((Object)Direction.SOUTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
                                        } else if (dir.equals((Object)Direction.WEST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST);
                                        }
                                    }
                                    boolean n = false;
                                    boolean s = false;
                                    boolean e = false;
                                    boolean w = false;
                                    if (!suYFatta) {
                                        if (suZFatta) {
                                            if (state.hasProperty((Property)BlockStateProperties.SOUTH) && ((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
                                                s = false;
                                                n = true;
                                            }
                                            if (state.hasProperty((Property)BlockStateProperties.NORTH) && ((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
                                                n = false;
                                                s = true;
                                            }
                                            if (state.hasProperty((Property)BlockStateProperties.EAST)) {
                                                e = (Boolean)state.getValue((Property)BlockStateProperties.EAST);
                                            }
                                            if (state.hasProperty((Property)BlockStateProperties.WEST)) {
                                                w = (Boolean)state.getValue((Property)BlockStateProperties.WEST);
                                            }
                                        } else if (suXFatta) {
                                            if (state.hasProperty((Property)BlockStateProperties.EAST) && ((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
                                                e = false;
                                                w = true;
                                            }
                                            if (state.hasProperty((Property)BlockStateProperties.WEST) && ((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
                                                w = false;
                                                e = true;
                                            }
                                            if (state.hasProperty((Property)BlockStateProperties.NORTH)) {
                                                n = (Boolean)state.getValue((Property)BlockStateProperties.NORTH);
                                            }
                                            if (state.hasProperty((Property)BlockStateProperties.SOUTH)) {
                                                s = (Boolean)state.getValue((Property)BlockStateProperties.SOUTH);
                                            }
                                        }
                                        if (state.hasProperty((Property)BlockStateProperties.NORTH)) {
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(n));
                                        }
                                        if (state.hasProperty((Property)BlockStateProperties.SOUTH)) {
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(s));
                                        }
                                        if (state.hasProperty((Property)BlockStateProperties.EAST)) {
                                            state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(e));
                                        }
                                        if (!state.hasProperty((Property)BlockStateProperties.WEST)) continue;
                                        state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(w));
                                        continue;
                                    }
                                    if (state.hasProperty((Property)BlockStateProperties.HALF)) {
                                        state = (BlockState)state.setValue((Property)BlockStateProperties.HALF, (Comparable)(((Half)state.getValue((Property)BlockStateProperties.HALF)).equals((Object)Half.BOTTOM) ? Half.TOP : Half.BOTTOM));
                                    }
                                    if (!state.hasProperty((Property)BlockStateProperties.SLAB_TYPE)) continue;
                                    state = (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(((SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE)).equals((Object)SlabType.BOTTOM) ? SlabType.TOP : SlabType.BOTTOM));
                                }
                            }
                            blockdata = Operazioni.getBlockStateString(state);
                        } else {
                            blockdata = dati_blocco.getValue();
                        }
                        String string = nbt = this.BlocksNBT != null && this.BlocksNBT.containsKey(pos.getY()) && this.BlocksNBT.get(pos.getY()).containsKey(dati_blocco.getKey()) ? this.BlocksNBT.get(pos.getY()).get(dati_blocco.getKey()) : "";
                        if (v == 0) {
                            mirrow.addBlock(pos.getY(), Operazioni.getVec3iString(new Vec3i(pos.getX(), pos.getY(), pos.getZ())), blockdata, nbt);
                            continue;
                        }
                        mirrow.addNonSolidBlock(pos.getY(), Operazioni.getVec3iString(new Vec3i(pos.getX(), pos.getY(), pos.getZ())), blockdata, nbt);
                    }
                }
            }
            return mirrow;
        }

        public static boolean controlloBlocchiModdati(String blockdata) {
            String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
            String idMod = bloccoId.split(":")[0];
            String proprieta = blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "");
            if (proprieta.equals("null")) {
                return false;
            }
            proprieta = proprieta.replace("<properties>", "").replace("</properties>", "");
            for (String v : proprieta.split(";!v!;")) {
                if (v.equals("")) continue;
                String nome = v.substring(v.indexOf("<name>") + 6, v.indexOf("</name>"));
                String valore = v.substring(v.indexOf("<value>") + 7, v.indexOf("</value>"));
                if (!idMod.equals("dramaticdoors") || !nome.equals("third") || valore.equals("lower")) continue;
                return true;
            }
            return false;
        }

        public static boolean ServerBlackListBlock(String blockdata) {
            String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
            return ModServerConfig.blacklistBlock.contains(bloccoId);
        }

        private static boolean respectCondition(Map<String, Tuple<String, Property>> proprietaBlocco, String condition) {
            String[] condizioni;
            for (String condizione : condizioni = condition.split(",")) {
                String[] data = condizione.split("=");
                if (proprietaBlocco.containsKey(data[0]) && ((String)proprietaBlocco.get(data[0]).getA()).equalsIgnoreCase(data[1])) continue;
                return false;
            }
            return true;
        }

        public static Tuple<Boolean, BlockState> setCustomBlockProprietyRotate(String bloccoID, BlockState blockState, short rot) {
            boolean contieneBloccoID = false;
            try {
                if (CustomBlockProprietyHandle.Rotate.RULES.containsKey(bloccoID)) {
                    contieneBloccoID = true;
                    List<CustomBlockProprietyHandle.Rotate.Rule> rules = CustomBlockProprietyHandle.Rotate.RULES.get(bloccoID);
                    HashMap<String, Tuple<String, Property>> proprietaBlocco = new HashMap<String, Tuple<String, Property>>();
                    for (Property p : blockState.getProperties()) {
                        proprietaBlocco.put(p.getName(), new Tuple((Object)blockState.getValue(p).toString(), (Object)p));
                    }
                    for (CustomBlockProprietyHandle.Rotate.Rule rule : rules) {
                        if (rule.getRot() != rot) continue;
                        for (CustomBlockProprietyHandle.Rotate.PropertyRule pr : rule.properties) {
                            if (!BlueprintDatas.respectCondition(proprietaBlocco, pr.condition)) continue;
                            for (CustomBlockProprietyHandle.Rotate.PropertyValue propertyValue : pr.result) {
                                blockState = Operazioni.setDynamicProperty(blockState, (Property)((Tuple)proprietaBlocco.get(propertyValue.name)).getB(), propertyValue.value);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Mod.LOGGER.error("[Portable Blueprints] -> Custom block rotation propriety error!");
                Mod.LOGGER.error(e.getMessage());
            }
            return new Tuple((Object)contieneBloccoID, (Object)blockState);
        }

        public static Tuple<Boolean, BlockState> setCustomBlockProprietyMirrow(String bloccoID, BlockState blockState, boolean mirrowX, boolean mirrowY, boolean mirrowZ) {
            boolean contieneBloccoID = false;
            try {
                if (CustomBlockProprietyHandle.Mirrow.RULES.containsKey(bloccoID)) {
                    contieneBloccoID = true;
                    List<CustomBlockProprietyHandle.Mirrow.Rule> rules = CustomBlockProprietyHandle.Mirrow.RULES.get(bloccoID);
                    for (CustomBlockProprietyHandle.Mirrow.Rule rule : rules) {
                        if (!(rule.mirrow.equals((Object)Direction.Axis.X) && mirrowX || rule.mirrow.equals((Object)Direction.Axis.Y) && mirrowY) && (!rule.mirrow.equals((Object)Direction.Axis.Z) || !mirrowZ)) continue;
                        HashMap<String, Tuple<String, Property>> proprietaBlocco = new HashMap<String, Tuple<String, Property>>();
                        for (Property p : blockState.getProperties()) {
                            proprietaBlocco.put(p.getName(), (Tuple<String, Property>)new Tuple((Object)blockState.getValue(p).toString(), (Object)p));
                        }
                        for (CustomBlockProprietyHandle.Mirrow.PropertyRule pr : rule.properties) {
                            if (!BlueprintDatas.respectCondition(proprietaBlocco, pr.condition)) continue;
                            for (CustomBlockProprietyHandle.Mirrow.PropertyValue propertyValue : pr.result) {
                                blockState = Operazioni.setDynamicProperty(blockState, (Property)((Tuple)proprietaBlocco.get(propertyValue.name)).getB(), propertyValue.value);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Mod.LOGGER.error("[Portable Blueprints] -> Custom block mirrow propriety error!");
                Mod.LOGGER.error(e.getMessage());
            }
            return new Tuple((Object)contieneBloccoID, (Object)blockState);
        }
    }

    private static class BlueprintStructure {
        public List<BlockPos> posDiEspansione = new ArrayList<BlockPos>();
        public boolean solidi = true;
        public ServerLevel serverLevel;
        public BlueprintDatas bd;
        public List<BlockPos> posizione_container;
        public Player owner;
        public boolean free_build;
        public short allow_nbt = (short)-1;
        public boolean emc_active = false;

        public BlueprintStructure(ServerLevel serverLevel, BlueprintDatas bd, Player player, List<BlockPos> posizione_container, boolean free_build, short allow_nbt, boolean emc_active) {
            this.serverLevel = serverLevel;
            this.owner = player;
            this.bd = bd;
            this.posizione_container = posizione_container;
            this.free_build = free_build;
            this.allow_nbt = allow_nbt;
            if (ModCompatibilityInit.isProjectELoaded) {
                this.emc_active = emc_active;
            }
            this.posDiEspansione.add(new BlockPos(bd.lunghezzaX - 1, 0, bd.lunghezzaZ - 1));
        }
    }

    public static class SharedWithMe {
        public List<String> SharedWithOthersBlueprints = new ArrayList<String>();
        public List<String> SharedWithMeBlueprints = new ArrayList<String>();

        public void addSharedWithMeBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            String dato = "<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>";
            if (!this.SharedWithMeBlueprints.contains(dato)) {
                this.SharedWithMeBlueprints.add(dato);
            }
        }

        public void removeSharedWithMeBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            String dato = "<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>";
            if (this.SharedWithMeBlueprints.contains(dato)) {
                this.SharedWithMeBlueprints.remove(dato);
            }
        }

        public void addSharedWithOthersBlueprint(UUID PlayerAQuiVaIlBlueprint, String NomeBlueprint) {
            String dato = "<shared_with>" + PlayerAQuiVaIlBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>";
            if (!this.SharedWithOthersBlueprints.contains(dato)) {
                this.SharedWithOthersBlueprints.add(dato);
            }
        }

        public void removeSharedWithOthersBlueprint(UUID PlayerAQuiVaIlBlueprint, String NomeBlueprint) {
            String dato = "<shared_with>" + PlayerAQuiVaIlBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>";
            if (this.SharedWithOthersBlueprints.contains(dato)) {
                this.SharedWithOthersBlueprints.remove(dato);
            }
        }

        public boolean ContieneSWMBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            return this.SharedWithMeBlueprints.contains("<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>");
        }

        public boolean ContieneSWOBlueprint(UUID PlayerConQuiCondivideBlueprint, String NomeBlueprint) {
            return this.SharedWithOthersBlueprints.contains("<shared_with>" + PlayerConQuiCondivideBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>");
        }

        public List<UUID> getAllSpecificSWOBPlayersUUID(String nome_blueprint) {
            ArrayList<UUID> trovati = new ArrayList<UUID>();
            for (String v : this.SharedWithOthersBlueprints) {
                if (!Operazioni.getValueInsideTag(v, "name").equals(nome_blueprint)) continue;
                trovati.add(UUID.fromString(Operazioni.getValueInsideTag(v, "shared_with")));
            }
            return trovati;
        }
    }

    public static class BlueprintPermission {
        public Map<String, Boolean> BlueprintsPermissionSetup = new HashMap<String, Boolean>();
        public Map<UUID, List<String>> PlayerPermission = new HashMap<UUID, List<String>>();

        public void addServerBlueprintPermission(String nome, boolean isFree) {
            this.BlueprintsPermissionSetup.put(nome, isFree);
        }

        public void removeServerBlueprintPermission(String nome) {
            this.BlueprintsPermissionSetup.remove(nome);
            for (UUID uuid : this.PlayerPermission.keySet()) {
                ArrayList<String> remValues = new ArrayList<String>();
                for (String permission : this.PlayerPermission.get(uuid)) {
                    if (!permission.contains("<name>" + nome + "</name>")) continue;
                    remValues.add(permission);
                }
                for (String remove : remValues) {
                    this.PlayerPermission.get(uuid).remove(remove);
                }
            }
        }

        public void setPermissionForPlayer(ServerPlayer player, String nome, boolean hasPermission) {
            if (!this.BlueprintsPermissionSetup.containsKey(nome)) {
                return;
            }
            if (!this.PlayerPermission.containsKey(player.getUUID())) {
                this.PlayerPermission.put(player.getUUID(), new ArrayList());
            }
            if (this.PlayerPermission.get(player.getUUID()).contains("<name>" + nome + "</name><permission>false</permission>")) {
                this.PlayerPermission.get(player.getUUID()).remove("<name>" + nome + "</name><permission>false</permission>");
            }
            if (this.PlayerPermission.get(player.getUUID()).contains("<name>" + nome + "</name><permission>true</permission>")) {
                this.PlayerPermission.get(player.getUUID()).remove("<name>" + nome + "</name><permission>true</permission>");
            }
            this.PlayerPermission.get(player.getUUID()).add("<name>" + nome + "</name><permission>" + hasPermission + "</permission>");
        }

        public List<String> getPlayerAllAllowedBlueprints(UUID player) {
            ArrayList<String> bps = new ArrayList<String>();
            for (String nome : this.BlueprintsPermissionSetup.keySet()) {
                if (!this.BlueprintsPermissionSetup.get(nome).booleanValue() && (!this.PlayerPermission.containsKey(player) || !this.PlayerPermission.get(player).contains("<name>" + nome + "</name><permission>true</permission>"))) continue;
                bps.add(nome);
            }
            return bps;
        }
    }
}

