/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import nimble.portable_blueprints.portable_blueprints.Mod;

@EventBusSubscriber
public class CustomBlockProprietyHandle {
    private static final Gson GSON = new Gson();
    private static String rotateInterno = "/assets/portable_blueprints/settings/blueprint_rotation_settings.json";
    private static String mirrowInterno = "/assets/portable_blueprints/settings/blueprint_mirrow_settings.json";
    private static final String DirUtente = "config/portable_blueprints/custom_block_propriety_handle";

    @SubscribeEvent
    public static void load(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        Path worldDir = server.getWorldPath(LevelResource.ROOT);
        Path CBPHWorldDir = worldDir.resolve("portable_blueprints/custom_block_propriety_handle");
        Path modpackCBPHSourceDir = FMLPaths.GAMEDIR.get().resolve(DirUtente);
        CustomBlockProprietyHandle.creaDirectoryConFileSetting();
        try {
            File[] WorldCBPHFiles;
            Files.createDirectories(CBPHWorldDir, new FileAttribute[0]);
            for (File file : WorldCBPHFiles = CBPHWorldDir.toFile().listFiles((dir, name) -> name.toLowerCase().endsWith(".json"))) {
                try {
                    if (!file.getName().equals("rotation_settings.json") && !file.getName().equals("mirrow_settings.json")) continue;
                    file.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try (Stream<Path> files = Files.walk(modpackCBPHSourceDir, new FileVisitOption[0]);){
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.toString().endsWith(".json")).forEach(f -> {
                    Path target = CBPHWorldDir.resolve(f.getFileName());
                    try {
                        Files.copy(f, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, List<Rotate.Rule>> modRules = new HashMap<String, List<Rotate.Rule>>();
        try (InputStream in = CustomBlockProprietyHandle.class.getResourceAsStream(rotateInterno);){
            if (in == null) {
                throw new IOException("Internal Rotation Settings File not found!");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Rotate.Rule>>>(){}.getType();
                modRules = (Map)GSON.fromJson((Reader)reader, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map userRules = new HashMap();
        File userFile = CBPHWorldDir.resolve("rotation_settings.json").toFile();
        if (userFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(userFile, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Rotate.Rule>>>(){}.getType();
                userRules = (Map)GSON.fromJson((Reader)reader, type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Rotate.RULES = modRules;
        if (userRules != null && !userRules.isEmpty()) {
            for (String key : userRules.keySet()) {
                if (Rotate.RULES.containsKey(key)) {
                    Rotate.RULES.replace(key, (List)userRules.get(key));
                    continue;
                }
                Rotate.RULES.put(key, (List)userRules.get(key));
            }
        }
        Map<String, List<Mirrow.Rule>> modMirrowRules = new HashMap<String, List<Mirrow.Rule>>();
        try (InputStream in = CustomBlockProprietyHandle.class.getResourceAsStream(mirrowInterno);){
            if (in == null) {
                throw new IOException("Internal Mirrow Settings File not found!");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Mirrow.Rule>>>(){}.getType();
                modMirrowRules = (Map)GSON.fromJson((Reader)reader, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map userMirrowRules = new HashMap();
        File userMirrowFile = CBPHWorldDir.resolve("mirrow_settings.json").toFile();
        if (userMirrowFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(userMirrowFile, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Mirrow.Rule>>>(){}.getType();
                userMirrowRules = (Map)GSON.fromJson((Reader)reader, type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Mirrow.RULES = modMirrowRules;
        if (userMirrowRules != null && !userMirrowRules.isEmpty()) {
            for (String key : userMirrowRules.keySet()) {
                if (Mirrow.RULES.containsKey(key)) {
                    Mirrow.RULES.replace(key, (List)userMirrowRules.get(key));
                    continue;
                }
                Mirrow.RULES.put(key, (List)userMirrowRules.get(key));
            }
        }
        System.out.println(Rotate.RULES);
    }

    public static void creaDirectoryConFileSetting() {
        block19: {
            FileWriter writer;
            Path modpackBpSourceDir;
            block18: {
                modpackBpSourceDir = FMLPaths.GAMEDIR.get().resolve(DirUtente);
                try {
                    Files.createDirectories(modpackBpSourceDir, new FileAttribute[0]);
                    File WorldCustomBlockProprietyHandleRotation = new File(modpackBpSourceDir.toFile(), "rotation_settings.json");
                    if (WorldCustomBlockProprietyHandleRotation.exists()) break block18;
                    try {
                        writer = new FileWriter(WorldCustomBlockProprietyHandleRotation);
                        try {
                            writer.write("//Introduction to using Custom Block Property Handle Rotation:\n");
                            writer.write("//Here you can modify the final result of any blocks you want during blueprint rotation.\n");
                            writer.write("//Warning: once you add any block here, it will no longer be affected by the automatic rotation handled by the mod!\n");
                            writer.write("//The mod already includes an internal file like this, but any block you define here will override the internal one and take priority. (Priority order is always: user settings > mod default)\n");
                            writer.write("//For details on how to use this file, please refer to the wiki on the mod\u2019s GitHub: https://github.com/Nimblonia/Mod_Portable_blueprint_Community/discussions/17\n");
                            writer.write("{}");
                        }
                        finally {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        Mod.LOGGER.error("[Portable blueprint] -> Create rotation_settings.json File error:");
                        Mod.LOGGER.error(e.getMessage());
                    }
                }
                catch (Exception e) {
                    Mod.LOGGER.error("[Portable blueprint] -> Create rotation_settings.json File error:");
                    Mod.LOGGER.error(e.getMessage());
                }
            }
            try {
                Files.createDirectories(modpackBpSourceDir, new FileAttribute[0]);
                File WorldCustomBlockProprietyHandleMirrow = new File(modpackBpSourceDir.toFile(), "mirrow_settings.json");
                if (WorldCustomBlockProprietyHandleMirrow.exists()) break block19;
                try {
                    writer = new FileWriter(WorldCustomBlockProprietyHandleMirrow);
                    try {
                        writer.write("//Introduction to using Custom Block Property Handle Mirrow:\n");
                        writer.write("//Here you can modify the final result of any blocks you want during blueprint XYZ mirroring.\n");
                        writer.write("//Warning: once you add any block here, it will no longer be affected by the automatic XYZ mirroring handled by the mod!\n");
                        writer.write("//The mod already includes an internal file like this, but any block you define here will override the internal one and take priority. (Priority order is always: user settings > mod default)\n");
                        writer.write("//For details on how to use this file, please refer to the wiki on the mod\u2019s GitHub: https://github.com/Nimblonia/Mod_Portable_blueprint_Community/discussions/17\n");
                        writer.write("{}");
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    Mod.LOGGER.error("[Portable blueprint] -> Create mirrow_settings.json File error:");
                    Mod.LOGGER.error(e.getMessage());
                }
            }
            catch (Exception e) {
                Mod.LOGGER.error("[Portable blueprint] -> Create mirrow_settings.json File error:");
                Mod.LOGGER.error(e.getMessage());
            }
        }
    }

    public static class Rotate {
        public static Map<String, List<Rule>> RULES = new HashMap<String, List<Rule>>();

        public static class PropertyValue {
            public String name;
            public String value;
        }

        public static class PropertyRule {
            public String condition;
            public List<PropertyValue> result = new ArrayList<PropertyValue>();
        }

        public static class Rule {
            public short rotation;
            public List<PropertyRule> properties;

            public short getRot() {
                return this.rotation;
            }
        }
    }

    public static class Mirrow {
        public static Map<String, List<Rule>> RULES = new HashMap<String, List<Rule>>();

        public static class PropertyValue {
            public String name;
            public String value;
        }

        public static class PropertyRule {
            public String condition;
            public List<PropertyValue> result = new ArrayList<PropertyValue>();
        }

        public static class Rule {
            public Direction.Axis mirrow;
            public List<PropertyRule> properties;
        }
    }
}

