/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;

@EventBusSubscriber
public class PlacingBlockManager {
    public static final List<PlaceBlock> PlaceBlocks = Collections.synchronizedList(new ArrayList());
    private static ScheduledExecutorService scheduler;

    @SubscribeEvent
    public static void onServerStarted(ServerStartingEvent event) {
        if (scheduler == null || scheduler.isShutdown() || scheduler.isTerminated()) {
            scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.scheduleAtFixedRate(() -> {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null || server.isStopped()) {
                    return;
                }
                long now = System.currentTimeMillis();
                ArrayList<PlaceBlock> toPlace = new ArrayList<PlaceBlock>();
                List<PlaceBlock> list = PlaceBlocks;
                synchronized (list) {
                    Iterator<PlaceBlock> iterator = PlaceBlocks.iterator();
                    while (iterator.hasNext()) {
                        PlaceBlock pb = iterator.next();
                        if (!pb.canPlaceNow(now)) continue;
                        toPlace.add(pb);
                        iterator.remove();
                    }
                }
                if (!toPlace.isEmpty()) {
                    server.execute(() -> {
                        for (PlaceBlock pb : toPlace) {
                            pb.placeNow();
                        }
                    });
                }
            }, 0L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdownNow();
            scheduler = null;
        }
        PlaceBlocks.clear();
    }

    public static ScheduledExecutorService getScheduler() {
        return scheduler;
    }

    public static void addNewPlaceBlock(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, String nbt, short allow_nbt, long delay, Player owner) {
        if (blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        PlaceBlocks.add(new PlaceBlock(serverLevel, blockPos, blockState, nbt, allow_nbt, delay, owner));
    }

    public static boolean isRimpiazzabile(BlockState blockState) {
        return blockState.getBlock().equals(Blocks.AIR) || blockState.canBeReplaced() || blockState.getPistonPushReaction().equals((Object)PushReaction.DESTROY);
    }

    public static boolean droppaBloccoRimpiazzabile(ServerLevel serverLevel, BlockPos pos) {
        BlockState blockState = serverLevel.getBlockState(pos);
        if (blockState.getBlock().equals(Blocks.AIR)) {
            return true;
        }
        if (PlacingBlockManager.isRimpiazzabile(blockState)) {
            Block.dropResources((BlockState)blockState, (LevelAccessor)serverLevel, (BlockPos)pos, (BlockEntity)serverLevel.getBlockEntity(pos));
            return true;
        }
        return false;
    }

    private static void placeBlockContext(ServerLevel level, BlockPos pos, BlockState desiredState, Player owner) {
        Block block = desiredState.getBlock();
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (!(item instanceof BlockItem)) {
            System.err.println("Impossibile piazzare come BlockItem. " + String.valueOf(item));
            PlacingBlockManager.placeNormal(level, pos, desiredState);
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        ItemStack stack = new ItemStack((ItemLike)block);
        Direction clickedFace = Direction.UP;
        BlockPlaceContext context = new BlockPlaceContext((Level)level, owner, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), clickedFace, pos, false)){

            public boolean canPlace() {
                return true;
            }

            public boolean isInside() {
                return false;
            }
        };
        InteractionResult result = blockItem.place(context);
        if (result.consumesAction()) {
            BlockState placed = level.getBlockState(pos);
            if (placed.getBlock() == block) {
                BlockState finalState = PlacingBlockManager.copyBlockStateProperties(desiredState, placed);
                level.setBlock(pos, finalState, 3);
            }
        } else {
            PlacingBlockManager.placeNormal(level, pos, desiredState);
        }
    }

    private static void placeNormal(ServerLevel serverLevel, BlockPos pos, BlockState desiredState) {
        serverLevel.setBlock(pos, desiredState, 3);
        serverLevel.updateNeighborsAt(pos, desiredState.getBlock());
        if (desiredState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && desiredState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER && PlacingBlockManager.droppaBloccoRimpiazzabile(serverLevel, pos.above())) {
            BlockState upperState = (BlockState)desiredState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
            BlockPos upperPos = pos.above();
            serverLevel.setBlock(upperPos, upperState, 3);
            serverLevel.updateNeighborsAt(upperPos, upperState.getBlock());
        }
    }

    public static BlockState copyBlockStateProperties(BlockState from, BlockState to) {
        for (Property property : from.getProperties()) {
            if (!to.hasProperty(property)) continue;
            to = PlacingBlockManager.setPropertySafe(to, property, from.getValue(property));
        }
        return to;
    }

    private static <T extends Comparable<T>> BlockState setPropertySafe(BlockState state, Property<T> property, Comparable<?> value) {
        try {
            return (BlockState)state.setValue(property, (Comparable)property.getValueClass().cast(value));
        }
        catch (Exception e) {
            return state;
        }
    }

    public static class PlaceBlock {
        public final ServerLevel serverLevel;
        public final BlockPos blockPos;
        public final BlockState blockState;
        public final long placeAtMillis;
        public final String nbt;
        public final short allow_nbt;
        public final Player owner;

        public PlaceBlock(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, String nbt, short allow_nbt, long delayMillis, Player owner) {
            this.serverLevel = serverLevel;
            this.blockPos = blockPos;
            this.blockState = blockState;
            this.placeAtMillis = System.currentTimeMillis() + delayMillis;
            this.allow_nbt = allow_nbt;
            this.owner = owner;
            this.nbt = nbt;
        }

        public boolean canPlaceNow(long now) {
            return now >= this.placeAtMillis;
        }

        public void placeNow() {
            try {
                if (this.serverLevel != null) {
                    if (PlacingBlockManager.droppaBloccoRimpiazzabile(this.serverLevel, this.blockPos)) {
                        BlockEntity be;
                        PlacingBlockManager.placeBlockContext(this.serverLevel, this.blockPos, this.blockState, this.owner);
                        if ((this.allow_nbt == 1 || this.allow_nbt == -1 && this.serverLevel.getGameRules().getBoolean(ModGameRules.AllowNBTDataCopy)) && !this.nbt.isEmpty() && (be = this.serverLevel.getBlockEntity(this.blockPos)) != null) {
                            Tuple<DataComponentMap, CompoundTag> vals = OldVersionUtilities.convertJsonToDataComponentMapAndNBT(this.nbt);
                            if (!((DataComponentMap)vals.getA()).isEmpty()) {
                                be.setComponents((DataComponentMap)vals.getA());
                            }
                            if (!((CompoundTag)vals.getB()).isEmpty()) {
                                be.loadWithComponents((CompoundTag)vals.getB(), (HolderLookup.Provider)this.serverLevel.registryAccess());
                            }
                            be.setChanged();
                            this.serverLevel.sendBlockUpdated(this.blockPos, this.blockState, this.blockState, 3);
                        }
                    } else {
                        Block.popResource((Level)this.serverLevel, (BlockPos)this.blockPos, (ItemStack)Operazioni.getCorrectItemStackFromId(this.blockState.getBlock()));
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Placement Block Error!");
                e.printStackTrace();
            }
        }
    }
}

