/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.client.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.network.PacketDistributor;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.client.VisualizeBlueprintDatas;
import nimble.portable_blueprints.network.CtoS_CreateBlueprint;
import nimble.portable_blueprints.network.controllo_esiste_blueprint.CtoS_BlueprintExist;
import nimble.portable_blueprints.network.ottieni_quantita_blueprint.CtoS_BlueprintQuantity;
import nimble.portable_blueprints.network.richiesta_contenuto.CtoS_RichiestaGamerule;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.AdvancedButton;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingMethods;

public class ScannerScreen
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"textures/gui/scanner_gui.png");
    private int CentroX;
    private int CentroY;
    private int W;
    private int H;
    private final ItemStack item;
    private EditBox editBox;
    private AdvancedButton confirmButton;
    private AdvancedButton SettingsButton;
    private AdvancedButton BackButton;
    private AdvancedButton CHECKBOX_CREATIVE_BLOCKS;
    private RenderingMethods.GuiGraphicsElement Label;
    private RenderingMethods.GuiGraphicsElement TestoPulsante;
    private String valoreEditBox = "";
    private int nBlueprintSalvati = -1;
    private int quantitaBlocchi = -1;
    private boolean initFinito = false;
    public static final String CharNonConsentiti = " .,;'[]{}<>:\"/\\|?*\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f";
    private boolean settingsOpen = false;
    public static boolean SETTINGS_CREATIVE_BLOCKS = false;

    protected ScannerScreen(Component component) {
        super(component);
        this.item = null;
    }

    public ScannerScreen(ItemStack item, int quantitaBlocchi) {
        super((Component)Component.empty());
        this.item = item;
        this.quantitaBlocchi = quantitaBlocchi;
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_RichiestaGamerule(507, CtoS_RichiestaGamerule.TipoRichiesta.MAX_STRUCTURE_BLOCK_COUNT), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void init() {
        super.init();
        this.initFinito = false;
        this.W = this.width;
        this.H = this.height;
        this.CentroX = this.W / 2;
        this.CentroY = this.H / 2;
        if (this.settingsOpen) {
            this.BackButton = AdvancedButton.builder((Component)Component.literal((String)""), button -> this.closeSettings()).pos(this.CentroX + 70, this.CentroY + 17).size(14, 14).defaultImage(new AdvancedButton.Image(TEXTURE, this.CentroX + 70, this.CentroY + 17, 213, 228, 14, 14)).hoverImage(new AdvancedButton.Image(TEXTURE, this.CentroX + 70, this.CentroY + 17, 213, 242, 14, 14)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.scanner.back_button.tooltip"))).build();
            this.CHECKBOX_CREATIVE_BLOCKS = AdvancedButton.builder((Component)Component.literal((String)""), button -> this.changeCreativeBlockCheckBox()).pos(this.CentroX + 70, this.CentroY - 15).size(14, 14).defaultImage(new AdvancedButton.Image(TEXTURE, this.CentroX + 70, this.CentroY - 15, 227, 228, 14, 14)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, this.CentroX + 70, this.CentroY - 15, 227, 242, 14, 14)).build();
            this.addRenderableWidget((GuiEventListener)this.BackButton);
            this.addRenderableWidget((GuiEventListener)this.CHECKBOX_CREATIVE_BLOCKS);
        } else {
            this.editBox = new EditBox(this.font, this.CentroX - 60, this.CentroY - 6, 120, 20, (Component)Component.literal((String)""));
            this.editBox.setMaxLength(25);
            this.editBox.setBordered(true);
            this.editBox.setVisible(true);
            this.editBox.setValue(this.valoreEditBox);
            this.editBox.setCanLoseFocus(true);
            this.editBox.setResponder(this::EditBoxValueChange);
            this.confirmButton = AdvancedButton.builder((Component)Component.literal((String)""), button -> this.CreateBlueprint(button)).pos(this.CentroX - 40, this.CentroY + 12).size(80, 24).defaultImage(new AdvancedButton.Image(TEXTURE, this.CentroX - 40, this.CentroY + 12, 176, 0, 80, 24)).pressedImageTick(new AdvancedButton.Image(TEXTURE, this.CentroX - 40, this.CentroY + 12, 176, 24, 80, 24), 280).fontSize(1.5f).build();
            this.SettingsButton = AdvancedButton.builder((Component)Component.literal((String)""), button -> this.openSettings()).pos(this.CentroX + 69, this.CentroY + 16).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, this.CentroX + 69, this.CentroY + 16, 241, 226, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, this.CentroX + 69, this.CentroY + 16, 241, 241, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.scanner.settings_button.tooltip"))).build();
            this.Label = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.TESTO_Parametri(this.CentroX, this.CentroY - 24, Component.translatable((String)"gui.portable_blueprints.scanner.title_add").getString(), 1.0f, Minecraft.getInstance().font, 0xFFFFFF, false, RenderingMethods.PosizioneTesto.CENTRO, true));
            this.TestoPulsante = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.TESTO_Parametri(this.CentroX, this.CentroY + 24, Component.translatable((String)"gui.portable_blueprints.scanner.button_v2").getString(), 1.5f, Minecraft.getInstance().font, 0, false, RenderingMethods.PosizioneTesto.CENTRO, true));
            this.addRenderableWidget((GuiEventListener)this.editBox);
            this.addRenderableWidget((GuiEventListener)this.confirmButton);
            this.addRenderableWidget((GuiEventListener)this.SettingsButton);
            this.EditBoxValueChange(this.valoreEditBox);
        }
        this.initFinito = true;
    }

    private void EditBoxValueChange(String valore) {
        boolean char_consentiti = true;
        for (char v : valore.toCharArray()) {
            if (CharNonConsentiti.indexOf(v) < 0) continue;
            char_consentiti = false;
            break;
        }
        if (char_consentiti) {
            this.valoreEditBox = valore;
        } else {
            this.editBox.setValue(this.valoreEditBox);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_BlueprintExist(2058, this.editBox.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void CreateBlueprint(AdvancedButton button) {
        if (this.nBlueprintSalvati >= ClientMethods.getRichiestaInteger(508) || this.item == null || this.editBox.getValue().replaceAll(" ", "").equals("")) {
            return;
        }
        new Thread(() -> {
            UUID richiestaID = UUID.randomUUID();
            CtoS_CreateBlueprint.inviaRichiestaNormale(new BlockPos(Operazioni.getVec3iFromString(OldVersionUtilities.getItemStackNBT(this.item).getString("coordinateAngolo1"))), new BlockPos(Operazioni.getVec3iFromString(OldVersionUtilities.getItemStackNBT(this.item).getString("coordinateAngolo2"))), this.editBox.getValue(), SETTINGS_CREATIVE_BLOCKS, richiestaID);
            for (String val : CtoS_CreateBlueprint.creaListaDati(new ArrayList<String>((Collection)ModConfig.ScannerIgnoredBlocks.get()))) {
                CtoS_CreateBlueprint.inviaRichiestaLista(val, richiestaID);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        if (!VisualizeBlueprintDatas.ForzaReloadPerQuesteBlueprints.contains(this.editBox.getValue())) {
            VisualizeBlueprintDatas.ForzaReloadPerQuesteBlueprints.add(this.editBox.getValue());
        }
        this.minecraft.player.closeContainer();
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        gg.blit(TEXTURE, this.CentroX - 87, this.CentroY - 35, 0, 0, 176, 71);
        super.render(gg, mouseX, mouseY, delta);
        if (this.nBlueprintSalvati == -1) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_RichiestaGamerule(508, CtoS_RichiestaGamerule.TipoRichiesta.MAX_BLUEPRINTS_FOR_PLAYER), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_BlueprintQuantity(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.nBlueprintSalvati = ClientMethods.getQuantitaFileBlueprint();
        if (this.CHECKBOX_CREATIVE_BLOCKS != null) {
            this.CHECKBOX_CREATIVE_BLOCKS.PressedImageCondition = SETTINGS_CREATIVE_BLOCKS;
        }
        if (!this.initFinito) {
            return;
        }
        if (this.settingsOpen) {
            RenderingMethods.GuiGraphicsTestoScalato(gg, Component.translatable((String)"gui.portable_blueprints.scanner.checkbox.creative_blocks").getString(), 0.7f, Minecraft.getInstance().font, new Vec2((float)(this.CentroX - 80), (float)(this.CentroY - 12)), 0, false, RenderingMethods.PosizioneTesto.SINISTRA, true);
        } else {
            if (this.nBlueprintSalvati >= ClientMethods.getRichiestaInteger(508) || this.quantitaBlocchi > ClientMethods.getRichiestaInteger(507)) {
                if (this.nBlueprintSalvati >= ClientMethods.getRichiestaInteger(508)) {
                    this.Label.testoParametri.setTesto(Component.translatable((String)"gui.portable_blueprints.scanner.title_max_blueprint_reached").getString().replace("%v%", String.valueOf(ClientMethods.getRichiestaInteger(508))));
                    this.Label.testoParametri.color = 0xFF0000;
                } else {
                    String testo = Component.translatable((String)"gui.portable_blueprints.scanner.title_max_structure_count").getString().replace("%v1%", String.valueOf(this.quantitaBlocchi)).replace("%v2%", String.valueOf(ClientMethods.getRichiestaInteger(507)));
                    this.Label.testoParametri.setTesto(testo.replace("%v2%", String.valueOf(ClientMethods.getRichiestaInteger(507))));
                    this.Label.testoParametri.color = 0xFF0000;
                }
                this.editBox.setEditable(false);
                this.editBox.setVisible(false);
                this.confirmButton.visible = false;
                this.SettingsButton.visible = false;
            } else {
                this.editBox.setEditable(true);
                this.editBox.setVisible(true);
                this.confirmButton.visible = true;
                this.SettingsButton.visible = true;
                if (ClientMethods.getRichiestaBooleana(2058) == 0) {
                    this.editBox.setTextColor(0xFFFFFF);
                    this.TestoPulsante.testoParametri.setTesto(Component.translatable((String)"gui.portable_blueprints.scanner.button_v1").getString());
                    this.Label.testoParametri.setTesto(Component.translatable((String)"gui.portable_blueprints.scanner.title_add").getString());
                    this.Label.testoParametri.color = 0xFFFFFF;
                } else if (ClientMethods.getRichiestaBooleana(2058) == 1) {
                    this.editBox.setTextColor(0xFF0000);
                    this.TestoPulsante.testoParametri.setTesto(Component.translatable((String)"gui.portable_blueprints.scanner.button_v2").getString());
                    this.Label.testoParametri.setTesto(Component.translatable((String)"gui.portable_blueprints.scanner.title_replace").getString());
                    this.Label.testoParametri.color = 0xFF0000;
                }
                this.TestoPulsante.testoParametri.color = this.confirmButton.isMouseOver(mouseX, mouseY) ? 65280 : 0;
                this.TestoPulsante.render(gg);
            }
            this.Label.render(gg);
        }
    }

    public void openSettings() {
        this.settingsOpen = true;
        this.re_init();
    }

    public void closeSettings() {
        this.settingsOpen = false;
        this.re_init();
    }

    private void re_init() {
        while (this.renderables.size() > 0) {
            this.removeWidget((GuiEventListener)this.renderables.get(0));
        }
        this.init();
    }

    public void changeCreativeBlockCheckBox() {
        SETTINGS_CREATIVE_BLOCKS = !SETTINGS_CREATIVE_BLOCKS;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(float partialTick) {
    }
}

