/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.client.screen;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.client.screen.TabletScreen;
import nimble.portable_blueprints.network.SharedBlueprints.CtoS_AddShareWithOthers;
import nimble.portable_blueprints.network.SharedBlueprints.CtoS_RemoveShareWithOthers;
import nimble.portable_blueprints.network.ottieni_shared_blueprint_data.CtoS_SharedBlueprintData;
import nimble.portable_blueprints.robautile.AdvancedButton;
import nimble.portable_blueprints.robautile.AdvancedScrolling;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingMethods;
import nimble.portable_blueprints.robautile.ScrollingText;

public class ShareWithOthersScreenBACKUP
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"textures/gui/player_share_list_gui.png");
    private int CentroX;
    private int CentroY;
    private int W;
    private int H;
    private String nome_bp;
    private short TickCount = 1;
    private boolean loading_complete = false;
    ItemDatiGiocatore[] itemDatiGiocatori = new ItemDatiGiocatore[6];
    List<DatiGiocatore> DatiGiocatori = new ArrayList<DatiGiocatore>();
    private AdvancedScrolling scrolling;
    private double valPrecedenteScroll = 0.0;
    private AdvancedButton B_RELOAD;
    private AdvancedButton B_EXIT;
    private RenderingMethods.GuiGraphicsElement[] LoadingIcon = new RenderingMethods.GuiGraphicsElement[9];
    private RenderingMethods.GuiGraphicsElement Title;
    private ScrollingText TitleScrolling;
    private short nextLoadingIcon = 0;

    public ShareWithOthersScreenBACKUP(String nome_bp) {
        super((Component)Component.empty());
        this.nome_bp = nome_bp;
        this.TitleScrolling = new ScrollingText(Component.translatable((String)"gui.portable_blueprints.share_with-others.title").getString().replace("%v%", nome_bp), 15);
        this.loadPlayerData();
    }

    public void tick() {
        super.tick();
        for (ItemDatiGiocatore idg : this.itemDatiGiocatori) {
            if (idg == null) continue;
            idg.tick(this.TickCount);
        }
        if (this.TickCount % 10 == 0) {
            this.nextLoadingIcon = (short)(this.nextLoadingIcon + 1);
            if (this.nextLoadingIcon >= this.LoadingIcon.length) {
                this.nextLoadingIcon = 0;
            }
            for (int x = 0; x < this.LoadingIcon.length; ++x) {
                if (this.LoadingIcon[x] == null) continue;
                this.LoadingIcon[x].blitParametri.offsetY = x == this.nextLoadingIcon ? 0 : 11;
            }
        }
        if (this.TickCount % 5 == 0) {
            this.TitleScrolling.update();
        }
        if ((this.TickCount = (short)(this.TickCount + 1)) > 20) {
            this.TickCount = 1;
        }
    }

    protected void init() {
        super.init();
        this.W = this.width;
        this.H = this.height;
        this.CentroX = this.W / 2;
        this.CentroY = this.H / 2;
        this.scrolling = new AdvancedScrolling(this.CentroX + 48, this.CentroY, 12, 15, new AdvancedScrolling.Image(TEXTURE, 0, 0, 232, 0, 12, 15), new AdvancedScrolling.Image(TEXTURE, 0, 0, 244, 0, 12, 15), this.CentroY - 27 - 34 + 8, this.CentroY + 58 - 34 + 28);
        this.addRenderableWidget((GuiEventListener)this.scrolling);
        this.B_RELOAD = AdvancedButton.builder((Component)Component.literal((String)""), button -> this.loadPlayerData()).pos(this.CentroX - 60, this.CentroY - 71).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, this.CentroX - 60, this.CentroY - 71, 188, 0, 15, 15)).pressedImageTick(new AdvancedButton.Image(TEXTURE, this.CentroX - 60, this.CentroY - 71, 188, 30, 15, 15), 280).hoverImage(new AdvancedButton.Image(TEXTURE, this.CentroX - 60, this.CentroY - 71, 188, 15, 15, 15)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.share_with-others.button_reload"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_RELOAD);
        this.B_EXIT = AdvancedButton.builder((Component)Component.literal((String)""), button -> this.B_Exit()).pos(this.CentroX + 47, this.CentroY - 70).size(14, 14).defaultImage(new AdvancedButton.Image(TEXTURE, this.CentroX + 47, this.CentroY - 70, 218, 0, 14, 14)).hoverImage(new AdvancedButton.Image(TEXTURE, this.CentroX + 47, this.CentroY - 70, 218, 14, 14, 14)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.portable_blueprints.share_with-others.button_exit"))).build();
        this.addRenderableWidget((GuiEventListener)this.B_EXIT);
        this.Title = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.TESTO_Parametri(this.CentroX, this.CentroY - 63, this.TitleScrolling.TestoVisualizzabile, 1.0f, Minecraft.getInstance().font, 0, false, RenderingMethods.PosizioneTesto.CENTRO, true));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.LoadingIcon[x + y * 3] = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.BLIT_Parametri(this.CentroX - 30 + x * 17, this.CentroY - 20 + y * 19, 178, 11, 10, 11, TEXTURE));
            }
        }
        this.generaListaPlayer();
    }

    private void B_Exit() {
        Minecraft.getInstance().setScreen((Screen)new TabletScreen());
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (this.valPrecedenteScroll != this.scrolling.getValue()) {
            this.valPrecedenteScroll = this.scrolling.getValue();
            this.generaListaPlayer();
        }
        gg.blit(TEXTURE, this.CentroX - 66, this.CentroY - 75, 0, 0, 133, 151);
        try {
            for (ItemDatiGiocatore idg : this.itemDatiGiocatori) {
                if (idg == null) continue;
                idg.preRender(gg);
            }
            super.render(gg, mouseX, mouseY, delta);
            for (ItemDatiGiocatore idg : this.itemDatiGiocatori) {
                if (idg == null) continue;
                idg.render(gg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.loading_complete) {
            for (int x = 0; x < this.LoadingIcon.length; ++x) {
                if (this.LoadingIcon[x] == null) continue;
                this.LoadingIcon[x].render(gg);
            }
        }
        this.Title.testoParametri.setTesto(this.TitleScrolling.TestoVisualizzabile);
        this.Title.render(gg);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrolling != null) {
            this.scrolling._mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrolling != null) {
            this.scrolling._mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double v) {
        if (this.scrolling != null) {
            this.scrolling._mouseScrolled(mouseX, mouseY, delta, v);
        }
        return super.mouseScrolled(mouseX, mouseY, delta, v);
    }

    public void generaListaPlayer() {
        int x;
        if (!this.loading_complete) {
            return;
        }
        for (x = 0; x < this.itemDatiGiocatori.length; ++x) {
            if (this.itemDatiGiocatori[x] == null) continue;
            this.removeWidget((GuiEventListener)this.itemDatiGiocatori[x].ShareButton);
        }
        this.itemDatiGiocatori = new ItemDatiGiocatore[6];
        x = (int)Math.floor((double)(this.DatiGiocatori.size() - 6) * this.scrolling.getValue());
        if (x < 0) {
            x = 0;
        }
        for (int ripetizioni = 0; ripetizioni < this.itemDatiGiocatori.length && x < this.DatiGiocatori.size() && ripetizioni < this.itemDatiGiocatori.length; ++x, ++ripetizioni) {
            this.itemDatiGiocatori[ripetizioni] = new ItemDatiGiocatore(this.DatiGiocatori.get(x), this.CentroX - 59, this.CentroY - 53 + ripetizioni * 20);
            this.addRenderableWidget((GuiEventListener)this.itemDatiGiocatori[ripetizioni].ShareButton);
        }
    }

    public void loadPlayerData() {
        this.loading_complete = false;
        for (int x = 0; x < this.itemDatiGiocatori.length; ++x) {
            if (this.itemDatiGiocatori[x] == null) continue;
            this.removeWidget((GuiEventListener)this.itemDatiGiocatori[x].ShareButton);
            this.itemDatiGiocatori[x] = null;
        }
        this.DatiGiocatori.clear();
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SharedBlueprintData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Thread tickerThread = new Thread(() -> {
            try {
                Thread.sleep(200L);
                List<UUID> SharedWithPlayers = ClientMethods.SharedWithMeBlueprints.getAllSpecificSWOBPlayersUUID(this.nome_bp);
                for (UUID shared_with : SharedWithPlayers) {
                    this.DatiGiocatori.add(new DatiGiocatore(this, true, shared_with));
                    Thread.sleep(5L);
                }
                for (PlayerInfo info : Minecraft.getInstance().getConnection().getOnlinePlayers()) {
                    if (Minecraft.getInstance().player.getUUID().equals(info.getProfile().getId()) || SharedWithPlayers.contains(info.getProfile().getId())) continue;
                    this.DatiGiocatori.add(new DatiGiocatore(this, false, info.getProfile().getId()));
                    Thread.sleep(25L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.loading_complete = true;
            this.generaListaPlayer();
        });
        tickerThread.setDaemon(true);
        tickerThread.start();
    }

    private void SetShare(DatiGiocatore datiGiocatore) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SharedBlueprintData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (ClientMethods.SharedWithMeBlueprints.ContieneSWOBlueprint(datiGiocatore.uuid_Player, this.nome_bp)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_RemoveShareWithOthers(this.nome_bp, Minecraft.getInstance().player.getUUID(), datiGiocatore.uuid_Player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_AddShareWithOthers(this.nome_bp, Minecraft.getInstance().player.getUUID(), datiGiocatore.uuid_Player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_SharedBlueprintData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.generaListaPlayer();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void onClose() {
        super.onClose();
    }

    public class ItemDatiGiocatore {
        final int posX;
        final int posY;
        final DatiGiocatore datiGiocatore;
        ScrollingText scrollingNome;
        public RenderingMethods.GuiGraphicsElement NOME;
        public AdvancedButton ShareButton;

        public ItemDatiGiocatore(DatiGiocatore datiGiocatore, int posX, int posY) {
            this.datiGiocatore = datiGiocatore;
            this.posX = posX;
            this.posY = posY;
            this.scrollingNome = new ScrollingText(datiGiocatore.nome, 10);
            this.NOME = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.TESTO_Parametri(this.posX + 2, this.posY + 6, this.scrollingNome.TestoVisualizzabile, 1.0f, Minecraft.getInstance().font, 0xFFFFFF, false, RenderingMethods.PosizioneTesto.SINISTRA, true));
            this.ShareButton = AdvancedButton.builder((Component)Component.empty(), button -> ShareWithOthersScreenBACKUP.this.SetShare(datiGiocatore)).pos(this.posX + 64, this.posY + 3).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, this.posX + 64, this.posY + 3, 203, 0, 15, 15)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, this.posX + 64, this.posY + 3, 203, 15, 15, 15)).build();
            this.ShareButton.PressedImageCondition = datiGiocatore.isShared;
        }

        public void preRender(GuiGraphics gg) {
            gg.blit(TEXTURE, this.posX, this.posY, 0, 236, 100, 20);
        }

        public void render(GuiGraphics gg) {
            if (this.datiGiocatore.ImageFaccia != null) {
                for (int x = 0; x < this.datiGiocatore.ImageFaccia.getWidth(); ++x) {
                    for (int y = 0; y < this.datiGiocatore.ImageFaccia.getHeight(); ++y) {
                        int color = this.datiGiocatore.ImageFaccia.getRGB(x, y);
                        int addX = 2 * x + this.posX + 81;
                        int addY = 2 * y + this.posY + 2;
                        gg.fill(addX, addY, addX + 2, addY + 2, color);
                    }
                }
            }
            this.ShareButton.PressedImageCondition = ClientMethods.SharedWithMeBlueprints.ContieneSWOBlueprint(this.datiGiocatore.uuid_Player, ShareWithOthersScreenBACKUP.this.nome_bp);
            this.NOME.render(gg);
        }

        public void tick(short tickCount) {
            if (tickCount % 5 == 0) {
                this.scrollingNome.update();
                this.NOME.testoParametri.setTesto(this.scrollingNome.TestoVisualizzabile);
            }
        }
    }

    public class DatiGiocatore {
        final boolean isShared;
        final BufferedImage ImageFaccia;
        final UUID uuid_Player;
        final String nome;

        public DatiGiocatore(ShareWithOthersScreenBACKUP this$0, boolean isShared, UUID uuidPlayer) {
            String nome1 = "";
            this.isShared = isShared;
            this.uuid_Player = uuidPlayer;
            this.ImageFaccia = Operazioni.getPlayerFace(uuidPlayer);
            String v = Operazioni.getPlayerNameFromUUID(uuidPlayer);
            if (v == null) {
                boolean trovato = false;
                for (PlayerInfo p : Minecraft.getInstance().getConnection().getOnlinePlayers()) {
                    if (!p.getProfile().getId().equals(uuidPlayer)) continue;
                    nome1 = p.getProfile().getName();
                    trovato = true;
                    break;
                }
                if (!trovato) {
                    nome1 = Component.translatable((String)"gui.portable_blueprints.share_with-others.name_not_found").getString();
                }
            } else {
                nome1 = v;
            }
            this.nome = nome1;
        }
    }
}

