/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;

@EventBusSubscriber(modid="portable_blueprints")
public class BlueprintServerCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blueprintserver").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"free").executes(ctx -> {
            BlueprintServerCommand.setServerBlueprint(((CommandSourceStack)ctx.getSource()).getLevel(), true, ((CommandSourceStack)ctx.getSource()).getPlayer());
            return 1;
        }))).then(Commands.literal((String)"permission").executes(ctx -> {
            BlueprintServerCommand.setServerBlueprint(((CommandSourceStack)ctx.getSource()).getLevel(), false, ((CommandSourceStack)ctx.getSource()).getPlayer());
            return 1;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"param", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (String perm : BlueprintServerCommand.blueprintEsistenti(((CommandSourceStack)ctx.getSource()).getLevel())) {
                builder.suggest(perm);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String param = StringArgumentType.getString((CommandContext)ctx, (String)"param");
            BlueprintServerCommand.removeServerBlueprint(((CommandSourceStack)ctx.getSource()).getLevel(), ((CommandSourceStack)ctx.getSource()).getPlayer(), param);
            return 1;
        })))).then(Commands.literal((String)"permission").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"blueprint", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (String perm : BlueprintServerCommand.blueprintEsistenti(((CommandSourceStack)ctx.getSource()).getLevel())) {
                builder.suggest(perm);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"allowed", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            String permission = StringArgumentType.getString((CommandContext)ctx, (String)"blueprint");
            boolean allowed = BoolArgumentType.getBool((CommandContext)ctx, (String)"allowed");
            BlueprintServerCommand.setPlayerPermissionForServerBlueprint(((CommandSourceStack)ctx.getSource()).getLevel(), ((CommandSourceStack)ctx.getSource()).getPlayer(), player, permission, allowed);
            return 1;
        }))))));
    }

    private static void setServerBlueprint(ServerLevel level, boolean isFree, ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (player.getMainHandItem().getItem().equals(ModItems.BLUEPRINT.get())) {
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(player.getMainHandItem());
            if (nbt.contains("owner") && nbt.contains("nome")) {
                if (nbt.getString("nome").contains("[Global]")) {
                    if (player != null) {
                        player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.set_global_error").withStyle(ChatFormatting.RED), false);
                    }
                    return;
                }
                boolean successo = BlueprintServerCommand.addServerBlueprint(level, nbt.getString("nome"), nbt.getString("owner"));
                if (!successo) {
                    if (player != null) {
                        player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.not_found").withStyle(ChatFormatting.RED), false);
                    }
                    return;
                }
                BlueprintServerCommand.addBlueprintPermission(level, nbt.getString("nome"), isFree);
                if (player != null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.set_success").withStyle(ChatFormatting.GREEN), false);
                }
            } else if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.not_valid_item").withStyle(ChatFormatting.RED), false);
            }
        } else if (player != null) {
            player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.no_item").withStyle(ChatFormatting.RED), false);
        }
    }

    private static boolean addServerBlueprint(ServerLevel level, String nome, String owner) {
        File folderServerBlueprints = new File(Blueprint.getServerBlueprintFile(level), nome + ".bp");
        File original = null;
        for (File file : Blueprint.getFileForBlueprints(level, UUID.fromString(owner)).listFiles()) {
            if (!file.getName().equals(nome + ".bp")) continue;
            original = file;
            break;
        }
        if (original != null) {
            try {
                Files.copy(original.toPath(), folderServerBlueprints.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void addBlueprintPermission(ServerLevel level, String nome, boolean isfree) {
        try {
            File permissionFile = Blueprint.getServerPremissionFile(level);
            Blueprint.BlueprintPermission bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
            bp.addServerBlueprintPermission(nome, isfree);
            try (FileWriter writer = new FileWriter(permissionFile);){
                GSON.toJson((Object)bp, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeServerBlueprint(ServerLevel level, ServerPlayer player, String nome) {
        File blueprintFile = null;
        for (File file : Blueprint.getServerBlueprintFile(level).listFiles()) {
            if (!file.getName().equals(nome + ".bp")) continue;
            blueprintFile = file;
            break;
        }
        if (blueprintFile != null) {
            if (blueprintFile.delete()) {
                try {
                    File permissionFile = Blueprint.getServerPremissionFile(level);
                    Blueprint.BlueprintPermission bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
                    bp.removeServerBlueprintPermission(nome);
                    try (FileWriter writer = new FileWriter(permissionFile);){
                        GSON.toJson((Object)bp, (Appendable)writer);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (player != null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.delete_success").withStyle(ChatFormatting.GREEN), false);
                }
            } else if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.delete_error").withStyle(ChatFormatting.RED), false);
            }
        } else if (player != null) {
            player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.not_found").withStyle(ChatFormatting.RED), false);
        }
    }

    private static List<String> blueprintEsistenti(ServerLevel level) {
        ArrayList<String> nomi = new ArrayList<String>();
        for (File file : Blueprint.getServerBlueprintFile(level).listFiles()) {
            nomi.add(file.getName().replace(".bp", ""));
        }
        return nomi;
    }

    private static void setPlayerPermissionForServerBlueprint(ServerLevel level, ServerPlayer player, ServerPlayer target, String nome, boolean hasPermission) {
        block11: {
            try {
                File permissionFile = Blueprint.getServerPremissionFile(level);
                Blueprint.BlueprintPermission bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
                bp.setPermissionForPlayer(target, nome, hasPermission);
                try (FileWriter writer = new FileWriter(permissionFile);){
                    GSON.toJson((Object)bp, (Appendable)writer);
                    if (player != null) {
                        player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.set_player_permission_success").withStyle(ChatFormatting.GREEN), false);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (player != null) {
                        player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.set_player_permission_error").withStyle(ChatFormatting.RED), false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (player == null) break block11;
                player.sendSystemMessage((Component)Component.translatable((String)"command.portable_blueprints.blueprintserver.set_player_permission_error").withStyle(ChatFormatting.RED), false);
            }
        }
    }
}

